/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.winsys;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.spi.ExecProject;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.wizard.winsys.BasicSettingsPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.winsys.NewTCIterator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public final class DesignSupport
implements TaskListener,
Runnable {
    private final Project project;
    private final JButton toEnable;
    private final AtomicReference<FileObject> userDir;

    private DesignSupport(Project p, JButton toEnable, AtomicReference<FileObject> ud) {
        this.project = p;
        this.toEnable = toEnable;
        this.userDir = ud;
    }

    static boolean isDesignModeSupported(NbModuleProvider info) {
        try {
            SpecificationVersion current = info.getDependencyVersion("org.openide.windows");
            if (current == null) {
                return false;
            }
            return current.compareTo((Object)new SpecificationVersion("6.45")) >= 0;
        }
        catch (IOException ex) {
            Logger.getLogger(NewTCIterator.class.getName()).log(Level.INFO, null, ex);
            return false;
        }
    }

    static JComponent warningPanel() throws MissingResourceException {
        JTextArea a = new JTextArea();
        a.setEditable(false);
        a.setText(NbBundle.getMessage(BasicSettingsPanel.class, (String)"MSG_ReallyLaunch", (Object[])new Object[0]));
        a.setOpaque(false);
        return a;
    }

    public static Task invokeDesignMode(Project prj, AtomicReference<FileObject> userDir) throws IOException {
        return DesignSupport.invokeDesignMode(prj, userDir, true, true);
    }

    static Task invokeDesignMode(Project prj, AtomicReference<FileObject> userDir, boolean warn, boolean warnPrevResult) throws IOException {
        File path;
        FileObject fo;
        ExecProject es = (ExecProject)prj.getLookup().lookup(ExecProject.class);
        if (es == null) {
            throw new IOException("Project " + prj.getProjectDirectory() + " does not support execution!");
        }
        if (warn) {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)DesignSupport.warningPanel());
            nd.setOptions(new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.CANCEL_OPTION});
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) != NotifyDescriptor.YES_OPTION) {
                return null;
            }
        }
        if ((fo = FileUtil.toFileObject((File)(path = new File(((NbModuleProvider)prj.getLookup().lookup(NbModuleProvider.class)).getClassesDirectory().getParentFile(), "designdir")))) != null) {
            if (warnPrevResult) {
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(BasicSettingsPanel.class, (String)"MSG_AlreadyLaunched", (Object[])new Object[0]));
                nd.setOptionType(2);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) != NotifyDescriptor.OK_OPTION) {
                    return null;
                }
            }
            fo.delete();
        }
        fo = FileUtil.createFolder((File)path);
        userDir.set(fo);
        return es.execute(new String[]{"--nosplash", "-J-Dorg.netbeans.core.WindowSystem.designMode=true", "--userdir " + path});
    }

    @CheckForNull
    static Set<String> existingModes(NewTCIterator.DataModel data) throws IOException {
        FileSystem fs = ((NbModuleProvider)data.getProject().getLookup().lookup(NbModuleProvider.class)).getEffectiveSystemFilesystem();
        data.setSFS(fs);
        FileObject foRoot = fs.getRoot().getFileObject("Windows2/Modes");
        if (foRoot != null) {
            FileObject[] fos = foRoot.getChildren();
            TreeSet<String> col = new TreeSet<String>();
            for (FileObject fo : fos) {
                if (!fo.isData() || !"wsmode".equals(fo.getExt())) continue;
                col.add(fo.getName());
                data.existingMode(fo.getName());
            }
            return col;
        }
        return null;
    }

    public static String readMode(FileObject fo) throws IOException {
        InputStream is = fo.getInputStream();
        try {
            StringWriter w = new StringWriter();
            StreamSource t = new StreamSource(DesignSupport.class.getResourceAsStream("polishing.xsl"));
            Transformer tr = TransformerFactory.newInstance().newTransformer(t);
            StreamSource s = new StreamSource(is);
            StreamResult r = new StreamResult(w);
            tr.transform(s, r);
            String string = w.toString();
            return string;
        }
        catch (TransformerException ex) {
            throw new IOException(ex);
        }
        finally {
            is.close();
        }
    }

    public static void redefineLayout(Project p, JButton toEnable) {
        try {
            AtomicReference<FileObject> userDir = new AtomicReference<FileObject>();
            Task task = DesignSupport.invokeDesignMode(p, userDir);
            if (task == null) {
                toEnable.setEnabled(true);
            }
            task.addTaskListener((TaskListener)new DesignSupport(p, toEnable, userDir));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void taskFinished(Task task) {
        FileObject modeDir = this.userDir.get().getFileObject("config/Windows2Local/Modes");
        if (modeDir != null) {
            StringBuilder sb = new StringBuilder();
            try {
                FileSystem layer = DesignSupport.findLayer(this.project);
                if (layer == null) {
                    throw new IOException("Cannot find layer in " + this.project);
                }
                for (FileObject m : modeDir.getChildren()) {
                    if (!m.isData() || !"wsmode".equals(m.getExt())) continue;
                    String name = "Windows2/Modes/" + m.getNameExt();
                    FileObject mode = FileUtil.createData((FileObject)layer.getRoot(), (String)name);
                    OutputStream os = mode.getOutputStream();
                    os.write(DesignSupport.readMode(m).getBytes("UTF-8"));
                    os.close();
                    sb.append(name).append("\n");
                }
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(DesignSupport.class, (String)"MSG_ModesGenerated", (Object[])new Object[]{sb}), 1);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        EventQueue.invokeLater(this);
    }

    @Override
    public void run() {
        this.toEnable.setEnabled(true);
    }

    static FileSystem findLayer(Project p) throws IOException {
        NbModuleProvider nbmp = (NbModuleProvider)p.getLookup().lookup(NbModuleProvider.class);
        return nbmp != null ? nbmp.getEffectiveSystemFilesystem() : null;
    }
}

