/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.AID;
import com.sun.javacard.offcardverifier.AIDintf;
import com.sun.javacard.offcardverifier.AppletInfo;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassAndMethodDescriptor;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.Methodref;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Type;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AppletComponent
extends Safeptr {
    private Hashtable<ClassDescriptor, AppletInfo> appletsInCap = new Hashtable();
    int multiSelectableAppletCount = 0;
    private static TypeMethod installMethodType = new TypeMethod(Type.ByteArray, Type.Short, Type.Byte, Type.Void);

    AppletComponent(byte[] byArray) {
        super(byArray, "Applet");
    }

    int count() {
        return this.u1(0);
    }

    AppletInfo appletInfo() {
        return new AppletInfo(this.offset(1));
    }

    void verify() {
        if (Verifier.verbose >= 2) {
            Messages.println("AppletComponent.100");
        }
        Vector<AppletInfo> vector = new Vector<AppletInfo>();
        AppletInfo appletInfo = this.appletInfo();
        for (int i = this.count(); i > 0; --i) {
            this.verifyApplet(appletInfo, vector);
            appletInfo = appletInfo.next();
        }
        if (this.multiSelectableAppletCount != 0 && this.multiSelectableAppletCount != this.count()) {
            throw new VerifierError("AppletComponent.8");
        }
        if (!appletInfo.atComponentEnd()) {
            throw new VerifierError("AppletComponent.1");
        }
    }

    private void verifyApplet(AppletInfo appletInfo, Vector<AppletInfo> vector) {
        if (!AID.isValid(appletInfo)) {
            throw new VerifierError("AppletComponent.3", appletInfo.AID_length());
        }
        if (!AID.sameRID(appletInfo, Cap.Header.thisPackage())) {
            throw new VerifierError("AppletComponent.4");
        }
        if (AID.same((AIDintf)appletInfo, Cap.Header.thisPackage())) {
            throw new VerifierError("AppletComponent.6");
        }
        for (AppletInfo object2 : vector) {
            AppletInfo appletInfo2 = object2;
            if (!AID.same((AIDintf)appletInfo, appletInfo2)) continue;
            throw new VerifierError("AppletComponent.7", AID.pretty(appletInfo));
        }
        vector.add(appletInfo);
        ClassAndMethodDescriptor classAndMethodDescriptor = Methodref.checkInternalStaticRef(appletInfo.installMethod());
        TypeMethod typeMethod = TypeMethod.parseCap(Cap.TypeDescr.at(classAndMethodDescriptor.methodDescr.type()));
        if (!typeMethod.equals(installMethodType)) {
            throw new VerifierError("AppletComponent.2", typeMethod);
        }
        if (!Classref.isSubclass(classAndMethodDescriptor.classDescr.thisClass(), Classref.refForName("javacard/framework/Applet"))) {
            throw new VerifierError("AppletComponent.5");
        }
        if (Classref.isMultiSelectable(classAndMethodDescriptor.classDescr.thisClass())) {
            ++this.multiSelectableAppletCount;
        }
        this.appletsInCap.put(classAndMethodDescriptor.classDescr, appletInfo);
    }

    public boolean isAppletClass(ClassDescriptor classDescriptor) {
        Enumeration<ClassDescriptor> enumeration = this.appletsInCap.keys();
        while (enumeration.hasMoreElements()) {
            ClassDescriptor classDescriptor2 = enumeration.nextElement();
            if (classDescriptor2.thisClass() != classDescriptor.thisClass()) continue;
            return true;
        }
        return false;
    }

    public AppletInfo getAppletInfoForClass(ClassDescriptor classDescriptor) {
        Enumeration<ClassDescriptor> enumeration = this.appletsInCap.keys();
        while (enumeration.hasMoreElements()) {
            ClassDescriptor classDescriptor2 = enumeration.nextElement();
            if (classDescriptor2.thisClass() != classDescriptor.thisClass()) continue;
            return this.appletsInCap.get(classDescriptor2);
        }
        return null;
    }

    public boolean isInstallMethod(MethodDescriptor methodDescriptor) {
        int n = methodDescriptor.methodOffset();
        int n2 = this.count();
        AppletInfo appletInfo = this.appletInfo();
        for (int i = 0; i < n2; ++i) {
            if (appletInfo.installMethod() == n) {
                return true;
            }
            appletInfo = appletInfo.next();
        }
        return false;
    }
}

