/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.netbeans.modules.dlight.libs.common.DLightLibsCommonLogger;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionListener;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.nativeexecution.api.util.RemoteStatistics;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.DirEntry;
import org.netbeans.modules.remote.impl.fs.DirEntryImpl;
import org.netbeans.modules.remote.impl.fs.DirEntryList;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemManager;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemTransport;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.impl.fs.server.Buffer;
import org.netbeans.modules.remote.impl.fs.server.FSSDispatcher;
import org.netbeans.modules.remote.impl.fs.server.FSSRequest;
import org.netbeans.modules.remote.impl.fs.server.FSSRequestKind;
import org.netbeans.modules.remote.impl.fs.server.FSSResponse;
import org.netbeans.modules.remote.impl.fs.server.FSSResponseKind;
import org.netbeans.modules.remote.impl.fs.server.FSSUtil;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.util.RequestProcessor;

public class FSSTransport
extends RemoteFileSystemTransport
implements ConnectionListener {
    private static final Map<ExecutionEnvironment, FSSTransport> instances = new HashMap<ExecutionEnvironment, FSSTransport>();
    private static final Object instancesLock = new Object();
    public static final boolean USE_FS_SERVER = RemoteFileSystemUtils.getBoolean("remote.fs_server", true);
    public static final boolean VERBOSE_RESPONSE = Boolean.getBoolean("remote.fs_server.verbose.response");
    public static final int DEFAULT_TIMEOUT = Integer.getInteger("remote.fs_server.default.timeout", 6000);
    private final ExecutionEnvironment env;
    private final FSSDispatcher dispatcher;
    private final AtomicInteger dirReadCnt = new AtomicInteger(0);
    private final AtomicInteger warmupCnt = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSSTransport getInstance(ExecutionEnvironment env) {
        if (!USE_FS_SERVER) {
            return null;
        }
        Object object = instancesLock;
        synchronized (object) {
            FSSTransport instance = instances.get(env);
            if (instance == null) {
                instance = new FSSTransport(env);
                instances.put(env, instance);
                ConnectionManager.getInstance().addConnectionListener((ConnectionListener)instance);
            }
            return instance;
        }
    }

    private FSSTransport(ExecutionEnvironment env) {
        this.env = env;
        this.dispatcher = FSSDispatcher.getInstance(env);
    }

    @Override
    public boolean isValidFast() {
        return this.dispatcher.isValidFast();
    }

    @Override
    protected boolean isValidSlow() throws ConnectException, InterruptedException, CancellationException {
        if (!this.dispatcher.isValidFast()) {
            return false;
        }
        try {
            return this.dispatcher.isValidSlow();
        }
        catch (ConnectionManager.CancellationException ex) {
            throw new CancellationException(ex.getMessage());
        }
    }

    @Override
    protected DirEntry stat(String path) throws TimeoutException, ConnectException, IOException, InterruptedException, ExecutionException {
        try {
            return this.stat_or_lstat(path, false, 0);
        }
        catch (TimeoutException ex) {
            RemoteFileSystemUtils.reportUnexpectedTimeout(ex, path);
            throw ex;
        }
    }

    @Override
    protected DirEntry stat(String path, int timeoutMillis) throws TimeoutException, ConnectException, IOException, InterruptedException, ExecutionException {
        return this.stat_or_lstat(path, false, timeoutMillis);
    }

    @Override
    protected DirEntry lstat(String path) throws TimeoutException, ConnectException, IOException, InterruptedException, ExecutionException {
        try {
            return this.stat_or_lstat(path, true, 0);
        }
        catch (TimeoutException ex) {
            RemoteFileSystemUtils.reportUnexpectedTimeout(ex, path);
            throw ex;
        }
    }

    @Override
    protected DirEntry lstat(String path, int timeoutMillis) throws TimeoutException, ConnectException, IOException, InterruptedException, ExecutionException {
        return this.stat_or_lstat(path, true, timeoutMillis);
    }

    private DirEntry stat_or_lstat(String path, boolean lstat, int timeoutMillis) throws TimeoutException, ConnectException, IOException, InterruptedException, ExecutionException {
        FSSResponse.Package pkg;
        block6: {
            DirEntry dirEntry;
            RemoteStatistics.ActivityID activityID;
            long time;
            FSSRequest request;
            block7: {
                if (path.isEmpty()) {
                    path = "/";
                }
                FSSRequestKind requestKind = lstat ? FSSRequestKind.FS_REQ_LSTAT : FSSRequestKind.FS_REQ_STAT;
                request = new FSSRequest(requestKind, path);
                time = System.currentTimeMillis();
                activityID = RemoteStatistics.startChannelActivity((CharSequence)(lstat ? "fs_server_lstat" : "fs_server_stat"), (CharSequence[])new CharSequence[]{path});
                FSSResponse response = null;
                try {
                    RemoteLogger.finest("Sending stat/lstat request #{0} for {1} to fs_server", request.getId(), path);
                    response = this.dispatcher.dispatch(request);
                    pkg = response.getNextPackage(timeoutMillis);
                    if (pkg.getKind() != FSSResponseKind.FS_RSP_ENTRY) break block6;
                    dirEntry = this.createDirEntry(pkg, request.getId(), this.env);
                    if (response == null) break block7;
                    response.dispose();
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        response.dispose();
                    }
                    RemoteStatistics.stopChannelActivity((RemoteStatistics.ActivityID)activityID, (long)0L);
                    RemoteLogger.finest("Getting stat/lstat #{0} from fs_server for {1} took {2} ms", request.getId(), path, System.currentTimeMillis() - time);
                    throw throwable;
                }
            }
            RemoteStatistics.stopChannelActivity((RemoteStatistics.ActivityID)activityID, (long)0L);
            RemoteLogger.finest("Getting stat/lstat #{0} from fs_server for {1} took {2} ms", request.getId(), path, System.currentTimeMillis() - time);
            return dirEntry;
        }
        if (pkg.getKind() == FSSResponseKind.FS_RSP_ERROR) {
            IOException ioe = this.createIOException(pkg);
            throw new ExecutionException(ioe);
        }
        throw new IllegalStateException("wrong response: " + pkg);
    }

    private String timeoutMessage(String operation, int timeoutMillis, String path) {
        return String.format("Timeout %d ms when %s for %s:%s", timeoutMillis, operation, this.env, path);
    }

    @Override
    protected boolean canCopy(String from, String to) {
        return true;
    }

    @Override
    protected DirEntryList copy(String from, String to, Collection<IOException> subdirectoryExceptions) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        FSSResponse.Package pkg;
        long time;
        RemoteStatistics.ActivityID activityID;
        FSSResponse response;
        FSSRequest request;
        block11: {
            request = new FSSRequest(FSSRequestKind.FS_REQ_COPY, from, to);
            response = null;
            activityID = RemoteStatistics.startChannelActivity((CharSequence)"fs_server_copy", (CharSequence[])new CharSequence[]{from, to});
            time = System.currentTimeMillis();
            RemoteLogger.finest("Sending request #{0} for copying {1} to {2} to fs_server", request.getId(), from, to);
            response = this.dispatcher.dispatch(request);
            pkg = response.getNextPackage();
            while (pkg.getKind() == FSSResponseKind.FS_RSP_ERROR) {
                IOException ex = this.createIOException(pkg);
                subdirectoryExceptions.add(ex);
                pkg = response.getNextPackage();
            }
            if (pkg.getKind() == FSSResponseKind.FS_RSP_END) {
                if (subdirectoryExceptions.isEmpty()) {
                    throw new IOException("Unexpected package list end");
                }
                throw subdirectoryExceptions.iterator().next();
            }
            if (pkg.getKind() != FSSResponseKind.FS_RSP_LS) break block11;
            DirEntryList dirEntryList = this.readEntries(response, to, request.getId(), this.dirReadCnt);
            RemoteStatistics.stopChannelActivity((RemoteStatistics.ActivityID)activityID, (long)0L);
            RemoteLogger.finest("Communication #{0} with fs_server for copying {1} to {2} took {3} ms", request.getId(), from, to, System.currentTimeMillis() - time);
            if (response != null) {
                response.dispose();
            }
            return dirEntryList;
        }
        try {
            try {
                throw new IOException("Unexpected package kind: " + (Object)((Object)pkg.getKind()));
            }
            catch (ExecutionException ex) {
                if (RemoteFileSystemUtils.isFileNotFoundException(ex)) {
                    throw new FileNotFoundException(from + " or " + to);
                }
                throw new IOException(ex);
            }
        }
        catch (Throwable throwable) {
            RemoteStatistics.stopChannelActivity((RemoteStatistics.ActivityID)activityID, (long)0L);
            RemoteLogger.finest("Communication #{0} with fs_server for copying {1} to {2} took {3} ms", request.getId(), from, to, System.currentTimeMillis() - time);
            if (response != null) {
                response.dispose();
            }
            throw throwable;
        }
    }

    @Override
    protected boolean canMove(String from, String to) {
        return true;
    }

    @Override
    protected RemoteFileSystemTransport.MoveInfo move(String from, String to) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        Future f = FileInfoProvider.move((ExecutionEnvironment)this.env, (String)from, (String)to);
        f.get();
        String fromParent = PathUtilities.getDirName((String)from);
        DirEntryList fromList = this.readDirectory(fromParent == null ? "/" : fromParent);
        String toParent = PathUtilities.getDirName((String)to);
        DirEntryList toList = this.readDirectory(toParent == null ? "/" : toParent);
        return new RemoteFileSystemTransport.MoveInfo(fromList, toList);
    }

    private IOException createIOException(FSSResponse.Package pkg) {
        Buffer buf = pkg.getBuffer();
        buf.getChar();
        buf.getInt();
        int errno = buf.getInt();
        String emsg = buf.getRest();
        IOException ioe = FSSUtil.createIOException(errno, emsg, this.env);
        return ioe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DirEntryList readDirectory(String path) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        DirEntryList dirEntryList;
        if (path.isEmpty()) {
            path = "/";
        }
        FSSRequest request = new FSSRequest(FSSRequestKind.FS_REQ_LS, path);
        long time = System.currentTimeMillis();
        RemoteStatistics.ActivityID activityID = RemoteStatistics.startChannelActivity((CharSequence)"fs_server_ls", (CharSequence[])new CharSequence[]{path});
        AtomicInteger realCnt = new AtomicInteger(0);
        FSSResponse response = null;
        try {
            RemoteLogger.finest("Sending request #{0} for directory {1} to fs_server", request.getId(), path);
            response = this.dispatcher.dispatch(request);
            FSSResponse.Package pkg = response.getNextPackage();
            assert (pkg.getKind() == FSSResponseKind.FS_RSP_LS) : "Wrong package kind: " + (Object)((Object)pkg.getKind());
            Buffer buf = pkg.getBuffer();
            buf.getChar();
            int respId = buf.getInt();
            assert (respId == request.getId());
            String serverPath = buf.getString();
            if (!serverPath.equals(path)) {
                DLightLibsCommonLogger.assertTrue((boolean)false, (String)("Unexpected path in response: \"" + serverPath + "\" expected \"" + path + "\""));
            }
            dirEntryList = this.readEntries(response, path, request.getId(), realCnt);
            this.dirReadCnt.incrementAndGet();
        }
        catch (Throwable throwable) {
            this.dirReadCnt.incrementAndGet();
            if (response != null) {
                response.dispose();
            }
            RemoteStatistics.stopChannelActivity((RemoteStatistics.ActivityID)activityID, (long)0L);
            RemoteLogger.finest("Communication #{0} with fs_server for directory {1} ({2} entries read) took {3} ms", request.getId(), path, realCnt.get(), System.currentTimeMillis() - time);
            throw throwable;
        }
        if (response != null) {
            response.dispose();
        }
        RemoteStatistics.stopChannelActivity((RemoteStatistics.ActivityID)activityID, (long)0L);
        RemoteLogger.finest("Communication #{0} with fs_server for directory {1} ({2} entries read) took {3} ms", request.getId(), path, realCnt.get(), System.currentTimeMillis() - time);
        return dirEntryList;
    }

    private DirEntryList readEntries(FSSResponse response, String path, long reqId, AtomicInteger cnt) throws TimeoutException, IOException, InterruptedException, ExecutionException {
        RemoteLogger.finest("Reading response #{0} from fs_server for directory {1})", reqId, path);
        ArrayList<FSSResponse.Package> packages = new ArrayList<FSSResponse.Package>();
        FSSResponse.Package pkg = response.getNextPackage();
        while (pkg.getKind() != FSSResponseKind.FS_RSP_END && pkg.getKind() != FSSResponseKind.FS_RSP_END) {
            if (pkg.getKind() == FSSResponseKind.FS_RSP_ERROR) {
                throw this.createIOException(pkg);
            }
            cnt.incrementAndGet();
            if (VERBOSE_RESPONSE) {
                RemoteLogger.finest("\tfs_server response #{0}: [{1}] {2}", reqId, cnt.get(), pkg.getData());
            }
            packages.add(pkg);
            pkg = response.getNextPackage();
        }
        RemoteLogger.finest("Processing response #{0} from fs_server for directory {1}", reqId, path);
        ArrayList<DirEntry> result = new ArrayList<DirEntry>();
        for (FSSResponse.Package pkg2 : packages) {
            try {
                assert (pkg2 != null);
                DirEntry entry = this.createDirEntry(pkg2, reqId, this.env);
                result.add(entry);
            }
            catch (Throwable thr) {
                thr.printStackTrace(System.err);
            }
        }
        return new DirEntryList(result, System.currentTimeMillis());
    }

    private DirEntry createDirEntry(FSSResponse.Package pkg, long reqId, ExecutionEnvironment env) {
        try {
            Buffer buf = pkg.getBuffer();
            char kindChar = buf.getChar();
            assert (kindChar == pkg.getKind().getChar());
            assert (pkg.getKind() == FSSResponseKind.FS_RSP_ENTRY);
            int id = buf.getInt();
            assert ((long)id == reqId);
            String name = buf.getString();
            char type = buf.getChar();
            long size = buf.getLong();
            long mtime = buf.getLong() / 1000L * 1000L;
            char r = buf.getChar();
            char w = buf.getChar();
            char x = buf.getChar();
            buf.getChar();
            if (r != 'r' && r != '-' || w != 'w' && w != '-' || x != 'x' && x != '-') {
                throw new IllegalStateException("Wrong file access format: " + buf);
            }
            boolean canRead = r == 'r';
            boolean canWrite = w == 'w';
            boolean canExec = x == 'x';
            long device = buf.getLong();
            long inode = buf.getLong();
            String linkTarget = buf.getString();
            if (linkTarget.isEmpty()) {
                linkTarget = null;
            }
            return DirEntryImpl.create(name, size, mtime, canRead, canWrite, canExec, type, device, inode, linkTarget);
        }
        catch (Throwable thr) {
            throw new IllegalArgumentException("Error processing response " + pkg, thr);
        }
    }

    public void connected(ExecutionEnvironment env) {
        if (env.equals((Object)this.env)) {
            this.dispatcher.connected();
        }
    }

    public void disconnected(ExecutionEnvironment env) {
    }

    public final void testSetCleanupUponStart(boolean cleanup) {
        this.dispatcher.setCleanupUponStart(cleanup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void testDumpInstances(PrintStream ps) {
        Collection<FSSTransport> transports;
        Iterator<FSSTransport> iterator = instancesLock;
        synchronized (iterator) {
            transports = instances.values();
        }
        for (FSSTransport tr : transports) {
            tr.testDump(ps);
        }
    }

    protected void testDump(PrintStream ps) {
        this.dispatcher.testDump(ps);
    }

    @Override
    protected boolean needsClientSidePollingRefresh() {
        return false;
    }

    @Override
    protected void registerDirectoryImpl(RemoteDirectory directory) {
        if (ConnectionManager.getInstance().isConnectedTo(this.env)) {
            this.requestRefreshCycle(directory.getPath());
        }
    }

    @Override
    protected void unregisterDirectoryImpl(String path) {
    }

    @Override
    protected void onConnect() {
    }

    @Override
    protected void onFocusGained() {
        this.requestRefreshCycle("/");
    }

    @Override
    protected void scheduleRefresh(Collection<String> paths) {
        if (!this.dispatcher.isRefreshing()) {
            for (String path : paths) {
                this.dispatcher.requestRefreshCycle(path.isEmpty() ? "/" : path);
            }
        }
    }

    private void requestRefreshCycle(String path) {
        if (!this.dispatcher.isRefreshing()) {
            this.dispatcher.requestRefreshCycle(path.isEmpty() ? "/" : path);
        }
    }

    @Override
    protected boolean canRefreshFast() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refreshFast(String path, boolean expected) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        long time = System.currentTimeMillis();
        RemoteStatistics.ActivityID activityID = RemoteStatistics.startChannelActivity((CharSequence)"fs_server_fast_refresh", (CharSequence[])new CharSequence[]{path});
        FSSResponse response = null;
        FSSRequest request = new FSSRequest(FSSRequestKind.FS_REQ_REFRESH, path, false);
        try {
            RemoteLogger.finest("Sending request #{0} for directory {1} to fs_server", request.getId(), path);
            response = this.dispatcher.dispatch(request);
            FSSResponse.Package pkg = response.getNextPackage();
            assert (pkg.getKind() == FSSResponseKind.FS_RSP_REFRESH);
            Buffer buf = pkg.getBuffer();
            buf.getChar();
            int respId = buf.getInt();
            assert (respId == request.getId());
            String serverPath = buf.getString();
            if (!serverPath.equals(path)) {
                DLightLibsCommonLogger.assertTrue((boolean)false, (String)("Unexpected path in response: \"" + serverPath + "\" expected \"" + path + "\""));
            }
            IOException ex = null;
            pkg = response.getNextPackage();
            while (pkg.getKind() != FSSResponseKind.FS_RSP_END) {
                if (pkg.getKind() == FSSResponseKind.FS_RSP_ERROR) {
                    ex = this.createIOException(pkg);
                }
                if (pkg.getKind() != FSSResponseKind.FS_RSP_CHANGE) {
                    new IllegalArgumentException("Wrong response kind: " + response).printStackTrace(System.err);
                } else {
                    buf = pkg.getBuffer();
                    buf.getChar();
                    buf.getInt();
                    String changedPath = buf.getString();
                    if (!changedPath.startsWith(path)) {
                        new IllegalArgumentException("Unexpected changed path: " + response).printStackTrace(System.err);
                    } else {
                        RemoteFileSystem fs = RemoteFileSystemManager.getInstance().getFileSystem(this.env);
                        fs.getRefreshManager().removeFromRefresh(changedPath);
                        RemoteFileObjectBase fo = fs.getFactory().getCachedFileObject(changedPath);
                        if (fo != null) {
                            fo.refreshImpl(false, null, expected, RemoteFileObjectBase.RefreshMode.DEFAULT);
                        }
                    }
                }
                pkg = response.getNextPackage();
            }
            if (ex != null) {
                throw ex;
            }
            if (response != null) {
                response.dispose();
            }
        }
        catch (Throwable throwable) {
            if (response != null) {
                response.dispose();
            }
            RemoteStatistics.stopChannelActivity((RemoteStatistics.ActivityID)activityID, (long)0L);
            RemoteLogger.finest("Fast refresh #{0} of {1} took {2} ms", request.getId(), path, System.currentTimeMillis() - time);
            throw throwable;
        }
        RemoteStatistics.stopChannelActivity((RemoteStatistics.ActivityID)activityID, (long)0L);
        RemoteLogger.finest("Fast refresh #{0} of {1} took {2} ms", request.getId(), path, System.currentTimeMillis() - time);
    }

    @Override
    protected RemoteFileSystemTransport.Warmup createWarmup(String path) {
        WarmupImpl warmup = new WarmupImpl(path);
        warmup.start();
        return warmup;
    }

    @Override
    protected DirEntryList delete(String path, boolean directory) throws TimeoutException, ConnectException, IOException {
        DirEntryList dirEntryList;
        FSSRequest request = new FSSRequest(FSSRequestKind.FS_REQ_DELETE, path);
        FSSResponse response = null;
        RemoteStatistics.ActivityID activityID = RemoteStatistics.startChannelActivity((CharSequence)"fs_server_delete", (CharSequence[])new CharSequence[]{path});
        AtomicInteger cnt = new AtomicInteger(0);
        long time = System.currentTimeMillis();
        try {
            RemoteLogger.finest("Sending request #{0} for removing {1} to fs_server", request.getId(), path);
            response = this.dispatcher.dispatch(request);
            FSSResponse.Package pkg = response.getNextPackage();
            if (pkg.getKind() == FSSResponseKind.FS_RSP_ERROR) {
                throw this.createIOException(pkg);
            }
            assert (pkg.getKind() == FSSResponseKind.FS_RSP_LS);
            dirEntryList = this.readEntries(response, path, request.getId(), this.dirReadCnt);
        }
        catch (InterruptedException | ConnectException | CancellationException | ExecutionException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                RemoteStatistics.stopChannelActivity((RemoteStatistics.ActivityID)activityID, (long)0L);
                RemoteLogger.finest("Communication #{0} with fs_server for removing {1} ({2} entries read) took {3} ms", request.getId(), path, cnt.get(), System.currentTimeMillis() - time);
                if (response != null) {
                    response.dispose();
                }
                throw throwable;
            }
        }
        RemoteStatistics.stopChannelActivity((RemoteStatistics.ActivityID)activityID, (long)0L);
        RemoteLogger.finest("Communication #{0} with fs_server for removing {1} ({2} entries read) took {3} ms", request.getId(), path, cnt.get(), System.currentTimeMillis() - time);
        if (response != null) {
            response.dispose();
        }
        return dirEntryList;
    }

    @Override
    protected DirEntry uploadAndRename(File srcFile, String pathToUpload, String pathToRename) throws TimeoutException, ConnectException, IOException, InterruptedException, ExecutionException, InterruptedException {
        CommonTasksSupport.UploadParameters params = new CommonTasksSupport.UploadParameters(srcFile, this.env, pathToUpload, null, -1, false, null, false);
        Future task = CommonTasksSupport.uploadFile((CommonTasksSupport.UploadParameters)params);
        CommonTasksSupport.UploadStatus uploadStatus = (CommonTasksSupport.UploadStatus)task.get();
        if (uploadStatus.isOK()) {
            RemoteLogger.getInstance().log(Level.FINEST, "Uploading {0} succeeded", this);
            if (pathToRename == null) {
                return this.lstat(pathToUpload);
            }
            return this.renameAfterUpload(pathToUpload, pathToRename);
        }
        RemoteLogger.getInstance().log(Level.FINEST, "Uploading {0} failed", this);
        throw new IOException(uploadStatus.getError() + " " + uploadStatus.getExitCode());
    }

    private DirEntry renameAfterUpload(String pathToUpload, String pathToRename) throws IOException, InterruptedException, CancellationException, ExecutionException {
        FSSResponse.Package pkg;
        long time;
        RemoteStatistics.ActivityID activityID;
        FSSResponse response;
        FSSRequest request;
        block8: {
            request = new FSSRequest(FSSRequestKind.FS_REQ_MOVE, pathToUpload, pathToRename);
            response = null;
            activityID = RemoteStatistics.startChannelActivity((CharSequence)"fs_server_rename_afre_upload", (CharSequence[])new CharSequence[]{pathToUpload, pathToRename});
            time = System.currentTimeMillis();
            RemoteLogger.finest("Sending request #{0} for renaming {1} to {2} to fs_server", request.getId(), pathToUpload, pathToRename);
            response = this.dispatcher.dispatch(request);
            pkg = response.getNextPackage();
            if (pkg.getKind() == FSSResponseKind.FS_RSP_ERROR) {
                IOException ex = this.createIOException(pkg);
                throw ex;
            }
            if (pkg.getKind() != FSSResponseKind.FS_RSP_ENTRY) break block8;
            DirEntry dirEntry = this.createDirEntry(pkg, request.getId(), this.env);
            RemoteStatistics.stopChannelActivity((RemoteStatistics.ActivityID)activityID, (long)0L);
            RemoteLogger.finest("Communication #{0} with fs_server for renaming {1} to {2} took {3} ms", request.getId(), pathToUpload, pathToRename, System.currentTimeMillis() - time);
            if (response != null) {
                response.dispose();
            }
            return dirEntry;
        }
        try {
            try {
                throw new IOException("Unexpected package kind: " + (Object)((Object)pkg.getKind()));
            }
            catch (ConnectException | TimeoutException ex) {
                throw new IOException(ex);
            }
        }
        catch (Throwable throwable) {
            RemoteStatistics.stopChannelActivity((RemoteStatistics.ActivityID)activityID, (long)0L);
            RemoteLogger.finest("Communication #{0} with fs_server for renaming {1} to {2} took {3} ms", request.getId(), pathToUpload, pathToRename, System.currentTimeMillis() - time);
            if (response != null) {
                response.dispose();
            }
            throw throwable;
        }
    }

    @Override
    protected boolean canSetAccessCheckType() {
        return true;
    }

    @Override
    protected void setAccessCheckType(FileSystemProvider.AccessCheckType accessCheckType) {
        this.dispatcher.setAccessCheckType(accessCheckType);
    }

    @Override
    protected FileSystemProvider.AccessCheckType getAccessCheckType() {
        return this.dispatcher.getAccessCheckType();
    }

    private class WarmupImpl
    implements RemoteFileSystemTransport.Warmup,
    FSSResponse.Listener,
    Runnable {
        private final String path;
        private final Map<String, DirEntryList> cache = new HashMap<String, DirEntryList>();
        private final Object lock = new Object();
        private FSSResponse response;
        private final boolean useListener = RemoteFileSystemUtils.getBoolean("remote.warmup.listener", false);
        private final RequestProcessor rp;

        public WarmupImpl(String path) {
            this.path = path.isEmpty() ? "/" : path;
            this.rp = this.useListener ? null : new RequestProcessor("Warming Up " + FSSTransport.this.env + ':' + this.path, 1);
        }

        public void start() {
            if (this.useListener) {
                try {
                    this.sendRequest();
                }
                catch (IOException | ExecutionException ex) {
                    ex.printStackTrace(System.err);
                }
                catch (CancellationException cancellationException) {
                }
                catch (InterruptedException interruptedException) {}
            } else {
                this.rp.post((Runnable)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void packageAdded(FSSResponse.Package pkg) {
            if (this.useListener) {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DirEntryList getAndRemove(String path) throws InterruptedException {
            DirEntryList l;
            while ((l = this.tryGetAndRemove(path)) == null) {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.wait(1000L);
                }
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DirEntryList tryGetAndRemove(String path) {
            Object object = this.lock;
            synchronized (object) {
                DirEntryList entries = this.cache.remove(path);
                if (entries != null) {
                    RemoteLogger.fine("Warming up: got entries for {0}; {1} cached entry lists remain", path, this.cache.size());
                    return entries;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(String path) {
            Object object = this.lock;
            synchronized (object) {
                this.cache.remove(path);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            long time = System.currentTimeMillis();
            RemoteStatistics.ActivityID activityID = RemoteStatistics.startChannelActivity((CharSequence)"fs_server_warmup", (CharSequence[])new CharSequence[]{this.path});
            try {
                RemoteLogger.fine("Warming up fs_server for {0}", this.path);
                this.warmapImpl();
                FSSTransport.this.warmupCnt.incrementAndGet();
            }
            catch (IOException | TimeoutException ex) {
                ex.printStackTrace(System.err);
                FSSTransport.this.warmupCnt.incrementAndGet();
                RemoteStatistics.stopChannelActivity((RemoteStatistics.ActivityID)activityID, (long)0L);
                RemoteLogger.fine("Warming up fs_server for {0} took {1} ms", this.path, System.currentTimeMillis() - time);
            }
            catch (InterruptedException interruptedException) {
                FSSTransport.this.warmupCnt.incrementAndGet();
                RemoteStatistics.stopChannelActivity((RemoteStatistics.ActivityID)activityID, (long)0L);
                RemoteLogger.fine("Warming up fs_server for {0} took {1} ms", this.path, System.currentTimeMillis() - time);
                {
                    catch (Throwable throwable) {
                        FSSTransport.this.warmupCnt.incrementAndGet();
                        RemoteStatistics.stopChannelActivity((RemoteStatistics.ActivityID)activityID, (long)0L);
                        RemoteLogger.fine("Warming up fs_server for {0} took {1} ms", this.path, System.currentTimeMillis() - time);
                        throw throwable;
                    }
                }
            }
            RemoteStatistics.stopChannelActivity((RemoteStatistics.ActivityID)activityID, (long)0L);
            RemoteLogger.fine("Warming up fs_server for {0} took {1} ms", this.path, System.currentTimeMillis() - time);
        }

        private FSSResponse sendRequest() throws IOException, ConnectException, ExecutionException, CancellationException, InterruptedException {
            FSSRequest request = new FSSRequest(FSSRequestKind.FS_REQ_RECURSIVE_LS, this.path);
            RemoteLogger.finest("Sending recursive request #{0} for directory {1} to fs_server", request.getId(), this.path);
            return FSSTransport.this.dispatcher.dispatch(request, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void warmapImpl() throws TimeoutException, IOException, InterruptedException {
            FSSResponse r;
            Object object;
            long time = System.currentTimeMillis();
            AtomicInteger realCnt = new AtomicInteger(0);
            try {
                FSSResponse.Package pkg;
                Object object2 = this.lock;
                synchronized (object2) {
                    this.response = this.sendRequest();
                }
                while ((pkg = this.response.getNextPackage()).getKind() != FSSResponseKind.FS_RSP_END) {
                    Buffer buf = pkg.getBuffer();
                    char respKind = buf.getChar();
                    assert (respKind == FSSResponseKind.FS_RSP_RECURSIVE_LS.getChar());
                    int respId = buf.getInt();
                    assert (respId == this.response.getId());
                    String serverPath = buf.getString();
                    DirEntryList entries = FSSTransport.this.readEntries(this.response, serverPath, this.response.getId(), realCnt);
                    Object object3 = this.lock;
                    synchronized (object3) {
                        this.cache.put(serverPath, entries);
                        this.lock.notifyAll();
                    }
                }
                object = this.lock;
            }
            catch (CancellationException ex) {
                FSSResponse r2;
                Object object4 = this.lock;
                synchronized (object4) {
                    this.cache.clear();
                }
                object4 = this.lock;
                synchronized (object4) {
                    r2 = this.response;
                }
                if (r2 != null) {
                    r2.dispose();
                }
                RemoteLogger.finest("Warming up directory {1}:{2}: ({3} entries) took {4} ms", FSSTransport.this.env, this.path, realCnt.get(), System.currentTimeMillis() - time);
            }
            catch (ConnectException | ExecutionException | TimeoutException ex2) {
                FSSResponse r3;
                ex2.printStackTrace(System.err);
                Object object5 = this.lock;
                {
                    catch (Throwable throwable) {
                        FSSResponse r4;
                        Object object6 = this.lock;
                        synchronized (object6) {
                            r4 = this.response;
                        }
                        if (r4 != null) {
                            r4.dispose();
                        }
                        RemoteLogger.finest("Warming up directory {1}:{2}: ({3} entries) took {4} ms", FSSTransport.this.env, this.path, realCnt.get(), System.currentTimeMillis() - time);
                        throw throwable;
                    }
                }
                synchronized (object5) {
                    r3 = this.response;
                }
                if (r3 != null) {
                    r3.dispose();
                }
                RemoteLogger.finest("Warming up directory {1}:{2}: ({3} entries) took {4} ms", FSSTransport.this.env, this.path, realCnt.get(), System.currentTimeMillis() - time);
            }
            synchronized (object) {
                r = this.response;
            }
            if (r != null) {
                r.dispose();
            }
            RemoteLogger.finest("Warming up directory {1}:{2}: ({3} entries) took {4} ms", FSSTransport.this.env, this.path, realCnt.get(), System.currentTimeMillis() - time);
        }
    }
}

