/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.util.HibernateUtil;
import org.netbeans.modules.hibernate.wizards.HibernateConfigurationWizardDescriptor;
import org.netbeans.modules.hibernate.wizards.WizardErrorPanel;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class HibernateConfigurationWizard
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private Project project;
    private WizardDescriptor wizard;
    private HibernateConfigurationWizardDescriptor descriptor;
    private WizardDescriptor.Panel[] panels;
    private final String sessionName = "name";
    private final String dialect = "hibernate.dialect";
    private final String driver = "hibernate.connection.driver_class";
    private final String url = "hibernate.connection.url";
    private final String userName = "hibernate.connection.username";
    private final String password = "hibernate.connection.password";
    private final String DEFAULT_CONFIGURATION_FILENAME = "hibernate.cfg";
    private Logger logger = Logger.getLogger(HibernateConfigurationWizard.class.getName());

    public static HibernateConfigurationWizard create() {
        return new HibernateConfigurationWizard();
    }

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            HibernateEnvironment hibernateEnv = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            if (hibernateEnv == null) {
                this.logger.info("Unsupported project " + this.project + ". Exiting config wizard.");
                this.panels = new WizardDescriptor.Panel[]{WizardErrorPanel.getWizardErrorWizardPanel()};
            } else {
                Project p = Templates.getProject((WizardDescriptor)this.wizard);
                SourceGroup[] groups = ProjectUtils.getSources((Project)p).getSourceGroups("generic");
                WizardDescriptor.Panel targetChooser = Templates.createSimpleTargetChooser((Project)p, (SourceGroup[])groups);
                this.panels = new WizardDescriptor.Panel[]{targetChooser, this.descriptor};
            }
            String[] steps = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                if (steps[i] == null) {
                    steps[i] = c.getName();
                }
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    private boolean foundConfigFileInProject(List<FileObject> configFiles, String configFileName) {
        for (FileObject fo : configFiles) {
            if (!fo.getName().equals(configFileName)) continue;
            return true;
        }
        return false;
    }

    public String name() {
        return NbBundle.getMessage(HibernateConfigurationWizard.class, (String)"LBL_ConfWizardTitle");
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public void addChangeListener(ChangeListener l) {
    }

    private String[] createSteps() {
        String[] beforeSteps = null;
        Object prop = this.wizard.getProperty("WizardPanel_contentData");
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        if (beforeSteps == null) {
            beforeSteps = new String[]{};
        }
        String[] res = new String[beforeSteps.length - 1 + this.panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < beforeSteps.length - 1 ? beforeSteps[i] : this.panels[i - beforeSteps.length + 1].getComponent().getName();
        }
        return res;
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
        this.project = Templates.getProject((WizardDescriptor)wizard);
        String wizardTitle = NbBundle.getMessage(HibernateConfigurationWizard.class, (String)"LBL_ConfWizardTitle");
        this.descriptor = new HibernateConfigurationWizardDescriptor(this.project, wizardTitle);
        this.getPanels();
        List<SourceGroup> javaSourceGroups = HibernateUtil.getJavaSourceGroups(this.project);
        assert (javaSourceGroups.size() > 0) : "No Java Sources found for project " + this.project.getProjectDirectory();
        Templates.setTargetFolder((WizardDescriptor)wizard, (FileObject)javaSourceGroups.get(0).getRootFolder());
        if (wizard instanceof TemplateWizard) {
            HibernateEnvironment hibernateEnv = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            if (hibernateEnv == null) {
                return;
            }
            List<FileObject> configFiles = hibernateEnv.getAllHibernateConfigFileObjects();
            String targetName = "hibernate.cfg";
            if (!configFiles.isEmpty() && this.foundConfigFileInProject(configFiles, "hibernate.cfg")) {
                int configFilesCount = configFiles.size();
                targetName = "hibernate" + configFilesCount++ + ".cfg";
                while (this.foundConfigFileInProject(configFiles, targetName)) {
                    targetName = "hibernate" + configFilesCount++ + ".cfg";
                }
            }
            ((TemplateWizard)wizard).setTargetName(targetName);
        }
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.panels = null;
    }

    public Set instantiate() throws IOException {
        int row;
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        DataFolder targetDataFolder = DataFolder.findFolder((FileObject)targetFolder);
        String targetName = Templates.getTargetName((WizardDescriptor)this.wizard);
        FileObject templateFileObject = Templates.getTemplate((WizardDescriptor)this.wizard);
        DataObject templateDataObject = DataObject.find((FileObject)templateFileObject);
        DataObject newOne = templateDataObject.createFromTemplate(targetDataFolder, targetName);
        SessionFactory sFactory = new SessionFactory();
        if (this.descriptor.getDialectName() != null && !"".equals(this.descriptor.getDialectName())) {
            row = sFactory.addProperty2(this.descriptor.getDialectName());
            sFactory.setAttributeValue("Property2", row, "name", "hibernate.dialect");
        }
        if (this.descriptor.getDriver() != null && !"".equals(this.descriptor.getDriver())) {
            row = sFactory.addProperty2(this.descriptor.getDriver());
            sFactory.setAttributeValue("Property2", row, "name", "hibernate.connection.driver_class");
        }
        if (this.descriptor.getURL() != null && !"".equals(this.descriptor.getURL())) {
            row = sFactory.addProperty2(this.descriptor.getURL());
            sFactory.setAttributeValue("Property2", row, "name", "hibernate.connection.url");
        }
        if (this.descriptor.getUserName() != null && !"".equals(this.descriptor.getUserName())) {
            row = sFactory.addProperty2(this.descriptor.getUserName());
            sFactory.setAttributeValue("Property2", row, "name", "hibernate.connection.username");
        }
        if (this.descriptor.getPassword() != null && !"".equals(this.descriptor.getPassword())) {
            row = sFactory.addProperty2(this.descriptor.getPassword());
            sFactory.setAttributeValue("Property2", row, "name", "hibernate.connection.password");
        }
        try {
            HibernateCfgDataObject hdo = (HibernateCfgDataObject)newOne;
            hdo.addSessionFactory(sFactory);
            hdo.save();
            HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            this.logger.info("Library registered : " + hibernateEnvironment.addHibernateLibraryToProject(hdo.getPrimaryFile()));
            if (Util.isJavaSE((Project)this.project)) {
                this.logger.info("DB Driver registered : " + hibernateEnvironment.registerDBDriver(this.descriptor.getDriver(), hdo.getPrimaryFile()));
            } else {
                this.logger.info("Skip registration, need to register db connection in netbeans isntead and have driver of server classpath.");
            }
            return Collections.singleton(hdo.getPrimaryFile());
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return Collections.EMPTY_SET;
        }
    }
}

