/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.SourceGroupModifier;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.hibernate.cfg.model.HibernateConfiguration;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.service.TableColumn;
import org.netbeans.modules.hibernate.wizards.support.DBSchemaManager;
import org.netbeans.modules.hibernate.wizards.support.DBSchemaTableProvider;
import org.netbeans.modules.hibernate.wizards.support.EmptyTableProvider;
import org.netbeans.modules.hibernate.wizards.support.Table;
import org.netbeans.modules.hibernate.wizards.support.TableProvider;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.spi.java.queries.BinaryForSourceQueryImplementation;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;

public class HibernateUtil {
    private static final String REGEXP_XML_FILE = ".+\\.xml";
    private static final String REGEXP_CFG_XML_FILE = ".+\\.cfg\\.xml";
    private static Logger logger = Logger.getLogger(HibernateUtil.class.getName());

    public static List<String> getAllDatabaseTables(HibernateConfiguration ... configurations) throws SQLException {
        ArrayList<String> allTables = new ArrayList<String>();
        for (HibernateConfiguration configuration : configurations) {
            try {
                ResultSet rs;
                Connection jdbcConnection;
                DatabaseConnection dbConnection = HibernateUtil.getDBConnection(configuration);
                if (dbConnection == null || (jdbcConnection = dbConnection.getJDBCConnection()) == null) continue;
                DatabaseMetaData dbMetadata = jdbcConnection.getMetaData();
                ResultSet rsSchema = dbMetadata.getSchemas();
                if (rsSchema.next()) {
                    do {
                        rs = dbMetadata.getTables(null, rsSchema.getString("TABLE_SCHEM"), null, new String[]{"TABLE"});
                        while (rs.next()) {
                            allTables.add(rs.getString("TABLE_NAME"));
                        }
                    } while (rsSchema.next());
                    continue;
                }
                rs = dbMetadata.getTables(null, dbConnection.getSchema(), null, new String[]{"TABLE"});
                while (rs.next()) {
                    allTables.add(rs.getString("TABLE_NAME"));
                }
            }
            catch (DatabaseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return allTables;
    }

    public static List<String> getAllDatabaseTablesOnEventThread(FileObject configurationFO) throws SQLException, DatabaseException, DataObjectNotFoundException {
        ArrayList<String> databaseTables = new ArrayList<String>();
        DBSchemaManager dbSchemaManager = new DBSchemaManager();
        DatabaseConnection dbConnection = HibernateUtil.getDBConnection(((HibernateCfgDataObject)DataObject.find((FileObject)configurationFO)).getHibernateConfiguration());
        SchemaElement schemaElement = null;
        if (dbConnection != null) {
            schemaElement = dbSchemaManager.getSchemaElement(dbConnection);
        }
        TableProvider tableProvider = null;
        tableProvider = schemaElement != null ? new DBSchemaTableProvider(schemaElement) : new EmptyTableProvider();
        for (Table table : tableProvider.getTables()) {
            databaseTables.add(table.getName());
        }
        return databaseTables;
    }

    public static List<HibernateConfiguration> getAllHibernateConfigurations(Project project) {
        ArrayList<HibernateConfiguration> configFiles = new ArrayList<HibernateConfiguration>();
        for (FileObject fo : HibernateUtil.getAllHibernateConfigFileObjects(project)) {
            try {
                configFiles.add(((HibernateCfgDataObject)DataObject.find((FileObject)fo)).getHibernateConfiguration());
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return configFiles;
    }

    public static List<FileObject> getAllHibernateConfigFileObjects(Project project) {
        return HibernateUtil.searchSourceFiles(project, REGEXP_XML_FILE, "text/x-hibernate-cfg+xml");
    }

    public static List<FileObject> getDefaultHibernateConfigFileObjects(Project project) {
        return HibernateUtil.searchSourceFiles(project, REGEXP_CFG_XML_FILE, null);
    }

    public static List<FileObject> getAllHibernateMappingFileObjects(Project project) {
        return HibernateUtil.searchSourceFiles(project, REGEXP_XML_FILE, "text/x-hibernate-mapping+xml");
    }

    private static FileObject createBuildFolder(File buildFile) {
        FileObject buildFO = null;
        logger.info("Build folder does not exist. Creating it.");
        try {
            buildFO = FileUtil.createFolder((File)buildFile);
        }
        catch (IOException ioe) {
            logger.log(Level.INFO, "Cannot create build folder", ioe);
        }
        return buildFO;
    }

    public static SourceGroup[] getSourceGroups(Project project) {
        Sources projectSources = ProjectUtils.getSources((Project)project);
        SourceGroup[] resources = projectSources.getSourceGroups("resources");
        if (resources.length > 0) {
            return resources;
        }
        SourceGroup resourcesSourceGroup = SourceGroupModifier.createSourceGroup((Project)project, (String)"resources", (String)"main");
        if (resourcesSourceGroup != null) {
            return new SourceGroup[]{resourcesSourceGroup};
        }
        return projectSources.getSourceGroups("java");
    }

    public static SourceGroup getFirstSourceGroup(Project project) {
        return HibernateUtil.getSourceGroups(project)[0];
    }

    public static FileObject findJavaFileObjectInProject(String className, Project project) {
        className = className.replace('.', File.separatorChar);
        className = className + ".java";
        GlobalPathRegistry globalPathRegistry = GlobalPathRegistry.getDefault();
        FileObject clazzFO = globalPathRegistry.findResource(className);
        return clazzFO;
    }

    public static List<URL> getProjectClassPathEntries(FileObject projectFile) {
        ArrayList<URL> projectClassPathEntries = new ArrayList<URL>();
        ClassPath cp = ClassPath.getClassPath((FileObject)projectFile, (String)"classpath/execute");
        for (ClassPath.Entry cpEntry : cp.entries()) {
            projectClassPathEntries.add(cpEntry.getURL());
        }
        return projectClassPathEntries;
    }

    public static List<URL> getProjectClassPath(Project project) {
        ArrayList<URL> projectClassPathEntries = new ArrayList<URL>();
        for (SourceGroup sourceGroup : HibernateUtil.getSourceGroups(project)) {
            if (sourceGroup == null) continue;
            ClassPath cp = ClassPath.getClassPath((FileObject)sourceGroup.getRootFolder(), (String)"classpath/compile");
            for (ClassPath.Entry cpEntry : cp.entries()) {
                projectClassPathEntries.add(cpEntry.getURL());
            }
        }
        return projectClassPathEntries;
    }

    public static FileObject getBuildFO(Project project) {
        FileObject buildFO = null;
        try {
            URL buildURL;
            BinaryForSourceQuery.Result result;
            SourceGroup[] sourceGroup;
            File buildFile;
            BinaryForSourceQueryImplementation binaryForSourceQueryImpl = (BinaryForSourceQueryImplementation)project.getLookup().lookup(BinaryForSourceQueryImplementation.class);
            if (binaryForSourceQueryImpl == null) {
                logger.info("BinaryForSourceQueryImpl is null. trying reflection.");
                Method getEvaluatorMethod = null;
                try {
                    getEvaluatorMethod = project.getClass().getDeclaredMethod("evaluator", new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (SecurityException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (getEvaluatorMethod != null) {
                    try {
                        PropertyEvaluator propEvaluator = (PropertyEvaluator)getEvaluatorMethod.invoke((Object)project, new Object[0]);
                        String buildDir = propEvaluator.getProperty("build.classes.dir");
                        if (buildDir != null && (buildFO = project.getProjectDirectory().getFileObject(buildDir)) == null) {
                            buildFile = new File(FileUtil.toFile((FileObject)project.getProjectDirectory()), buildDir);
                            buildFO = HibernateUtil.createBuildFolder(buildFile);
                        }
                    }
                    catch (IllegalAccessException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IllegalArgumentException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (InvocationTargetException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    logger.info("No method named 'evaluator() found in project : " + project);
                }
            } else {
                sourceGroup = HibernateUtil.getSourceGroups(project);
                result = BinaryForSourceQuery.findBinaryRoots((URL)sourceGroup[0].getRootFolder().getURL());
                buildURL = result.getRoots()[0];
                logger.info("Got build URL from the project sources : " + buildURL);
                buildFile = new File(buildURL.getPath());
                buildFO = FileUtil.toFileObject((File)buildFile);
                if (buildFO == null) {
                    buildFO = HibernateUtil.createBuildFolder(buildFile);
                }
            }
            if (buildFO == null) {
                sourceGroup = HibernateUtil.getSourceGroups(project);
                result = BinaryForSourceQuery.findBinaryRoots((URL)sourceGroup[0].getRootFolder().getURL());
                buildURL = result.getRoots()[0];
                logger.info("Got build URL from the project sources : " + buildURL);
                buildFile = new File(buildURL.getPath());
                buildFO = FileUtil.toFileObject((File)buildFile);
                if (buildFO == null) {
                    buildFO = HibernateUtil.createBuildFolder(buildFile);
                }
            }
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        logger.info("Build Folder = " + buildFO);
        return buildFO;
    }

    public static List<String> getAllHibernateMappingsRelativeToSourcePath(Project project) {
        List<FileObject> files = HibernateUtil.searchSourceFiles(project, REGEXP_XML_FILE, "text/x-hibernate-mapping+xml");
        ArrayList<String> mappingFiles = new ArrayList<String>(files.size());
        SourceGroup[] javaSourceGroup = HibernateUtil.getSourceGroups(project);
        block0: for (FileObject fo : files) {
            for (SourceGroup sourceGroup : javaSourceGroup) {
                FileObject root = sourceGroup.getRootFolder();
                String relativePath = FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
                if (relativePath == null) continue;
                assert (relativePath.length() > 0);
                mappingFiles.add(relativePath);
                continue block0;
            }
        }
        return mappingFiles;
    }

    public static List<FileObject> getAllHibernateReverseEnggFileObjects(Project project) {
        return HibernateUtil.searchSourceFiles(project, REGEXP_XML_FILE, "text/x-hibernate-reveng+xml");
    }

    public static List<TableColumn> getColumnsForTable(String tableName, HibernateConfiguration hibernateConfiguration) {
        ArrayList<TableColumn> columnNames = new ArrayList<TableColumn>();
        try {
            Connection connection = HibernateUtil.getJDBCConnection(hibernateConfiguration);
            if (connection != null) {
                Statement stmt = connection.createStatement();
                ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName);
                ResultSetMetaData rsMetadata = rs.getMetaData();
                DatabaseMetaData dbMetadata = connection.getMetaData();
                ResultSet rsDBMetadata = dbMetadata.getPrimaryKeys(null, null, tableName);
                ArrayList<String> primaryColumns = new ArrayList<String>();
                while (rsDBMetadata.next()) {
                    primaryColumns.add(rsDBMetadata.getString("COLUMN_NAME"));
                }
                for (int i = 1; i <= rsMetadata.getColumnCount(); ++i) {
                    TableColumn tableColumn = new TableColumn();
                    tableColumn.setColumnName(rsMetadata.getColumnName(i));
                    if (primaryColumns.contains(tableColumn.getColumnName())) {
                        tableColumn.setPrimaryKey(true);
                    }
                    columnNames.add(tableColumn);
                }
            }
        }
        catch (DatabaseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SQLException sQLException) {
            Exceptions.printStackTrace((Throwable)sQLException);
        }
        return columnNames;
    }

    public static String getDbConnectionDetails(HibernateConfiguration configuration, String property) {
        SessionFactory fact = configuration.getSessionFactory();
        if (fact == null) {
            logger.log(Level.WARNING, "Hibernate Configuration xml is missing <session-factory>, applying temporary fix, please check your xml.");
            configuration.setSessionFactory(new SessionFactory());
            fact = configuration.getSessionFactory();
            if (fact == null) {
                logger.log(Level.SEVERE, "Hibernate configuration xml is missing <session-factory>, xml must be fixed!");
                return "";
            }
        }
        int count = 0;
        for (String val : fact.getProperty2()) {
            String propName;
            if (!(propName = fact.getAttributeValue("Property2", count++, "name")).equals(property)) continue;
            return val;
        }
        return "";
    }

    public static DatabaseConnection getDBConnection(HibernateConfiguration configuration) throws DatabaseException {
        try {
            DatabaseConnection[] dbConnections;
            String driverClassName = HibernateUtil.getDbConnectionDetails(configuration, "hibernate.connection.driver_class");
            String driverURL = HibernateUtil.getDbConnectionDetails(configuration, "hibernate.connection.url");
            String username = HibernateUtil.getDbConnectionDetails(configuration, "hibernate.connection.username");
            String password = HibernateUtil.getDbConnectionDetails(configuration, "hibernate.connection.password");
            if (driverClassName == null) {
                driverClassName = HibernateUtil.getDbConnectionDetails(configuration, "connection.driver_class");
            }
            if (driverURL == null) {
                driverURL = HibernateUtil.getDbConnectionDetails(configuration, "connection.url");
            }
            if (username == null) {
                username = HibernateUtil.getDbConnectionDetails(configuration, "connection.username");
            }
            if (password == null) {
                password = HibernateUtil.getDbConnectionDetails(configuration, "connection.password");
            }
            for (DatabaseConnection dbConn : dbConnections = ConnectionManager.getDefault().getConnections()) {
                if (!dbConn.getDatabaseURL().equals(driverURL) || !dbConn.getUser().equals(username)) continue;
                logger.info("Found pre-existing database connection.");
                return HibernateUtil.checkAndConnect(dbConn);
            }
            JDBCDriver[] drivers = JDBCDriverManager.getDefault().getDrivers(driverClassName);
            if (drivers.length == 0) {
                return null;
            }
            DatabaseConnection dbConnection = DatabaseConnection.create((JDBCDriver)drivers[0], (String)driverURL, (String)username, null, (String)password, (boolean)true);
            ConnectionManager.getDefault().addConnection(dbConnection);
            return HibernateUtil.checkAndConnect(dbConnection);
        }
        catch (DatabaseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            throw ex;
        }
    }

    private static DatabaseConnection checkAndConnect(final DatabaseConnection dbConnection) {
        if (dbConnection.getJDBCConnection() == null) {
            logger.info("Database Connection not established, connecting..");
            return (DatabaseConnection)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<DatabaseConnection>(){

                public DatabaseConnection run() {
                    ConnectionManager.getDefault().showConnectionDialog(dbConnection);
                    return dbConnection;
                }
            });
        }
        logger.info("Database Connection is pre-established. Returning the conneciton.");
        return dbConnection;
    }

    public static Connection getDirectDBConnection(HibernateConfiguration configuration) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String driverClassName = HibernateUtil.getDbConnectionDetails(configuration, "hibernate.connection.driver_class");
        String driverURL = HibernateUtil.getDbConnectionDetails(configuration, "hibernate.connection.url");
        String username = HibernateUtil.getDbConnectionDetails(configuration, "hibernate.connection.username");
        String password = HibernateUtil.getDbConnectionDetails(configuration, "hibernate.connection.password");
        if (driverClassName == null) {
            driverClassName = HibernateUtil.getDbConnectionDetails(configuration, "connection.driver_class");
        }
        if (driverURL == null) {
            driverURL = HibernateUtil.getDbConnectionDetails(configuration, "connection.url");
        }
        if (username == null) {
            username = HibernateUtil.getDbConnectionDetails(configuration, "connection.username");
        }
        if (password == null) {
            password = HibernateUtil.getDbConnectionDetails(configuration, "connection.password");
        }
        Class<?> driverClass = Thread.currentThread().getContextClassLoader().loadClass(driverClassName);
        Driver driver = (Driver)driverClass.newInstance();
        Properties info = new Properties();
        info.setProperty("user", username);
        info.setProperty("password", password);
        return driver.connect(driverURL, info);
    }

    public static String getRelativeSourcePath(FileObject file, FileObject sourceRoot) {
        String relativePath = "";
        try {
            String absolutePath = file.getPath();
            String sourceRootPath = sourceRoot.getPath();
            int index = absolutePath.indexOf(sourceRootPath);
            if (index == -1) {
                relativePath = HibernateUtil.constructRelativePath(absolutePath, sourceRootPath);
                if (relativePath == null) {
                    return "";
                }
                return relativePath;
            }
            relativePath = absolutePath.substring(index + sourceRootPath.length() + 1);
        }
        catch (Exception e) {
            logger.info("exception while parsing relative path");
            Exceptions.printStackTrace((Throwable)e);
        }
        return relativePath;
    }

    private static Connection getJDBCConnection(HibernateConfiguration hibernateConfiguration) throws DatabaseException {
        if (HibernateUtil.getDBConnection(hibernateConfiguration) == null) {
            return null;
        }
        return HibernateUtil.getDBConnection(hibernateConfiguration).getJDBCConnection();
    }

    public static List<SourceGroup> getJavaSourceGroups(Project project) {
        assert (project != null);
        SourceGroup[] sourceGroups = HibernateUtil.getSourceGroups(project);
        Set<SourceGroup> testGroups = HibernateUtil.getTestSourceGroups(sourceGroups);
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>();
        for (SourceGroup sourceGroup : sourceGroups) {
            if (testGroups.contains(sourceGroup)) continue;
            result.add(sourceGroup);
        }
        return result;
    }

    private static Set<SourceGroup> getTestSourceGroups(SourceGroup[] sourceGroups) {
        Map<FileObject, SourceGroup> foldersToSourceGroupsMap = HibernateUtil.createFoldersToSourceGroupsMap(sourceGroups);
        HashSet<SourceGroup> testGroups = new HashSet<SourceGroup>();
        for (SourceGroup sourceGroup : sourceGroups) {
            testGroups.addAll(HibernateUtil.getTestTargets(sourceGroup, foldersToSourceGroupsMap));
        }
        return testGroups;
    }

    private static Map<FileObject, SourceGroup> createFoldersToSourceGroupsMap(SourceGroup[] sourceGroups) {
        if (sourceGroups.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<FileObject, SourceGroup> result = new HashMap<FileObject, SourceGroup>(2 * sourceGroups.length);
        for (SourceGroup sourceGroup : sourceGroups) {
            result.put(sourceGroup.getRootFolder(), sourceGroup);
        }
        return result;
    }

    private static List<SourceGroup> getTestTargets(SourceGroup sourceGroup, Map<FileObject, SourceGroup> foldersToSourceGroupsMap) {
        URL[] rootURLs = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroup.getRootFolder());
        if (rootURLs.length == 0) {
            return Collections.emptyList();
        }
        List<FileObject> sourceRoots = HibernateUtil.getFileObjects(rootURLs);
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>(sourceRoots.size());
        for (FileObject sourceRoot : sourceRoots) {
            SourceGroup srcGroup = foldersToSourceGroupsMap.get(sourceRoot);
            if (srcGroup == null) continue;
            result.add(srcGroup);
        }
        return result;
    }

    private static List<FileObject> getFileObjects(URL[] urls) {
        ArrayList<FileObject> result = new ArrayList<FileObject>(urls.length);
        for (URL url : urls) {
            FileObject sourceRoot = URLMapper.findFileObject((URL)url);
            if (sourceRoot != null) {
                result.add(sourceRoot);
                continue;
            }
            logger.log(Level.SEVERE, "No FileObject found for the following URL: " + url + " the test(s) will be skipped");
        }
        return result;
    }

    private static List<FileObject> searchSourceFiles(Project project, String regExp, String mimeType) {
        LinkedList<FileObject> files = new LinkedList<FileObject>();
        Set<FileObject> roots = HibernateUtil.createFoldersToSourceGroupsMap(HibernateUtil.getSourceGroups(project)).keySet();
        try {
            QuerySupport q = QuerySupport.forRoots((String)"org-netbeans-modules-jumpto-file-FileIndexer", (int)1, (FileObject[])roots.toArray(new FileObject[roots.size()]));
            Collection results = q.query("ci-file-name", regExp, QuerySupport.Kind.CASE_INSENSITIVE_REGEXP, new String[0]);
            for (IndexResult r : results) {
                FileObject file = r.getFile();
                if (file == null || !file.isValid() || mimeType != null && !mimeType.equals(FileUtil.getMIMEType((FileObject)file, (String[])new String[]{mimeType}))) continue;
                files.add(file);
            }
        }
        catch (PatternSyntaxException pse) {
            assert (false);
            return Collections.emptyList();
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, null, ioe);
            return Collections.emptyList();
        }
        return files;
    }

    private static String constructRelativePath(String abs, String src) {
        int i;
        String[] field1 = abs.split("/");
        String[] field2 = src.split("/");
        StringBuilder result = null;
        int length = field1.length > field2.length ? field2.length : field1.length;
        int numSameTokens = 0;
        boolean empty = true;
        for (i = 0; i < length && field1[i].equals(field2[i]); ++i) {
            ++numSameTokens;
            if (field1[i].length() <= 0) continue;
            empty = false;
        }
        if (empty) {
            return null;
        }
        result = new StringBuilder("");
        for (i = numSameTokens; i < field2.length; ++i) {
            result.append("../");
        }
        for (i = numSameTokens; i < field1.length; ++i) {
            result.append(field1[i] + "/");
        }
        if (result.charAt(result.length() - 1) == '/') {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }
}

