/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.apt;

import java.io.IOException;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTMacroCallback;
import org.netbeans.modules.cnd.apt.support.APTMacroExpandedStream;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.apt.utils.APTCommentsFilter;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTParseFileWalker;
import org.openide.util.Exceptions;

final class StopOnOffsetParseFileWalker
extends APTParseFileWalker {
    private final int stopOffset;

    public StopOnOffsetParseFileWalker(ProjectBase base, APTFile apt, FileImpl file, int offset, PreprocHandler preprocHandler, APTFileCacheEntry cacheEntry) {
        super(base, apt, file, preprocHandler, false, null, cacheEntry);
        this.stopOffset = offset;
    }

    protected boolean onAPT(APT node, boolean wasInBranch) {
        if (node.getEndOffset() >= this.stopOffset) {
            this.stop();
            return false;
        }
        return super.onAPT(node, wasInBranch);
    }

    static String expandImpl(FileImpl fileImpl, String code, PreprocHandler handler, ProjectBase base, int offset) {
        assert (!APTTraceFlags.USE_CLANK);
        APTFile aptLight = null;
        try {
            aptLight = APTDriver.findAPTLight((APTFileBuffer)fileImpl.getBuffer());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (aptLight == null) {
            return code;
        }
        APTFileCacheEntry cacheEntry = fileImpl.getAPTCacheEntry(handler.getState(), Boolean.FALSE);
        StopOnOffsetParseFileWalker walker = new StopOnOffsetParseFileWalker(base, aptLight, fileImpl, offset, handler, cacheEntry);
        walker.visit();
        TokenStream ts = APTTokenStreamBuilder.buildTokenStream((String)code, (String)fileImpl.getFileLanguage());
        ts = new APTMacroExpandedStream(ts, (APTMacroCallback)handler.getMacroMap(), true);
        ts = new APTCommentsFilter(ts);
        StringBuilder sb = new StringBuilder("");
        try {
            APTToken t = (APTToken)ts.nextToken();
            while (t != null && !APTUtils.isEOF((Token)t)) {
                sb.append(t.getTextID());
                t = (APTToken)ts.nextToken();
            }
        }
        catch (TokenStreamException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return sb.toString();
    }
}

