/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.DefaultCache;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public final class ErrorDirectiveImpl
extends OffsetableBase
implements CsmErrorDirective {
    private final CharSequence msg;
    private final PreprocHandler.State ppState;

    private ErrorDirectiveImpl(CsmFile file, CharSequence text, CsmOffsetable offs, PreprocHandler.State ppState) {
        super(file, offs != null ? offs.getStartOffset() : 0, offs != null ? offs.getEndOffset() : 0);
        this.msg = DefaultCache.getManager().getString(text);
        this.ppState = ppState;
    }

    public static ErrorDirectiveImpl create(CsmFile file, CharSequence msg, CsmOffsetable offs, PreprocHandler.State state) {
        state = APTHandlersSupport.getIncludeStackDepth((PreprocHandler.State)state) > 0 ? APTHandlersSupport.createCleanPreprocState((PreprocHandler.State)state) : null;
        return new ErrorDirectiveImpl(file, msg, offs, (PreprocHandler.State)state);
    }

    public CharSequence getErrorMessage() {
        return this.msg;
    }

    @Override
    public CharSequence getText() {
        return this.msg;
    }

    public PreprocHandler.State getState() {
        return this.ppState;
    }

    @Override
    public String toString() {
        return super.toString() + this.msg;
    }

    @Override
    public int hashCode() {
        return 47 * super.hashCode() + this.msg.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ErrorDirectiveImpl other = (ErrorDirectiveImpl)obj;
        return this.msg.equals(other.msg);
    }

    public ErrorDirectiveImpl(FileImpl containingFile, RepositoryDataInput input) throws IOException {
        super(containingFile, input);
        this.msg = PersistentUtils.readUTF(input, DefaultCache.getManager());
        this.ppState = input.readBoolean() ? PersistentUtils.readPreprocState(input) : null;
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        PersistentUtils.writeUTF(this.msg, output);
        output.writeBoolean(this.ppState != null);
        if (this.ppState != null) {
            PersistentUtils.writePreprocState(this.ppState, output);
        }
    }
}

