/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMacroParameter;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameterList;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Unresolved;
import org.netbeans.modules.cnd.modelimpl.parser.clank.MacroReference;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDProviderIml;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.cache.TextCache;
import org.openide.util.CharSequences;

public final class SystemMacroImpl
implements CsmMacro,
CsmIdentifiable {
    private final CharSequence macroName;
    private final CharSequence macroBody;
    private final CsmMacro.Kind macroKind;
    private final List<CharSequence> params;
    private final CsmFile containingFile;
    private final CsmUID<CsmMacro> uid;

    private SystemMacroImpl(CharSequence macroName, CharSequence macroBody, List<CharSequence> macroParams, CsmFile containingFile, CsmMacro.Kind macroKind) {
        this.macroName = NameCache.getManager().getString(macroName);
        this.macroBody = TextCache.getManager().getString(macroBody);
        this.macroKind = macroKind;
        this.params = macroParams != null ? Collections.unmodifiableList(macroParams) : null;
        this.containingFile = containingFile;
        if (APTTraceFlags.USE_CLANK) {
            this.uid = new BuiltInMacroUID((CsmUID<CsmFile>)UIDs.get((Object)containingFile), macroName);
        } else {
            assert (containingFile instanceof Unresolved.UnresolvedFile);
            this.uid = UIDProviderIml.createSelfUID(this);
        }
    }

    public static SystemMacroImpl create(CharSequence macroName, CharSequence macroBody, List<CharSequence> macroParams, CsmFile containingFile, CsmMacro.Kind macroKind) {
        return new SystemMacroImpl(macroName, macroBody, macroParams, containingFile, macroKind);
    }

    public List<CharSequence> getParameters() {
        return this.params;
    }

    public CharSequence getBody() {
        return this.macroBody;
    }

    public CsmMacro.Kind getKind() {
        return this.macroKind;
    }

    public CharSequence getName() {
        return this.macroName;
    }

    public CsmFile getContainingFile() {
        return this.containingFile;
    }

    public int getStartOffset() {
        return 0;
    }

    public int getEndOffset() {
        return 0;
    }

    public CsmOffsetable.Position getStartPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CsmOffsetable.Position getEndPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CharSequence getText() {
        return "#define " + this.macroName + " " + this.macroBody;
    }

    public boolean equals(Object obj) {
        boolean retValue;
        if (obj == null || !(obj instanceof SystemMacroImpl)) {
            retValue = false;
        } else {
            SystemMacroImpl other = (SystemMacroImpl)obj;
            retValue = CharSequences.comparator().compare(this.getName(), other.getName()) == 0;
        }
        return retValue;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.macroName != null ? this.macroName.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder retValue = new StringBuilder();
        retValue.append("#define '");
        retValue.append(this.getName());
        if (this.getParameters() != null) {
            retValue.append("[");
            Iterator<CharSequence> it = this.getParameters().iterator();
            while (it.hasNext()) {
                CharSequence param = it.next();
                retValue.append(param);
                if (!it.hasNext()) continue;
                retValue.append(", ");
            }
            retValue.append("]");
        }
        if (this.getBody().length() > 0) {
            retValue.append("'='");
            retValue.append(this.getBody());
        }
        retValue.append("' [").append(this.macroKind == CsmMacro.Kind.USER_SPECIFIED ? "user defined" : "system").append("]");
        return retValue.toString();
    }

    public CsmParameterList<CsmMacroParameter> getParameterList() {
        return null;
    }

    @Override
    public CsmUID<?> getUID() {
        return this.uid;
    }

    public static final class BuiltInMacroUID
    extends FactoryBasedUID<CsmFile, CsmMacro> {
        public BuiltInMacroUID(CsmUID<CsmFile> instance, CharSequence argument) {
            super(instance, argument);
        }

        public BuiltInMacroUID(RepositoryDataInput aStream) throws IOException {
            super(aStream);
        }
    }

    private static class FactoryBasedUID<I, T>
    implements CsmUID<T>,
    SelfPersistent {
        private final CsmUID<I> instance;
        private final CharSequence argument;

        protected FactoryBasedUID(CsmUID<I> instance, CharSequence argument) {
            this.instance = instance;
            this.argument = argument;
        }

        public T getObject() {
            Object object = this.instance.getObject();
            if (object == null) {
                return null;
            }
            FileImpl file = (FileImpl)object;
            CharSequence body = MacroReference.findBody(file, this.argument);
            if (body == null) {
                body = "";
            }
            SystemMacroImpl res = SystemMacroImpl.create(this.argument, body, null, file, MacroReference.findType(file, this.argument));
            return (T)res;
        }

        public void write(RepositoryDataOutput aStream) throws IOException {
            UIDObjectFactory.getDefaultFactory().writeUID(this.instance, aStream);
            aStream.writeCharSequenceUTF(this.argument);
        }

        public FactoryBasedUID(RepositoryDataInput aStream) throws IOException {
            this.instance = UIDObjectFactory.getDefaultFactory().readUID(aStream);
            this.argument = aStream.readCharSequenceUTF();
        }
    }
}

