/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.metro.samples;

import java.util.Collections;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.websvc.metro.samples.PanelConfigureProject;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class PanelOptionsVisual
extends JPanel {
    private PanelConfigureProject panel;
    private JComboBox serverInstanceComboBox;
    private JLabel serverInstanceLabel;

    public PanelOptionsVisual(PanelConfigureProject panel) {
        this.panel = panel;
        this.initComponents();
        this.initServers();
    }

    private void initComponents() {
        this.serverInstanceLabel = new JLabel();
        this.serverInstanceComboBox = new JComboBox();
        this.serverInstanceLabel.setText(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_Server"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.serverInstanceLabel).addGap(18, 18, 18).addComponent(this.serverInstanceComboBox, -2, 221, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serverInstanceLabel).addComponent(this.serverInstanceComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public void initServers() {
        String[] sIDs;
        this.serverInstanceComboBox.removeAllItems();
        ServerWrapper bestServer = null;
        for (String serverInstanceID : sIDs = Deployment.getDefault().getServerInstanceIDs(Collections.singleton(J2eeModule.Type.WAR), Profile.JAVA_EE_6_FULL, new String[]{"jsr109"})) {
            String shortName;
            String displayName = Deployment.getDefault().getServerInstanceDisplayName(serverInstanceID);
            if (displayName == null) continue;
            ServerWrapper wrapper = new ServerWrapper(serverInstanceID, displayName);
            this.serverInstanceComboBox.addItem(wrapper);
            if (bestServer == null || !"J2EE".equals(shortName = Deployment.getDefault().getServerID(serverInstanceID))) continue;
            bestServer = wrapper;
        }
        if (bestServer != null) {
            this.serverInstanceComboBox.setSelectedItem(bestServer);
        }
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (this.serverInstanceComboBox.getItemCount() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"MSG_NoJsr109Server"));
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    void store(WizardDescriptor d) {
        ServerWrapper sw = (ServerWrapper)this.serverInstanceComboBox.getSelectedItem();
        if (sw != null) {
            d.putProperty("server", (Object)sw.getServerID());
        }
    }

    void read(WizardDescriptor d) {
    }

    private static class ServerWrapper {
        private String serverID;
        private String displayName;

        ServerWrapper(String sID, String displayName) {
            this.serverID = sID;
            this.displayName = displayName;
        }

        public String getServerID() {
            return this.serverID;
        }

        public void setServerID(String serverID) {
            this.serverID = serverID;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

