/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support.clank;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.zip.Adler32;
import org.netbeans.modules.cnd.apt.impl.support.SupportAPIAccessor;
import org.netbeans.modules.cnd.apt.support.api.PPMacroMap;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public class ClankMacroMap
implements PPMacroMap {
    private long startCRC;
    private List<String> macros;

    protected ClankMacroMap(long crc) {
        this.startCRC = crc;
        this.macros = Collections.emptyList();
    }

    public ClankMacroMap(List<String> sysMacros) {
        this.startCRC = ClankMacroMap.calculateCRC(sysMacros);
        this.macros = Collections.unmodifiableList(sysMacros);
    }

    public long getCompilationUnitCRC() {
        return this.startCRC;
    }

    protected Collection<String> getMacros() {
        return this.macros;
    }

    protected static long calculateCRC(List<String> sysMacros) {
        Adler32 checksum = new Adler32();
        for (String s : sysMacros) {
            checksum.update(s.getBytes(SupportAPIAccessor.INTERNAL_CHARSET), 0, s.length());
        }
        return checksum.getValue();
    }

    @Override
    public PPMacroMap.State getState() {
        return new StateImpl(this);
    }

    @Override
    public void setState(PPMacroMap.State state) {
        ((StateImpl)state).restoreTo(this);
    }

    public String toString() {
        return APTUtils.macros2String(this.macros);
    }

    public static class StateImpl
    implements PPMacroMap.State {
        private final List<String> macros;
        private long startCRC;
        protected final boolean cleaned;

        protected StateImpl(ClankMacroMap macroMap) {
            this.macros = macroMap.macros;
            this.startCRC = macroMap.startCRC;
            this.cleaned = false;
        }

        protected StateImpl(StateImpl other, boolean cleaned) {
            this.macros = other.macros;
            this.startCRC = other.startCRC;
            this.cleaned = cleaned;
        }

        public void write(RepositoryDataOutput output) throws IOException {
            output.writeLong(this.startCRC);
        }

        protected StateImpl(RepositoryDataInput input) throws IOException {
            this.startCRC = input.readLong();
            this.macros = Collections.emptyList();
            this.cleaned = true;
        }

        protected void restoreTo(ClankMacroMap macroMap) {
            if (!this.cleaned) {
                macroMap.macros = this.macros;
            }
            macroMap.startCRC = this.startCRC;
        }

        public PPMacroMap.State copyCleaned() {
            return this.cleaned ? this : new StateImpl(this, true);
        }

        public String toString() {
            return APTUtils.macros2String(this.macros);
        }
    }
}

