/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support.clank;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankDriverImpl;
import org.netbeans.modules.cnd.apt.support.APTFileSearch;
import org.netbeans.modules.cnd.apt.support.ClankDriver;
import org.netbeans.modules.cnd.apt.support.IncludeDirEntry;
import org.netbeans.modules.cnd.apt.support.api.PPIncludeHandler;
import org.netbeans.modules.cnd.apt.support.api.StartEntry;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.FSPath;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;
import org.openide.util.Parameters;

public class ClankIncludeHandlerImpl
implements PPIncludeHandler {
    private List<IncludeDirEntry> systemIncludePaths;
    private List<IncludeDirEntry> userIncludePaths;
    private List<IncludeDirEntry> userIncludeFilePaths;
    private StartEntry startFile;
    private final APTFileSearch fileSearch;
    private static final ClankDriverImpl.ClankPreprocessorOutputImplementation NO_PP_CONTENT = new ClankPPOutputImpl(-1);
    private int inclStackIndex;
    private ClankDriverImpl.ClankPreprocessorOutputImplementation cachedContent = NO_PP_CONTENT;
    private LinkedList<PPIncludeHandler.IncludeInfo> inclStack = null;

    public ClankIncludeHandlerImpl(StartEntry startFile) {
        this(startFile, new ArrayList<IncludeDirEntry>(0), new ArrayList<IncludeDirEntry>(0), new ArrayList<IncludeDirEntry>(0), startFile.getFileSearch());
    }

    public ClankIncludeHandlerImpl(StartEntry startFile, List<IncludeDirEntry> systemIncludePaths, List<IncludeDirEntry> userIncludePaths, List<IncludeDirEntry> userIncludeFilePaths, APTFileSearch fileSearch) {
        assert (APTTraceFlags.USE_CLANK);
        Parameters.notNull((CharSequence)"startFile", (Object)startFile);
        this.startFile = startFile;
        this.systemIncludePaths = systemIncludePaths;
        this.userIncludePaths = userIncludePaths;
        this.userIncludeFilePaths = userIncludeFilePaths;
        this.fileSearch = fileSearch;
        this.inclStackIndex = 0;
    }

    @Override
    public PPIncludeHandler.IncludeState pushInclude(FileSystem fs2, CharSequence path, int line, int offset, int resolvedDirIndex, int inclDirIndex) {
        return this.pushIncludeImpl(fs2, path, line, offset, resolvedDirIndex, inclDirIndex);
    }

    @Override
    public CharSequence popInclude() {
        return this.popIncludeImpl();
    }

    @Override
    public StartEntry getStartEntry() {
        return this.startFile;
    }

    private CharSequence getCurPath() {
        assert (this.inclStack != null);
        PPIncludeHandler.IncludeInfo info = this.inclStack.getLast();
        return info.getIncludedPath();
    }

    void resetIncludeStack() {
        this.inclStack = null;
        this.inclStackIndex = 0;
    }

    @Override
    public PPIncludeHandler.State getState() {
        return this.createStateImpl();
    }

    @Override
    public void setState(PPIncludeHandler.State state) {
        if (state instanceof StateImpl) {
            StateImpl stateImpl = (StateImpl)state;
            assert (APTTraceFlags.USE_CLANK);
            stateImpl.restoreTo(this);
        }
    }

    private StateImpl createStateImpl() {
        return new StateImpl(this);
    }

    public List<IncludeDirEntry> getUserIncludeFilePaths() {
        return Collections.unmodifiableList(this.userIncludeFilePaths);
    }

    public List<IncludeDirEntry> getUserIncludePaths() {
        return Collections.unmodifiableList(this.userIncludePaths);
    }

    public List<IncludeDirEntry> getSystemIncludePaths() {
        return Collections.unmodifiableList(this.systemIncludePaths);
    }

    public boolean isFirstLevel() {
        return this.inclStack == null || this.inclStack.isEmpty();
    }

    public ClankDriverImpl.ClankPreprocessorOutputImplementation getPreprocessorOutputImplementation() {
        if (this.cachedContent == NO_PP_CONTENT) {
            return new ClankPPOutputImpl(this.inclStackIndex);
        }
        return this.cachedContent;
    }

    public int getInclStackIndex() {
        return this.inclStackIndex;
    }

    void cachePreprocessorOutputImplementation(ClankDriverImpl.ClankPreprocessorOutputImplementation cache) {
        assert (cache != null);
        this.cachedContent = !cache.hasTokenStream() ? NO_PP_CONTENT : cache;
        this.inclStackIndex = cache.getFileIndex();
    }

    APTFileSearch getFileSearch() {
        return this.fileSearch;
    }

    private PPIncludeHandler.IncludeState pushIncludeImpl(FileSystem fs2, CharSequence path, int directiveLine, int directiveOffset, int resolvedDirIndex, int inclDirIndex) {
        assert (CharSequences.isCompact((CharSequence)path)) : "must be char sequence key " + path;
        boolean okToPush = true;
        if (this.inclStack == null) {
            this.inclStack = new LinkedList();
        }
        if (okToPush) {
            this.inclStack.addLast(new IncludeInfoImpl(fs2, path, directiveLine, directiveOffset, resolvedDirIndex, inclDirIndex));
            return PPIncludeHandler.IncludeState.Success;
        }
        APTUtils.LOG.log(Level.WARNING, "RECURSIVE inclusion:\n\t{0}\n\tin {1}\n", new Object[]{path, this.getCurPath()});
        return PPIncludeHandler.IncludeState.Recursive;
    }

    private CharSequence popIncludeImpl() {
        assert (this.inclStack != null);
        assert (!this.inclStack.isEmpty());
        PPIncludeHandler.IncludeInfo inclInfo = this.inclStack.removeLast();
        CharSequence path = inclInfo.getIncludedPath();
        return path;
    }

    public String toString() {
        return ClankIncludeHandlerImpl.toString(this.startFile.getStartFile(), this.systemIncludePaths, this.userIncludePaths, this.userIncludeFilePaths, this.inclStackIndex, this.inclStack, this.cachedContent);
    }

    private static String toString(CharSequence startFile, List<IncludeDirEntry> systemIncludePaths, List<IncludeDirEntry> userIncludePaths, List<IncludeDirEntry> userIncludeFilePaths, int inclStackIndex, Collection<PPIncludeHandler.IncludeInfo> inclStack, ClankDriver.ClankPreprocessorOutput cachedTokens) {
        StringBuilder retValue = new StringBuilder();
        retValue.append(cachedTokens.toString()).append("\n");
        if (!userIncludeFilePaths.isEmpty()) {
            retValue.append("User File Includes:\n");
            retValue.append(APTUtils.includes2String(userIncludeFilePaths)).append("\n");
        }
        retValue.append("User includes:\n");
        retValue.append(APTUtils.includes2String(userIncludePaths));
        retValue.append("\nSys includes:\n");
        retValue.append(APTUtils.includes2String(systemIncludePaths));
        retValue.append("\nInclude Stack starting from:\n");
        retValue.append(startFile).append("\n");
        retValue.append(ClankIncludeHandlerImpl.includesStack2String(inclStackIndex, inclStack));
        return retValue.toString();
    }

    private static String includesStack2String(int inclStackIndex, Collection<PPIncludeHandler.IncludeInfo> inclStack) {
        StringBuilder retValue = new StringBuilder();
        if (inclStackIndex == 0) {
            retValue.append("<not from #include>");
        } else {
            retValue.append("from inclStackIndex=").append(inclStackIndex);
            if (inclStack != null && !inclStack.isEmpty()) {
                retValue.append("\n");
                Iterator<PPIncludeHandler.IncludeInfo> it = inclStack.iterator();
                while (it.hasNext()) {
                    PPIncludeHandler.IncludeInfo info = it.next();
                    retValue.append(info);
                    if (!it.hasNext()) continue;
                    retValue.append("->\n");
                }
            }
        }
        return retValue.toString();
    }

    private static class ClankPPOutputImpl
    implements ClankDriverImpl.ClankPreprocessorOutputImplementation {
        private final int fileIndexInTranslationUnit;

        public ClankPPOutputImpl(int inclStackIndex) {
            this.fileIndexInTranslationUnit = inclStackIndex;
        }

        @Override
        public int getFileIndex() {
            return this.fileIndexInTranslationUnit;
        }

        @Override
        public int[] getSkippedRanges() {
            return null;
        }

        @Override
        public TokenStream getTokenStream() {
            return null;
        }

        @Override
        public boolean hasTokenStream() {
            return false;
        }

        public String toString() {
            return this.fileIndexInTranslationUnit == -1 ? "<DUMMY>" : "no cache for " + this.fileIndexInTranslationUnit;
        }

        @Override
        public Collection<ClankDriver.ClankPreprocessorDirective> getPreprocessorDirectives() {
            return Collections.emptyList();
        }

        @Override
        public Collection<ClankDriver.MacroExpansion> getMacroExpansions() {
            return Collections.emptyList();
        }

        @Override
        public Collection<ClankDriver.MacroUsage> getMacroUsages() {
            return Collections.emptyList();
        }

        @Override
        public ClankDriver.FileGuard getFileGuard() {
            return null;
        }

        @Override
        public ClankDriverImpl.ClankPreprocessorOutputImplementation prepareCachesIfPossible() {
            return this;
        }
    }

    private static final class IncludeInfoImpl
    implements PPIncludeHandler.IncludeInfo,
    SelfPersistent {
        private final FileSystem fs;
        private final CharSequence path;
        private final int directiveLine;
        private final int directiveOffset;
        private final int resolvedDirectoryIndex;
        private final int includeDirectiveIndex;

        public IncludeInfoImpl(FileSystem fs2, CharSequence path, int directiveLine, int directiveOffset, int resolvedDirectoryIndex, int includeDirectiveIndex) {
            assert (path != null);
            this.fs = fs2;
            this.path = path;
            assert (directiveLine >= 0 || directiveLine < 0 && directiveOffset < 0);
            this.directiveLine = directiveLine;
            this.directiveOffset = directiveOffset;
            this.resolvedDirectoryIndex = resolvedDirectoryIndex;
            this.includeDirectiveIndex = includeDirectiveIndex;
        }

        public IncludeInfoImpl(RepositoryDataInput input) throws IOException {
            assert (input != null);
            this.fs = input.readFileSystem();
            this.path = input.readFilePathForFileSystem(this.fs);
            this.directiveLine = input.readInt();
            this.directiveOffset = input.readInt();
            this.resolvedDirectoryIndex = input.readInt();
            this.includeDirectiveIndex = input.readInt();
        }

        @Override
        public FileSystem getFileSystem() {
            return this.fs;
        }

        @Override
        public CharSequence getIncludedPath() {
            return this.path;
        }

        @Override
        public int getIncludeDirectiveLine() {
            return this.directiveLine;
        }

        @Override
        public int getIncludeDirectiveOffset() {
            return this.directiveOffset;
        }

        public String toString() {
            String retValue = "(" + this.getIncludeDirectiveLine() + "/" + this.getIncludeDirectiveOffset() + ": " + this.getIncludedPath() + ":" + this.getResolvedDirectoryIndex() + ";#" + this.getIncludeDirectiveIndex() + ")";
            return retValue;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            IncludeInfoImpl other = (IncludeInfoImpl)obj;
            return this.resolvedDirectoryIndex == other.resolvedDirectoryIndex && this.includeDirectiveIndex == other.includeDirectiveIndex && this.path.equals(other.path);
        }

        public int hashCode() {
            int hash = 3;
            hash = 73 * hash + (this.path != null ? this.path.hashCode() : 0);
            hash = 73 * hash + this.resolvedDirectoryIndex;
            hash = 73 * hash + this.includeDirectiveIndex;
            return hash;
        }

        public void write(RepositoryDataOutput output) throws IOException {
            assert (output != null);
            output.writeFileSystem(this.fs);
            output.writeFilePathForFileSystem(this.fs, this.path);
            output.writeInt(this.directiveLine);
            output.writeInt(this.directiveOffset);
            output.writeInt(this.resolvedDirectoryIndex);
            output.writeInt(this.includeDirectiveIndex);
        }

        @Override
        public int getResolvedDirectoryIndex() {
            return this.resolvedDirectoryIndex;
        }

        @Override
        public int getIncludeDirectiveIndex() {
            return this.includeDirectiveIndex;
        }
    }

    public static final class StateImpl
    implements PPIncludeHandler.State,
    Persistent {
        private static final List<IncludeDirEntry> CLEANED_MARKER = Collections.unmodifiableList(new ArrayList(0));
        private final List<IncludeDirEntry> systemIncludePaths;
        private final List<IncludeDirEntry> userIncludePaths;
        private final List<IncludeDirEntry> userIncludeFilePaths;
        private final StartEntry startFile;
        private final int inclStackIndex;
        private final ClankDriverImpl.ClankPreprocessorOutputImplementation cachedContent;
        private static final PPIncludeHandler.IncludeInfo[] EMPTY_STACK = new PPIncludeHandler.IncludeInfo[0];
        private final PPIncludeHandler.IncludeInfo[] inclStack;
        private int hashCode = 0;
        private final boolean cleaned;
        private final boolean alreadyTriedCachePreparation;

        protected StateImpl(ClankIncludeHandlerImpl handler) {
            this.systemIncludePaths = handler.systemIncludePaths;
            this.userIncludePaths = handler.userIncludePaths;
            this.userIncludeFilePaths = handler.userIncludeFilePaths;
            this.startFile = handler.startFile;
            this.inclStack = handler.inclStack != null && !handler.inclStack.isEmpty() ? handler.inclStack.toArray(new PPIncludeHandler.IncludeInfo[handler.inclStack.size()]) : EMPTY_STACK;
            this.inclStackIndex = handler.inclStackIndex;
            this.cachedContent = handler.cachedContent;
            this.cleaned = false;
            this.alreadyTriedCachePreparation = false;
            assert (this.cachedContent != null);
        }

        private StateImpl(StateImpl other, boolean cleanState, boolean prepareCachesIfPossible) {
            assert (cleanState || prepareCachesIfPossible);
            this.startFile = other.startFile;
            this.inclStack = other.inclStack;
            this.inclStackIndex = other.inclStackIndex;
            this.cleaned = cleanState;
            if (cleanState) {
                this.systemIncludePaths = CLEANED_MARKER;
                this.userIncludePaths = CLEANED_MARKER;
                this.userIncludeFilePaths = CLEANED_MARKER;
            } else {
                this.systemIncludePaths = other.systemIncludePaths;
                this.userIncludePaths = other.userIncludePaths;
                this.userIncludeFilePaths = other.userIncludeFilePaths;
            }
            if (cleanState) {
                this.alreadyTriedCachePreparation = true;
                this.cachedContent = NO_PP_CONTENT;
            } else if (prepareCachesIfPossible) {
                this.alreadyTriedCachePreparation = true;
                this.cachedContent = other.cachedContent.prepareCachesIfPossible();
            } else {
                this.alreadyTriedCachePreparation = other.alreadyTriedCachePreparation;
                this.cachedContent = other.cachedContent;
            }
            assert (this.cachedContent != null);
        }

        public int getIncludeStackDepth() {
            return this.inclStack.length;
        }

        private void restoreTo(ClankIncludeHandlerImpl handler) {
            if (this.cleaned) {
                assert (StateImpl.areStartEntriesEqual(handler.startFile, this.startFile)) : "handler's startFile " + ClankIncludeHandlerImpl.access$400(handler) + " vs. state startFile " + this.startFile;
            } else {
                handler.userIncludePaths = this.userIncludePaths;
                handler.userIncludeFilePaths = this.userIncludeFilePaths;
                handler.systemIncludePaths = this.systemIncludePaths;
                handler.startFile = this.startFile;
            }
            if (this.inclStack.length > 0) {
                handler.startFile = this.startFile;
                handler.inclStack = new LinkedList();
                handler.inclStack.addAll(Arrays.asList(this.inclStack));
            }
            handler.inclStackIndex = this.inclStackIndex;
            handler.cachedContent = this.cachedContent;
        }

        private static boolean areStartEntriesEqual(StartEntry first, StartEntry second) {
            try {
                if (first.equals(second)) {
                    return true;
                }
                FSPath fsFirst = new FSPath(first.getFileSystem(), first.getStartFile().toString());
                FSPath fsSecond = new FSPath(second.getFileSystem(), second.getStartFile().toString());
                if (!fsFirst.getFileObject().getCanonicalFileObject().equals(fsSecond.getFileObject().getCanonicalFileObject())) {
                    return false;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }

        public String toString() {
            return ClankIncludeHandlerImpl.toString(this.startFile.getStartFile(), this.systemIncludePaths, this.userIncludePaths, this.userIncludeFilePaths, this.inclStackIndex, Arrays.asList(this.inclStack), this.cachedContent);
        }

        public void write(RepositoryDataOutput output) throws IOException {
            assert (output != null);
            this.startFile.write(output);
            output.writeInt(this.inclStackIndex);
            output.writeInt(this.inclStack.length);
            for (PPIncludeHandler.IncludeInfo inclInfo : this.inclStack) {
                assert (inclInfo != null);
                IncludeInfoImpl inclInfoImpl = inclInfo instanceof IncludeInfoImpl ? (IncludeInfoImpl)inclInfo : new IncludeInfoImpl(inclInfo.getFileSystem(), inclInfo.getIncludedPath(), inclInfo.getIncludeDirectiveLine(), inclInfo.getIncludeDirectiveOffset(), inclInfo.getResolvedDirectoryIndex(), inclInfo.getIncludeDirectiveIndex());
                assert (inclInfoImpl != null);
                inclInfoImpl.write(output);
            }
        }

        public StateImpl(RepositoryDataInput input) throws IOException {
            assert (input != null);
            this.startFile = new StartEntry(input);
            this.cleaned = true;
            this.alreadyTriedCachePreparation = true;
            this.systemIncludePaths = CLEANED_MARKER;
            this.userIncludePaths = CLEANED_MARKER;
            this.userIncludeFilePaths = CLEANED_MARKER;
            this.inclStackIndex = input.readInt();
            this.cachedContent = NO_PP_CONTENT;
            assert (this.cachedContent != null);
            int size = input.readInt();
            if (size == 0) {
                this.inclStack = EMPTY_STACK;
            } else {
                this.inclStack = new PPIncludeHandler.IncludeInfo[size];
                for (int i = 0; i < size; ++i) {
                    IncludeInfoImpl impl = new IncludeInfoImpl(input);
                    assert (impl != null);
                    this.inclStack[i] = impl;
                }
            }
        }

        public final StartEntry getStartEntry() {
            return this.startFile;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            StateImpl other = (StateImpl)obj;
            return this.startFile.equals(other.startFile) && this.inclStackIndex == other.inclStackIndex && this.compareStacks(this.inclStack, other.inclStack);
        }

        public int hashCode() {
            int hash = this.hashCode;
            if (hash == 0) {
                hash = 5;
                hash = 67 * hash + (this.startFile != null ? this.startFile.hashCode() : 0);
                this.hashCode = hash = 67 * hash + this.inclStackIndex;
            }
            return hash;
        }

        private boolean compareStacks(PPIncludeHandler.IncludeInfo[] inclStack1, PPIncludeHandler.IncludeInfo[] inclStack2) {
            if (inclStack1 == inclStack2) {
                return true;
            }
            if (inclStack1.length != inclStack2.length) {
                return false;
            }
            for (int i = 0; i < inclStack1.length; ++i) {
                PPIncludeHandler.IncludeInfo cur1 = inclStack1[i];
                PPIncludeHandler.IncludeInfo cur2 = inclStack2[i];
                if (cur1.equals(cur2)) continue;
                return false;
            }
            return true;
        }

        public Collection<PPIncludeHandler.IncludeInfo> getIncludeStack() {
            return Arrays.asList(this.inclStack);
        }

        public PPIncludeHandler.State copyCleaned() {
            return this.cleaned ? this : new StateImpl(this, true, false);
        }

        public PPIncludeHandler.State prepareCachesIfPossible() {
            return this.alreadyTriedCachePreparation ? this : new StateImpl(this, this.cleaned, true);
        }

        public List<IncludeDirEntry> getSysIncludePaths() {
            return this.systemIncludePaths;
        }

        public List<IncludeDirEntry> getUserIncludePaths() {
            return this.userIncludePaths;
        }

        public List<IncludeDirEntry> getUserIncludeFilePaths() {
            return this.userIncludeFilePaths;
        }

        public int getIncludeStackIndex() {
            return this.inclStackIndex;
        }
    }
}

