/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.util.List;
import java.util.logging.Level;
import java.util.zip.Adler32;
import org.netbeans.modules.cnd.apt.impl.support.APTBaseMacroMap;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroImpl;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroMapSnapshot;
import org.netbeans.modules.cnd.apt.impl.support.APTPredefinedMacroMap;
import org.netbeans.modules.cnd.apt.impl.support.SupportAPIAccessor;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTUtils;

public class APTSystemMacroMap
extends APTBaseMacroMap {
    private APTMacroMap preMacroMap = new APTPredefinedMacroMap();
    private final long startCRC;

    protected APTSystemMacroMap(long crc) {
        this.startCRC = crc;
    }

    public APTSystemMacroMap(List<String> sysMacros) {
        this(APTSystemMacroMap.calculateCRC(sysMacros));
        this.fill(sysMacros, true);
    }

    @Override
    protected APTMacro createMacro(CharSequence file, APTDefine define, APTMacro.Kind macroType) {
        return new APTMacroImpl(file, define, macroType);
    }

    @Override
    public boolean pushPPDefined() {
        APTUtils.LOG.log(Level.SEVERE, "pushPPDefined is not supported", new IllegalAccessException());
        return false;
    }

    @Override
    public boolean popPPDefined() {
        APTUtils.LOG.log(Level.SEVERE, "popPPDefined is not supported", new IllegalAccessException());
        return false;
    }

    @Override
    public boolean pushExpanding(APTToken token) {
        APTUtils.LOG.log(Level.SEVERE, "pushExpanding is not supported", new IllegalAccessException());
        return false;
    }

    @Override
    public void popExpanding() {
        APTUtils.LOG.log(Level.SEVERE, "popExpanding is not supported", new IllegalAccessException());
    }

    @Override
    public boolean isExpanding(APTToken token) {
        APTUtils.LOG.log(Level.SEVERE, "isExpanding is not supported", new IllegalAccessException());
        return false;
    }

    @Override
    public APTMacro getMacro(APTToken token) {
        APTMacro res = super.getMacro(token);
        if (res == null) {
            res = this.preMacroMap.getMacro(token);
        }
        return res != APTMacroMapSnapshot.UNDEFINED_MACRO ? res : null;
    }

    @Override
    protected APTMacroMapSnapshot makeSnapshot(APTMacroMapSnapshot parent) {
        assert (parent == null) : "parent must be null";
        return new APTMacroMapSnapshot((APTMacroMapSnapshot)null);
    }

    @Override
    public void define(APTFile file, APTDefine define, APTMacro.Kind macroType) {
        throw new UnsupportedOperationException("Can not modify immutable System macro map");
    }

    @Override
    public void undef(APTFile file, APTToken name) {
        throw new UnsupportedOperationException("Can not modify immutable System macro map");
    }

    public long getCompilationUnitCRC() {
        return this.startCRC;
    }

    private static long calculateCRC(List<String> sysMacros) {
        Adler32 checksum = new Adler32();
        for (String s : sysMacros) {
            checksum.update(s.getBytes(SupportAPIAccessor.INTERNAL_CHARSET), 0, s.length());
        }
        return checksum.getValue();
    }
}

