/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.api;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.docker.Endpoint;
import org.netbeans.modules.docker.StreamItem;

public final class ActionChunkedResult
implements Closeable {
    private final Endpoint s;
    private final StreamItem.Fetcher fetcher;
    private final Charset charset;

    ActionChunkedResult(Endpoint s, StreamItem.Fetcher fetcher, Charset charset) {
        this.s = s;
        this.fetcher = fetcher;
        this.charset = charset;
    }

    @CheckForNull
    public Chunk fetchChunk() {
        StreamItem r = this.fetcher.fetch();
        if (r == null) {
            return null;
        }
        ByteBuffer buffer = r.getData();
        return new Chunk(new String(buffer.array(), buffer.position(), buffer.limit(), this.charset), r.isError());
    }

    @Override
    public void close() throws IOException {
        this.s.close();
    }

    public static class Chunk {
        private final String data;
        private final boolean error;

        private Chunk(String data, boolean error) {
            this.data = data;
            this.error = error;
        }

        public String getData() {
            return this.data;
        }

        public boolean isError() {
            return this.error;
        }
    }
}

