/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import java.io.IOException;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import org.springframework.web.portlet.handler.HandlerInterceptorAdapter;

public class UserRoleAuthorizationInterceptor
extends HandlerInterceptorAdapter {
    private String[] authorizedRoles;

    public final void setAuthorizedRoles(String[] authorizedRoles) {
        this.authorizedRoles = authorizedRoles;
    }

    public final boolean preHandle(PortletRequest request, PortletResponse response, Object handler) throws PortletException, IOException {
        if (this.authorizedRoles != null) {
            for (String role : this.authorizedRoles) {
                if (!request.isUserInRole(role)) continue;
                return true;
            }
        }
        this.handleNotAuthorized(request, response, handler);
        return false;
    }

    protected void handleNotAuthorized(PortletRequest request, PortletResponse response, Object handler) throws PortletException, IOException {
        throw new PortletSecurityException("Request not authorized");
    }
}

