/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.SmallVectorImplUChar;
import org.llvm.adt.aliases.SmallVectorUChar;
import org.llvm.ir.ArrayType;
import org.llvm.ir.GlobalVariable;
import org.llvm.ir.IntegerType;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.LayoutAlignElem;
import org.llvm.ir.Module;
import org.llvm.ir.PointerAlignElem;
import org.llvm.ir.PointerType;
import org.llvm.ir.StructLayout;
import org.llvm.ir.StructType;
import org.llvm.ir.Type;
import org.llvm.ir.Value;
import org.llvm.ir.VectorType;
import org.llvm.ir.impl.DataLayoutStatics;
import org.llvm.ir.impl.StructLayoutMap;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public class DataLayout
implements Destructors.ClassWithDestructor,
Native.NativeComparable<DataLayout> {
    private boolean BigEndian;
    private int StackNaturalAlign;
    private ManglingModeT ManglingMode;
    private SmallVectorUChar LegalIntWidths = new SmallVectorUChar(8, 0);
    private SmallVector<LayoutAlignElem> Alignments = new SmallVector(16, (Object)new LayoutAlignElem());
    private std.string StringRepresentation = new std.string();
    private SmallVector<PointerAlignElem> Pointers = new SmallVector(8, (Object)new PointerAlignElem());
    private static LayoutAlignElem InvalidAlignmentElem = new LayoutAlignElem(0, 0, 0, 0);
    private static PointerAlignElem InvalidPointerElem = new PointerAlignElem(0, 0, 0, -1);
    private Object LayoutMap = null;

    private SmallVectorImpl.iterator<PointerAlignElem> findPointerLowerBound(int AddressSpace) {
        return (SmallVectorImpl.iterator)std.lower_bound((type.iterator)this.Pointers.begin(), (type.iterator)this.Pointers.end(), (Object)AddressSpace, (A, _AddressSpace) -> Unsigned.$less_uint((int)((PointerAlignElem)A).AddressSpace, (int)_AddressSpace));
    }

    private void setAlignment(byte align_type, int abi_align, int pref_align, int bit_width) {
        if (!llvm.isUInt24((long)Unsigned.$uint2ulong((int)bit_width))) {
            llvm.report_fatal_error((char.ptr)NativePointer.$((String)("Invalid bit width, must be a 24bit integer:" + bit_width)));
        }
        if (!llvm.isUInt16((long)Unsigned.$uint2ulong((int)abi_align))) {
            llvm.report_fatal_error((char.ptr)NativePointer.$((String)("Invalid ABI alignment, must be a 16bit integer:" + abi_align)));
        }
        if (!llvm.isUInt16((long)Unsigned.$uint2ulong((int)pref_align))) {
            llvm.report_fatal_error((char.ptr)NativePointer.$((String)("Invalid preferred alignment, must be a 16bit integer:" + pref_align)));
        }
        if (abi_align != 0 && !llvm.isPowerOf2_64((long)Unsigned.$uint2ulong((int)abi_align))) {
            llvm.report_fatal_error((char.ptr)NativePointer.$((String)("Invalid ABI alignment, must be a power of 2:" + abi_align)));
        }
        if (pref_align != 0 && !llvm.isPowerOf2_64((long)Unsigned.$uint2ulong((int)pref_align))) {
            llvm.report_fatal_error((char.ptr)NativePointer.$((String)("Invalid preferred alignment, must be a power of 2:" + pref_align)));
        }
        if (Unsigned.$less_uint((int)pref_align, (int)abi_align)) {
            llvm.report_fatal_error((char.ptr)NativePointer.$((String)("Preferred alignment cannot be less than the ABI alignment:" + pref_align + " vs. " + abi_align)));
        }
        for (LayoutAlignElem Elem : this.Alignments) {
            if (Elem.AlignType != align_type || Elem.TypeBitWidth != bit_width) continue;
            Elem.ABIAlign = Unsigned.$uint2ushort((int)abi_align);
            Elem.PrefAlign = Unsigned.$uint2ushort((int)pref_align);
            return;
        }
        this.Alignments.push_back((Object)LayoutAlignElem.get(align_type, abi_align, pref_align, bit_width));
    }

    private int getAlignmentInfo(byte AlignType, int BitWidth, boolean ABIInfo, Type Ty) {
        int Align;
        int BestMatchIdx = -1;
        int LargestInt = -1;
        int e = this.Alignments.size();
        for (int i = 0; i != e; ++i) {
            if (((LayoutAlignElem)this.Alignments.$at((int)i)).AlignType == AlignType && ((LayoutAlignElem)this.Alignments.$at((int)i)).TypeBitWidth == BitWidth) {
                return ABIInfo ? ((LayoutAlignElem)this.Alignments.$at((int)i)).ABIAlign : ((LayoutAlignElem)this.Alignments.$at((int)i)).PrefAlign;
            }
            if (AlignType != 105 || ((LayoutAlignElem)this.Alignments.$at((int)i)).AlignType != 105) continue;
            if (Unsigned.$greater_uint((int)((LayoutAlignElem)this.Alignments.$at((int)i)).TypeBitWidth, (int)BitWidth) && (BestMatchIdx == -1 || ((LayoutAlignElem)this.Alignments.$at((int)i)).TypeBitWidth < ((LayoutAlignElem)this.Alignments.$at((int)BestMatchIdx)).TypeBitWidth)) {
                BestMatchIdx = i;
            }
            if (LargestInt != -1 && ((LayoutAlignElem)this.Alignments.$at((int)i)).TypeBitWidth <= ((LayoutAlignElem)this.Alignments.$at((int)LargestInt)).TypeBitWidth) continue;
            LargestInt = i;
        }
        if (BestMatchIdx == -1) {
            if (AlignType == 105) {
                BestMatchIdx = LargestInt;
            } else if (AlignType == 118) {
                Align = Unsigned.$ulong2uint((long)this.getTypeAllocSize(((VectorType)llvm.cast(VectorType.class, (Object)Ty)).getElementType()));
                if (((Align *= ((VectorType)llvm.cast(VectorType.class, (Object)Ty)).getNumElements()) & Align - 1) != 0) {
                    Align = Unsigned.$ulong2uint((long)llvm.NextPowerOf2((long)Unsigned.$uint2ulong((int)Align)));
                }
                return Align;
            }
        }
        if (BestMatchIdx == -1) {
            Align = Unsigned.$ulong2uint((long)this.getTypeStoreSize(Ty));
            if ((Align & Align - 1) != 0) {
                Align = Unsigned.$ulong2uint((long)llvm.NextPowerOf2((long)Unsigned.$uint2ulong((int)Align)));
            }
            return Align;
        }
        return ABIInfo ? ((LayoutAlignElem)this.Alignments.$at((int)BestMatchIdx)).ABIAlign : ((LayoutAlignElem)this.Alignments.$at((int)BestMatchIdx)).PrefAlign;
    }

    private void setPointerAlignment(int AddrSpace, int ABIAlign, int PrefAlign, int TypeByteWidth) {
        SmallVectorImpl.iterator<PointerAlignElem> I;
        if (Unsigned.$less_uint((int)PrefAlign, (int)ABIAlign)) {
            llvm.report_fatal_error((char.ptr)NativePointer.$((String)("Preferred alignment cannot be less than the ABI alignment: " + PrefAlign + " vs. " + ABIAlign)));
        }
        if (Native.$eq_iter(I = this.findPointerLowerBound(AddrSpace), (abstract_iterator)this.Pointers.end()) || ((PointerAlignElem)I.$star()).AddressSpace != AddrSpace) {
            this.Pointers.insert(I, (Object)PointerAlignElem.get(AddrSpace, ABIAlign, PrefAlign, TypeByteWidth));
        } else {
            ((PointerAlignElem)I.$star()).ABIAlign = ABIAlign;
            ((PointerAlignElem)I.$star()).PrefAlign = PrefAlign;
            ((PointerAlignElem)I.$star()).TypeByteWidth = TypeByteWidth;
        }
    }

    private int getAlignment(Type Ty, boolean abi_or_pref) {
        int AlignType = -1;
        assert (Ty.isSized()) : "Cannot getTypeInfo() on a type that is unsized!";
        switch (Ty.getTypeID()) {
            case LabelTyID: {
                return abi_or_pref ? this.getPointerABIAlignment(0) : this.getPointerPrefAlignment(0);
            }
            case PointerTyID: {
                int AS = ((PointerType)llvm.cast(PointerType.class, (Object)Ty)).getAddressSpace();
                return abi_or_pref ? this.getPointerABIAlignment(AS) : this.getPointerPrefAlignment(AS);
            }
            case ArrayTyID: {
                return this.getAlignment(((ArrayType)llvm.cast(ArrayType.class, (Object)Ty)).getElementType(), abi_or_pref);
            }
            case StructTyID: {
                if (((StructType)llvm.cast(StructType.class, (Object)Ty)).isPacked() && abi_or_pref) {
                    return 1;
                }
                StructLayout Layout = this.getStructLayout((StructType)llvm.cast(StructType.class, (Object)Ty));
                int Align = this.getAlignmentInfo((byte)97, 0, abi_or_pref, Ty);
                return std.max((int)Align, (int)Layout.getAlignment());
            }
            case IntegerTyID: {
                AlignType = 105;
                break;
            }
            case HalfTyID: 
            case FloatTyID: 
            case DoubleTyID: 
            case PPC_FP128TyID: 
            case FP128TyID: 
            case X86_FP80TyID: {
                AlignType = 102;
                break;
            }
            case X86_MMXTyID: 
            case VectorTyID: {
                AlignType = 118;
                break;
            }
            default: {
                throw new llvm_unreachable("Bad type for getAlignment!!!");
            }
        }
        return this.getAlignmentInfo((byte)AlignType, Unsigned.$ulong2uint((long)this.getTypeSizeInBits(Ty)), abi_or_pref, Ty);
    }

    private boolean validAlignment(LayoutAlignElem align) {
        return align != InvalidAlignmentElem;
    }

    private boolean validPointer(PointerAlignElem align) {
        return align != InvalidPointerElem;
    }

    private void parseSpecifier(StringRef Desc) {
        this.StringRepresentation.$assignMove(Desc.$basic_string());
        while (!Desc.empty()) {
            std_pair.pair<StringRef, StringRef> Split = DataLayoutStatics.split(new StringRef(Desc), (byte)45);
            Desc.$assign((StringRef)Split.second);
            Split.$assignMove(DataLayoutStatics.split(new StringRef((StringRef)Split.first), (byte)58));
            StringRef Tok = (StringRef)Split.first;
            StringRef Rest = (StringRef)Split.second;
            byte Specifier = Tok.front();
            Tok.$assignMove(Tok.substr(1));
            block0 : switch (Specifier) {
                case 115: {
                    break;
                }
                case 69: {
                    this.BigEndian = true;
                    break;
                }
                case 101: {
                    this.BigEndian = false;
                    break;
                }
                case 112: {
                    int AddrSpace;
                    int n = AddrSpace = Tok.empty() ? 0 : DataLayoutStatics.getInt(new StringRef(Tok));
                    if (!llvm.isUInt24((long)Unsigned.$uint2ulong((int)AddrSpace))) {
                        llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Invalid address space, must be a 24bit integer"));
                    }
                    if (Rest.empty()) {
                        llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Missing size specification for pointer in datalayout string"));
                    }
                    Split.$assignMove(DataLayoutStatics.split(new StringRef(Rest), (byte)58));
                    int PointerMemSize = DataLayoutStatics.inBytes(DataLayoutStatics.getInt(new StringRef(Tok)));
                    if (PointerMemSize == 0) {
                        llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Invalid pointer size of 0 bytes"));
                    }
                    if (Rest.empty()) {
                        llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Missing alignment specification for pointer in datalayout string"));
                    }
                    Split.$assignMove(DataLayoutStatics.split(new StringRef(Rest), (byte)58));
                    int PointerABIAlign = DataLayoutStatics.inBytes(DataLayoutStatics.getInt(new StringRef(Tok)));
                    if (!llvm.isPowerOf2_64((long)Unsigned.$uint2ulong((int)PointerABIAlign))) {
                        llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Pointer ABI alignment must be a power of 2"));
                    }
                    int PointerPrefAlign = PointerABIAlign;
                    if (!Rest.empty()) {
                        Split.$assignMove(DataLayoutStatics.split(new StringRef(Rest), (byte)58));
                        PointerPrefAlign = DataLayoutStatics.inBytes(DataLayoutStatics.getInt(new StringRef(Tok)));
                        if (!llvm.isPowerOf2_64((long)Unsigned.$uint2ulong((int)PointerPrefAlign))) {
                            llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Pointer preferred alignment must be a power of 2"));
                        }
                    }
                    this.setPointerAlignment(AddrSpace, PointerABIAlign, PointerPrefAlign, PointerMemSize);
                    break;
                }
                case 97: 
                case 102: 
                case 105: 
                case 118: {
                    int Size;
                    byte AlignType;
                    switch (Specifier) {
                        default: {
                            AlignType = 105;
                            break;
                        }
                        case 118: {
                            AlignType = 118;
                            break;
                        }
                        case 102: {
                            AlignType = 102;
                            break;
                        }
                        case 97: {
                            AlignType = 97;
                        }
                    }
                    int n = Size = Tok.empty() ? 0 : DataLayoutStatics.getInt(new StringRef(Tok));
                    if (AlignType == 97 && Size != 0) {
                        llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Sized aggregate specification in datalayout string"));
                    }
                    if (Rest.empty()) {
                        llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Missing alignment specification in datalayout string"));
                    }
                    Split.$assignMove(DataLayoutStatics.split(new StringRef(Rest), (byte)58));
                    int ABIAlign = DataLayoutStatics.inBytes(DataLayoutStatics.getInt(new StringRef(Tok)));
                    if (AlignType != 97 && ABIAlign == 0) {
                        llvm.report_fatal_error((char.ptr)NativePointer.$((String)"ABI alignment specification must be >0 for non-aggregate types"));
                    }
                    int PrefAlign = ABIAlign;
                    if (!Rest.empty()) {
                        Split.$assignMove(DataLayoutStatics.split(new StringRef(Rest), (byte)58));
                        PrefAlign = DataLayoutStatics.inBytes(DataLayoutStatics.getInt(new StringRef(Tok)));
                    }
                    this.setAlignment(AlignType, ABIAlign, PrefAlign, Size);
                    break;
                }
                case 110: {
                    while (true) {
                        int Width;
                        if ((Width = DataLayoutStatics.getInt(new StringRef(Tok))) == 0) {
                            llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Zero width native integer type in datalayout string"));
                        }
                        this.LegalIntWidths.push_back(Unsigned.$uint2uchar((int)Width));
                        if (Rest.empty()) break block0;
                        Split.$assignMove(DataLayoutStatics.split(new StringRef(Rest), (byte)58));
                    }
                }
                case 83: {
                    this.StackNaturalAlign = DataLayoutStatics.inBytes(DataLayoutStatics.getInt(new StringRef(Tok)));
                    break;
                }
                case 109: {
                    if (!Tok.empty()) {
                        llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Unexpected trailing characters after mangling specifier in datalayout string"));
                    }
                    if (Rest.empty()) {
                        llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Expected mangling specifier in datalayout string"));
                    }
                    if (Unsigned.$greater_uint((int)Rest.size(), (int)1)) {
                        llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Unknown mangling specifier in datalayout string"));
                    }
                    switch (Rest.$at(0)) {
                        default: {
                            llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Unknown mangling in datalayout string"));
                        }
                        case 101: {
                            this.ManglingMode = ManglingModeT.MM_ELF;
                            break block0;
                        }
                        case 111: {
                            this.ManglingMode = ManglingModeT.MM_MachO;
                            break block0;
                        }
                        case 109: {
                            this.ManglingMode = ManglingModeT.MM_Mips;
                            break block0;
                        }
                        case 119: {
                            this.ManglingMode = ManglingModeT.MM_WinCOFF;
                            break block0;
                        }
                        case 120: 
                    }
                    this.ManglingMode = ManglingModeT.MM_WinCOFFX86;
                    break;
                }
                default: {
                    llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Unknown specifier in datalayout string"));
                }
            }
        }
    }

    private void clear() {
        this.LegalIntWidths.clear();
        this.Alignments.clear();
        this.Pointers.clear();
        if ((StructLayoutMap)this.LayoutMap != null) {
            ((StructLayoutMap)this.LayoutMap).$destroy();
        }
        this.LayoutMap = null;
    }

    public DataLayout(StringRef LayoutDescription) {
        this.reset(LayoutDescription);
    }

    public DataLayout(Module M) {
        this.init(M);
    }

    public void init(Module M) {
        this.$assign(M.getDataLayout());
    }

    public DataLayout(DataLayout DL) {
        this.$assign(DL);
    }

    public DataLayout $assign(DataLayout DL) {
        this.clear();
        this.StringRepresentation.$assign(DL.StringRepresentation);
        this.BigEndian = DL.isBigEndian();
        this.StackNaturalAlign = DL.StackNaturalAlign;
        this.ManglingMode = DL.ManglingMode;
        this.LegalIntWidths.$assign((SmallVectorImplUChar)DL.LegalIntWidths);
        this.Alignments.$assign(DL.Alignments);
        this.Pointers.$assign(DL.Pointers);
        return this;
    }

    public boolean $eq(DataLayout Other) {
        if (Other == null) {
            return false;
        }
        boolean Ret = this.BigEndian == Other.BigEndian && this.StackNaturalAlign == Other.StackNaturalAlign && this.ManglingMode == Other.ManglingMode && this.LegalIntWidths.$eq((SmallVectorImplUChar)Other.LegalIntWidths) && this.Alignments.$eq(Other.Alignments) && this.Pointers.$eq(Other.Pointers);
        return Ret;
    }

    public boolean $noteq(DataLayout Other) {
        return !this.$eq(Other);
    }

    public void $destroy() {
        this.clear();
        this.Pointers.$destroy();
        this.StringRepresentation.$destroy();
        this.Alignments.$destroy();
        this.LegalIntWidths.$destroy();
    }

    public void reset(StringRef Desc) {
        this.clear();
        this.LayoutMap = null;
        this.BigEndian = false;
        this.StackNaturalAlign = 0;
        this.ManglingMode = ManglingModeT.MM_None;
        for (LayoutAlignElem E : DataLayoutStatics.DefaultAlignments) {
            this.setAlignment(E.AlignType, Unsigned.$ushort2uint((char)E.ABIAlign), Unsigned.$ushort2uint((char)E.PrefAlign), E.TypeBitWidth);
        }
        this.setPointerAlignment(0, 8, 8, 8);
        this.parseSpecifier(new StringRef(Desc));
    }

    public boolean isLittleEndian() {
        return !this.BigEndian;
    }

    public boolean isBigEndian() {
        return this.BigEndian;
    }

    public std.string getStringRepresentation() {
        return this.StringRepresentation;
    }

    public boolean isDefault() {
        return this.StringRepresentation.empty();
    }

    public boolean isLegalInteger(long Width) {
        Iterator iterator2 = this.LegalIntWidths.iterator();
        while (iterator2.hasNext()) {
            byte LegalIntWidth = (Byte)iterator2.next();
            if (Unsigned.$uint2ullong((int)LegalIntWidth) != Width) continue;
            return true;
        }
        return false;
    }

    public boolean isIllegalInteger(long Width) {
        return !this.isLegalInteger(Width);
    }

    public boolean exceedsNaturalStackAlignment(int Align) {
        return this.StackNaturalAlign != 0 && Unsigned.$greater_uint((int)Align, (int)this.StackNaturalAlign);
    }

    public int getStackAlignment() {
        return this.StackNaturalAlign;
    }

    public boolean hasMicrosoftFastStdCallMangling() {
        return this.ManglingMode == ManglingModeT.MM_WinCOFFX86;
    }

    public boolean hasLinkerPrivateGlobalPrefix() {
        return this.ManglingMode == ManglingModeT.MM_MachO;
    }

    public char.ptr getLinkerPrivateGlobalPrefix() {
        if (this.ManglingMode == ManglingModeT.MM_MachO) {
            return NativePointer.$l;
        }
        return NativePointer.$EMPTY;
    }

    public byte getGlobalPrefix() {
        switch (this.ManglingMode) {
            case MM_None: 
            case MM_ELF: 
            case MM_Mips: 
            case MM_WinCOFF: {
                return 0;
            }
            case MM_MachO: 
            case MM_WinCOFFX86: {
                return 95;
            }
        }
        throw new llvm_unreachable("invalid mangling mode");
    }

    public char.ptr getPrivateGlobalPrefix() {
        switch (this.ManglingMode) {
            case MM_None: {
                return NativePointer.$EMPTY;
            }
            case MM_ELF: {
                return NativePointer.$((String)".L");
            }
            case MM_Mips: {
                return NativePointer.$DOLLAR;
            }
            case MM_WinCOFF: 
            case MM_MachO: 
            case MM_WinCOFFX86: {
                return NativePointer.$L;
            }
        }
        throw new llvm_unreachable("invalid mangling mode");
    }

    public static char.ptr getManglingComponent(Triple T) {
        if (T.isOSBinFormatMachO()) {
            return NativePointer.$((String)"-m:o");
        }
        if (T.isOSWindows() && T.isOSBinFormatCOFF()) {
            return T.getArch() == Triple.ArchType.x86 ? NativePointer.$((String)"-m:x") : NativePointer.$((String)"-m:w");
        }
        return NativePointer.$((String)"-m:e");
    }

    public boolean fitsInLegalInteger(int Width) {
        Iterator iterator2 = this.LegalIntWidths.iterator();
        while (iterator2.hasNext()) {
            byte LegalIntWidth = (Byte)iterator2.next();
            if (!Unsigned.$lesseq_uint((int)Width, (int)LegalIntWidth)) continue;
            return true;
        }
        return false;
    }

    public int getPointerABIAlignment() {
        return this.getPointerABIAlignment(0);
    }

    public int getPointerABIAlignment(int AS) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public int getPointerPrefAlignment() {
        return this.getPointerPrefAlignment(0);
    }

    public int getPointerPrefAlignment(int AS) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public int getPointerSize() {
        return this.getPointerSize(0);
    }

    public int getPointerSize(int AS) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public int getPointerSizeInBits() {
        return this.getPointerSizeInBits(0);
    }

    public int getPointerSizeInBits(int AS) {
        return this.getPointerSize(AS) * 8;
    }

    public int getPointerTypeSizeInBits(Type Ty) {
        assert (Ty.isPtrOrPtrVectorTy()) : "This should only be called with a pointer or pointer vector type";
        if (Ty.isPointerTy()) {
            return Unsigned.$ulong2uint((long)this.getTypeSizeInBits(Ty));
        }
        return Unsigned.$ulong2uint((long)this.getTypeSizeInBits(Ty.getScalarType()));
    }

    public int getPointerTypeSize(Type Ty) {
        return this.getPointerTypeSizeInBits(Ty) / 8;
    }

    public long getTypeSizeInBits(Type Ty) {
        assert (Ty.isSized()) : "Cannot getTypeInfo() on a type that is unsized!";
        switch (Ty.getTypeID()) {
            case LabelTyID: {
                return Unsigned.$uint2ulong((int)this.getPointerSizeInBits(0));
            }
            case PointerTyID: {
                return Unsigned.$uint2ulong((int)this.getPointerSizeInBits(Ty.getPointerAddressSpace()));
            }
            case ArrayTyID: {
                ArrayType ATy = (ArrayType)llvm.cast(ArrayType.class, (Object)Ty);
                return ATy.getNumElements() * this.getTypeAllocSizeInBits(ATy.getElementType());
            }
            case StructTyID: {
                return this.getStructLayout((StructType)llvm.cast(StructType.class, (Object)Ty)).getSizeInBits();
            }
            case IntegerTyID: {
                return Unsigned.$uint2ulong((int)Ty.getIntegerBitWidth());
            }
            case HalfTyID: {
                return 16L;
            }
            case FloatTyID: {
                return 32L;
            }
            case DoubleTyID: 
            case X86_MMXTyID: {
                return 64L;
            }
            case PPC_FP128TyID: 
            case FP128TyID: {
                return 128L;
            }
            case X86_FP80TyID: {
                return 80L;
            }
            case VectorTyID: {
                VectorType VTy = (VectorType)llvm.cast(VectorType.class, (Object)Ty);
                return Unsigned.$uint2ullong((int)VTy.getNumElements()) * this.getTypeSizeInBits(VTy.getElementType());
            }
        }
        throw new llvm_unreachable("DataLayout::getTypeSizeInBits(): Unsupported type");
    }

    public long getTypeStoreSize(Type Ty) {
        return (this.getTypeSizeInBits(Ty) + 7L) / 8L;
    }

    public long getTypeStoreSizeInBits(Type Ty) {
        return 8L * this.getTypeStoreSize(Ty);
    }

    public long getTypeAllocSize(Type Ty) {
        return llvm.alignTo((long)this.getTypeStoreSize(Ty), (long)Unsigned.$uint2ulong((int)this.getABITypeAlignment(Ty)));
    }

    public long getTypeAllocSizeInBits(Type Ty) {
        return 8L * this.getTypeAllocSize(Ty);
    }

    public int getABITypeAlignment(Type Ty) {
        return this.getAlignment(Ty, true);
    }

    public int getABIIntegerTypeAlignment(int BitWidth) {
        return this.getAlignmentInfo((byte)105, BitWidth, true, null);
    }

    public int getPrefTypeAlignment(Type Ty) {
        return this.getAlignment(Ty, false);
    }

    public int getPreferredTypeAlignmentShift(Type Ty) {
        int Align = this.getPrefTypeAlignment(Ty);
        assert ((Align & Align - 1) == 0) : "Alignment is not a power of two!";
        return llvm.Log2_32((int)Align);
    }

    public IntegerType getIntPtrType(LLVMContext C) {
        return this.getIntPtrType(C, 0);
    }

    public IntegerType getIntPtrType(LLVMContext C, int AddressSpace) {
        return IntegerType.get(C, this.getPointerSizeInBits(AddressSpace));
    }

    public Type getIntPtrType(Type Ty) {
        assert (Ty.isPtrOrPtrVectorTy()) : "Expected a pointer or pointer vector type.";
        int NumBits = this.getPointerTypeSizeInBits(Ty);
        IntegerType IntTy = IntegerType.get(Ty.getContext(), NumBits);
        VectorType VecTy = (VectorType)llvm.dyn_cast(VectorType.class, (Object)Ty);
        if (VecTy != null) {
            return VectorType.get(IntTy, VecTy.getNumElements());
        }
        return IntTy;
    }

    public Type getSmallestLegalIntType(LLVMContext C) {
        return this.getSmallestLegalIntType(C, 0);
    }

    public Type getSmallestLegalIntType(LLVMContext C, int Width) {
        Iterator iterator2 = this.LegalIntWidths.iterator();
        while (iterator2.hasNext()) {
            byte LegalIntWidth = (Byte)iterator2.next();
            if (!Unsigned.$lesseq_uint((int)Width, (int)LegalIntWidth)) continue;
            return Type.getIntNTy(C, LegalIntWidth);
        }
        return null;
    }

    public Type getLargestLegalIntType(LLVMContext C) {
        int LargestSize = this.getLargestLegalIntTypeSizeInBits();
        return LargestSize == 0 ? null : Type.getIntNTy(C, LargestSize);
    }

    public int getLargestLegalIntTypeSizeInBits() {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public long getIndexedOffsetInType(Type ElemTy, ArrayRef<Value> Indices) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public StructLayout getStructLayout(StructType Ty) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public int getPreferredAlignment(GlobalVariable GV) {
        Type ElemType = GV.getValueType();
        int Alignment = this.getPrefTypeAlignment(ElemType);
        int GVAlignment = GV.getAlignment();
        if (Unsigned.$greatereq_uint((int)GVAlignment, (int)Alignment)) {
            Alignment = GVAlignment;
        } else if (GVAlignment != 0) {
            Alignment = std.max((int)GVAlignment, (int)this.getABITypeAlignment(ElemType));
        }
        if (GV.hasInitializer() && GVAlignment == 0 && Unsigned.$less_uint((int)Alignment, (int)16) && Unsigned.$greater_ulong_ullong((long)this.getTypeSizeInBits(ElemType), (long)128L)) {
            Alignment = 16;
        }
        return Alignment;
    }

    public int getPreferredAlignmentLog(GlobalVariable GV) {
        return llvm.Log2_32((int)this.getPreferredAlignment(GV));
    }

    public String toString() {
        return "BigEndian=" + this.BigEndian + ", StackNaturalAlign=" + this.StackNaturalAlign + ", ManglingMode=" + (Object)((Object)this.ManglingMode) + ", LegalIntWidths=" + this.LegalIntWidths + ", Alignments=" + this.Alignments + ", StringRepresentation=" + this.StringRepresentation + ", Pointers=" + this.Pointers + ", LayoutMap=" + this.LayoutMap;
    }

    private static final class ManglingModeT
    extends Enum<ManglingModeT>
    implements Native.ComparableLower {
        public static final /* enum */ ManglingModeT MM_None = new ManglingModeT(0);
        public static final /* enum */ ManglingModeT MM_ELF = new ManglingModeT(MM_None.getValue() + 1);
        public static final /* enum */ ManglingModeT MM_MachO = new ManglingModeT(MM_ELF.getValue() + 1);
        public static final /* enum */ ManglingModeT MM_WinCOFF = new ManglingModeT(MM_MachO.getValue() + 1);
        public static final /* enum */ ManglingModeT MM_WinCOFFX86 = new ManglingModeT(MM_WinCOFF.getValue() + 1);
        public static final /* enum */ ManglingModeT MM_Mips = new ManglingModeT(MM_WinCOFFX86.getValue() + 1);
        private final int value;
        private static final /* synthetic */ ManglingModeT[] $VALUES;

        public static ManglingModeT[] values() {
            return (ManglingModeT[])$VALUES.clone();
        }

        public static ManglingModeT valueOf(String name) {
            return Enum.valueOf(ManglingModeT.class, name);
        }

        public static ManglingModeT valueOf(int val) {
            ManglingModeT out;
            ManglingModeT manglingModeT = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private ManglingModeT(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((ManglingModeT)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((ManglingModeT)((Object)obj)).value);
        }

        static {
            $VALUES = new ManglingModeT[]{MM_None, MM_ELF, MM_MachO, MM_WinCOFF, MM_WinCOFFX86, MM_Mips};
        }

        private static final class Values {
            private static final ManglingModeT[] VALUES;
            private static final ManglingModeT[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (ManglingModeT kind : ManglingModeT.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new ManglingModeT[min < 0 ? 1 - min : 0];
                VALUES = new ManglingModeT[max >= 0 ? 1 + max : 0];
                for (ManglingModeT kind : ManglingModeT.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((ManglingModeT)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((ManglingModeT)kind).value] = kind;
                }
            }
        }
    }
}

