/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.diff;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.netbeans.modules.git.remote.GitStatusNode;
import org.netbeans.modules.git.remote.ui.diff.DiffFileViewComponent;
import org.netbeans.modules.git.remote.ui.diff.DiffNode;
import org.netbeans.modules.git.remote.ui.diff.MultiDiffPanelController;
import org.netbeans.modules.remotefs.versioning.util.common.FileTreeView;
import org.netbeans.modules.remotefs.versioning.util.status.VCSStatusNode;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.swing.outline.RenderDataProvider;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;

class DiffFileTreeImpl
extends FileTreeView<DiffNode>
implements DiffFileViewComponent<DiffNode> {
    private final MultiDiffPanelController master;

    public DiffFileTreeImpl(MultiDiffPanelController master) {
        this.master = master;
        this.setupColumns();
    }

    private void setupColumns() {
        Node.Property[] properties = new Node.Property[]{new ColumnDescriptor<String>("gitstatus", String.class, GitStatusNode.GitStatusProperty.DISPLAY_NAME, GitStatusNode.GitStatusProperty.DESCRIPTION), new ColumnDescriptor<String>("path", String.class, VCSStatusNode.PathProperty.DISPLAY_NAME, VCSStatusNode.PathProperty.DESCRIPTION)};
        this.view.setProperties(properties);
        this.view.getOutline().setRenderDataProvider(this.createRenderProvider());
    }

    private RenderDataProvider createRenderProvider() {
        return new FileTreeView.AbstractRenderDataProvider(){

            protected String annotateName(DiffNode node, String originalLabel) {
                if (node.isExcluded()) {
                    originalLabel = "<s>" + (originalLabel == null ? node.getName() : originalLabel) + "</s>";
                }
                return originalLabel;
            }
        };
    }

    protected void nodeSelected(DiffNode node) {
        if (node == null) {
            this.master.filesSelected(new VCSFileProxy[0]);
        } else {
            this.master.filesSelected(node.getFile());
        }
    }

    protected JPopupMenu getPopup() {
        List nodes = this.getSelectedNodes();
        VCSFileProxy[] files = this.toFiles(nodes);
        return this.master.getPopupFor(nodes.toArray(new Node[nodes.size()]), files);
    }

    protected void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int width = DiffFileTreeImpl.this.view.getWidth();
                DiffFileTreeImpl.this.view.getOutline().getColumnModel().getColumn(0).setPreferredWidth(width * 40 / 100);
                DiffFileTreeImpl.this.view.getOutline().getColumnModel().getColumn(1).setPreferredWidth(width * 20 / 100);
                DiffFileTreeImpl.this.view.getOutline().getColumnModel().getColumn(2).setPreferredWidth(width * 40 / 100);
            }
        });
    }

    @Override
    public VCSFileProxy[] getSelectedFiles() {
        return this.toFiles(this.getSelectedNodes());
    }

    private VCSFileProxy[] toFiles(List<Node> nodes) {
        ArrayList<VCSFileProxy> files = new ArrayList<VCSFileProxy>(nodes.size());
        for (Node n : nodes) {
            VCSFileProxy f = (VCSFileProxy)n.getLookup().lookup(VCSFileProxy.class);
            if (f == null) continue;
            files.add(f);
        }
        return files.toArray(new VCSFileProxy[files.size()]);
    }

    private static class ColumnDescriptor<T>
    extends PropertySupport.ReadOnly<T> {
        public ColumnDescriptor(String name, Class<T> type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public T getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }
}

