/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.classpath.DependencyProjectsProvider;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.LateBoundPrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.apisupport.MavenWhiteListQueryImpl;
import org.netbeans.modules.maven.apisupport.NetBeansRunParamsIDEChecker;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class CoSApplicationLateBoundChecker
implements LateBoundPrerequisitesChecker {
    public boolean checkRunConfig(RunConfig config, ExecutionContext con) {
        String prop;
        if (config.getProject() == null) {
            return true;
        }
        if (!RunUtils.isCompileOnSaveEnabled((RunConfig)config)) {
            return true;
        }
        if ("build".equals(config.getActionName()) || "clean".equals(config.getActionName()) || "rebuild".equals(config.getActionName())) {
            return true;
        }
        DependencyProjectsProvider dpp = (DependencyProjectsProvider)config.getProject().getLookup().lookup(DependencyProjectsProvider.class);
        String params = (String)config.getProperties().get("netbeans.run.params.debug");
        String oldparams = (String)config.getProperties().get("netbeans.run.params.ide");
        StringBuilder sb = new StringBuilder(params != null ? params : (oldparams != null ? oldparams : ""));
        ArrayList<DependencyProjectsProvider.Pair> nonModules = new ArrayList<DependencyProjectsProvider.Pair>();
        HashMap<String, ArrayList<DependencyProjectsProvider.Pair>> extraCP = new HashMap<String, ArrayList<DependencyProjectsProvider.Pair>>();
        HashMap<String, DependencyProjectsProvider.Pair> modules = new HashMap<String, DependencyProjectsProvider.Pair>();
        Set all = dpp.getDependencyProjects();
        for (DependencyProjectsProvider.Pair pair : all) {
            if (!pair.isIncludedAtRuntime() || !RunUtils.isCompileOnSaveEnabled((Project)pair.getProject()) || !OpenProjects.getDefault().isProjectOpen(pair.getProject())) continue;
            NbModuleProvider nbm = (NbModuleProvider)pair.getProject().getLookup().lookup(NbModuleProvider.class);
            if (nbm != null) {
                Artifact artifact = pair.getArtifact();
                modules.put(artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + ":" + artifact.getBaseVersion(), pair);
                continue;
            }
            nonModules.add(pair);
        }
        if (!nonModules.isEmpty()) {
            for (DependencyProjectsProvider.Pair pair : nonModules) {
                ArrayList trail = new ArrayList(pair.getArtifact().getDependencyTrail());
                Collections.reverse(trail);
                trail.remove(0);
                Iterator iterator = trail.iterator();
                while (iterator.hasNext()) {
                    String s = (String)iterator.next();
                    if (!modules.containsKey(s)) continue;
                    ArrayList<DependencyProjectsProvider.Pair> cp = (ArrayList<DependencyProjectsProvider.Pair>)extraCP.get(s);
                    if (cp == null) {
                        cp = new ArrayList<DependencyProjectsProvider.Pair>();
                        extraCP.put(s, cp);
                    }
                    cp.add(pair);
                }
            }
        }
        String branding = PluginPropertyUtils.getPluginProperty((Project)config.getProject(), (String)"org.codehaus.mojo", (String)"nbm-maven-plugin", (String)"brandingToken", (String)"cluster-app", (String)"netbeans.branding.token");
        assert (config.getExecutionDirectory() != null) : "RunConfig for " + config.getActionName() + " is missing executionDirectory";
        File currentDir = Utilities.isWindows() && config.getExecutionDirectory() != null ? new File(new File(config.getExecutionDirectory(), "target"), branding) : null;
        for (Map.Entry entry : modules.entrySet()) {
            NbModuleProvider nbm = (NbModuleProvider)((DependencyProjectsProvider.Pair)entry.getValue()).getProject().getLookup().lookup(NbModuleProvider.class);
            if (nbm == null) continue;
            String cnb = nbm.getCodeNameBase();
            if (sb.length() > 0) {
                sb.append(" ");
            }
            String v = this.projectToOutputDir(((DependencyProjectsProvider.Pair)entry.getValue()).getProject(), currentDir);
            boolean space = v.contains(" ");
            sb.append("-J-Dnetbeans.patches.").append(cnb).append("=");
            if (space) {
                sb.append("\"");
            }
            sb.append(v);
            if (space) {
                sb.append("\"");
            }
            List ex = (List)extraCP.get(entry.getKey());
            boolean useOsgiDeps = MavenWhiteListQueryImpl.isUseOSGiDependencies(((DependencyProjectsProvider.Pair)entry.getValue()).getProject());
            if (ex == null || ex.isEmpty()) continue;
            for (DependencyProjectsProvider.Pair exPair : ex) {
                NbMavenProject nbprj = (NbMavenProject)exPair.getProject().getLookup().lookup(NbMavenProject.class);
                if (nbprj != null && "bundle".equals(nbprj.getPackagingType()) && useOsgiDeps) continue;
                sb.append(Utilities.isWindows() ? ";" : ":").append(this.projectToOutputDir(exPair.getProject(), currentDir));
            }
        }
        String string = prop = NetBeansRunParamsIDEChecker.usingNbmPlugin311(config.getMavenProject()) ? "netbeans.run.params.debug" : "netbeans.run.params.ide";
        if (sb.length() > 0) {
            config.setProperty(prop, sb.toString());
        }
        return true;
    }

    private String projectToOutputDir(Project p, File basedir) {
        String toRet;
        File f = new File(new File(FileUtil.toFile((FileObject)p.getProjectDirectory()), "target"), "classes");
        String string = toRet = basedir != null ? FileUtilities.relativizeFile((File)basedir, (File)f) : null;
        if (toRet == null) {
            toRet = f.getAbsolutePath();
        }
        return toRet;
    }
}

