/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import org.netbeans.lib.terminalemulator.ActiveRegion;
import org.netbeans.lib.terminalemulator.Coord;
import org.netbeans.lib.terminalemulator.RegionException;

public class RegionManager {
    private ActiveRegion root = new ActiveRegion(null, new Coord(), false);
    private ActiveRegion parent = null;
    private ActiveRegion region = this.root;

    public void reset() {
        this.root = new ActiveRegion(null, new Coord(), false);
        this.parent = null;
        this.region = this.root;
    }

    public ActiveRegion root() {
        return this.root;
    }

    public ActiveRegion beginRegion(Coord begin) throws RegionException {
        if (this.region != null) {
            ActiveRegion child = new ActiveRegion(this.region, begin, true);
            this.region.addChild(child);
            this.parent = this.region;
            this.region = child;
        } else {
            this.region = new ActiveRegion(this.parent, begin, false);
            this.parent.addChild(this.region);
        }
        return this.region;
    }

    public ActiveRegion endRegion(Coord end) throws RegionException {
        if (this.region == null) {
            throw new RegionException("endRegion(): ", "no current active region");
        }
        if (this.region == this.root) {
            throw new RegionException("endRegion(): ", "cannot end root region");
        }
        this.region.setEnd(end);
        ActiveRegion endedRegion = this.region;
        if (this.region.nested) {
            this.region = this.parent;
            this.parent = this.region.parent;
        } else {
            this.region = null;
        }
        return endedRegion;
    }

    public void cancelRegion() throws RegionException {
        if (this.region == null) {
            throw new RegionException("cancelRegion(): ", "no current active region");
        }
        if (this.region == this.root) {
            throw new RegionException("cancelRegion(): ", "cannot cancel root region");
        }
        this.parent.removeChild(this.region);
        this.region = null;
    }

    public ActiveRegion findRegion(Coord acoord) {
        return this.root.contains(acoord);
    }

    void relocate(int from, int to) {
        int delta = to - from;
        this.root.relocate(delta);
    }

    void cull(int origin) {
        this.root.cull(origin);
    }
}

