/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.completion;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.web.beans.completion.BeansCompletionItem;
import org.netbeans.modules.web.beans.completion.BeansCompletor;
import org.netbeans.modules.web.beans.completion.BeansXmlConstants;
import org.netbeans.modules.web.beans.completion.CompletionContext;
import org.netbeans.modules.web.beans.completion.ContextUtilities;
import org.netbeans.modules.web.beans.completion.DocumentContext;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;

public final class BeansCompletionManager {
    private static Map<String, BeansCompletor> completors = new HashMap<String, BeansCompletor>();
    private static final BeansCompletionManager INSTANCE = new BeansCompletionManager();

    private BeansCompletionManager() {
        this.setupCompletors();
    }

    private void setupCompletors() {
        BeansCompletor.JavaClassesCompletor javaClassCompletor = new BeansCompletor.JavaClassesCompletor(BeansCompletor.TAG.CLASS);
        this.registerCompletor(BeansXmlConstants.CLASS, null, javaClassCompletor);
        BeansCompletor.JavaClassesCompletor stereotypeClassCompletor = new BeansCompletor.JavaClassesCompletor(BeansCompletor.TAG.STEREOTYPE);
        this.registerCompletor(BeansXmlConstants.STEREOTYPE, null, stereotypeClassCompletor);
    }

    public static BeansCompletionManager getDefault() {
        return INSTANCE;
    }

    public int completeAttributeValues(CompletionContext context, List<BeansCompletionItem> valueItems) {
        TokenItem attrib;
        String attribName;
        int anchorOffset = -1;
        if (context.getTag() == null) {
            return anchorOffset;
        }
        String tagName = context.getTag().getNodeName();
        BeansCompletor completor = this.locateCompletor(tagName, attribName = (attrib = ContextUtilities.getAttributeToken(context.getCurrentToken())) != null ? attrib.getImage() : null);
        if (completor != null) {
            valueItems.addAll(completor.doCompletion(context));
            if (completor.getAnchorOffset() != -1) {
                anchorOffset = completor.getAnchorOffset();
            }
        }
        return anchorOffset;
    }

    public int completeValues(CompletionContext context, List<BeansCompletionItem> valueItems) {
        int anchorOffset = -1;
        DocumentContext docContext = context.getDocumentContext();
        SyntaxElement curElem = docContext.getCurrentElement();
        SyntaxElement prevElem = docContext.getCurrentElement().getPrevious();
        String tagName = curElem instanceof StartTag ? ((StartTag)curElem).getTagName() : (prevElem instanceof StartTag ? ((StartTag)prevElem).getTagName() : null);
        BeansCompletor completor = this.locateCompletor(tagName, null);
        if (completor != null) {
            valueItems.addAll(completor.doCompletion(context));
            if (completor.getAnchorOffset() != -1) {
                anchorOffset = completor.getAnchorOffset();
            }
        }
        return anchorOffset;
    }

    public int completeAttributes(CompletionContext context, List<BeansCompletionItem> attributeItems) {
        return -1;
    }

    public int completeElements(CompletionContext context, List<BeansCompletionItem> elementItems) {
        return -1;
    }

    private void registerCompletor(String tagName, String attribName, BeansCompletor completor) {
        completors.put(BeansCompletionManager.createRegisteredName(tagName, attribName), completor);
    }

    private static String createRegisteredName(String nodeName, String attributeName) {
        StringBuilder builder = new StringBuilder();
        if (nodeName != null && nodeName.trim().length() > 0) {
            builder.append("/nodeName=");
            builder.append(nodeName);
        } else {
            builder.append("/nodeName=");
            builder.append("*");
        }
        if (attributeName != null && attributeName.trim().length() > 0) {
            builder.append("/attribute=");
            builder.append(attributeName);
        }
        return builder.toString();
    }

    private BeansCompletor locateCompletor(String nodeName, String attributeName) {
        String key = BeansCompletionManager.createRegisteredName(nodeName, attributeName);
        if (completors.containsKey(key)) {
            return completors.get(key);
        }
        key = BeansCompletionManager.createRegisteredName("*", attributeName);
        if (completors.containsKey(key)) {
            return completors.get(key);
        }
        return null;
    }
}

