/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.osgidemo;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.osgidemo.SampleAppWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class SampleAppWizardIterator
implements WizardDescriptor.AsynchronousInstantiatingIterator {
    private static final long serialVersionUID = 1L;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;
    private final boolean netbinox;

    public SampleAppWizardIterator(boolean netbinox) {
        this.netbinox = netbinox;
    }

    public static SampleAppWizardIterator createIterator(Map<?, ?> params) {
        return new SampleAppWizardIterator(params.containsKey("netbinox"));
    }

    private WizardDescriptor.Panel[] createPanels() {
        ArrayList<SampleAppWizardPanel> arr = new ArrayList<SampleAppWizardPanel>();
        arr.add(new SampleAppWizardPanel());
        return arr.toArray(new WizardDescriptor.Panel[0]);
    }

    private String[] createSteps() {
        ArrayList<String> arr = new ArrayList<String>();
        arr.add(NbBundle.getMessage(SampleAppWizardIterator.class, (String)"LBL_CreateProjectStep"));
        return arr.toArray(new String[0]);
    }

    public Set instantiate() throws IOException {
        LinkedHashSet<FileObject> resultSet = new LinkedHashSet<FileObject>();
        File dirF = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("projdir")));
        dirF.mkdirs();
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        FileObject dir = FileUtil.toFileObject((File)dirF);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.netbinox) {
            params.put("netbinox", "true");
        }
        SampleAppWizardIterator.unZipFile(null, template.getInputStream(), params, dir);
        resultSet.add(dir);
        Enumeration e = dir.getFolders(true);
        while (e.hasMoreElements()) {
            FileObject subfolder = (FileObject)e.nextElement();
            if (!ProjectManager.getDefault().isProject(subfolder)) continue;
            resultSet.add(subfolder);
        }
        File parent = dirF.getParentFile();
        if (parent != null && parent.exists()) {
            ProjectChooser.setProjectsFolder((File)parent);
        }
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        if (this.netbinox) {
            wiz.putProperty("name", (Object)NbBundle.getMessage(SampleAppWizardIterator.class, (String)"CTL_NetbinoxProjectName"));
        } else {
            wiz.putProperty("name", (Object)NbBundle.getMessage(SampleAppWizardIterator.class, (String)"CTL_FelixProjectName"));
        }
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage(SampleAppWizardIterator.class, (String)"SampleAppWizardIterator.name.format", (Object[])new Object[]{new Integer(this.index + 1), new Integer(this.panels.length)});
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unZipFile(FileObject template, InputStream source, Map<String, Object> params, FileObject projectRoot) throws IOException {
        try {
            ZipEntry entry;
            ZipInputStream str = new ZipInputStream(source);
            while ((entry = str.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    FileUtil.createFolder((FileObject)projectRoot, (String)entry.getName());
                    continue;
                }
                FileObject fo = FileUtil.createData((FileObject)projectRoot, (String)entry.getName());
                String mime = fo.getMIMEType();
                OutputStream out = fo.getOutputStream();
                try {
                    if (mime.startsWith("text/")) {
                        int r;
                        StringBuilder sb = new StringBuilder();
                        while ((r = str.read()) != -1) {
                            if (r == 36) {
                                sb.append("${r\"$\"}");
                                continue;
                            }
                            sb.append((char)r);
                        }
                        ScriptEngineManager m = new ScriptEngineManager();
                        ScriptEngine engine = m.getEngineByName("FreeMarker");
                        assert (engine != null) : "FreeMarker engine needs to be present";
                        engine.getBindings(100).putAll((Map<? extends String, ? extends Object>)params);
                        if (template != null) {
                            engine.getContext().setAttribute("org.openide.filesystems.FileObject", template, 100);
                        }
                        OutputStreamWriter w = new OutputStreamWriter(out, "UTF-8");
                        engine.getContext().setWriter(w);
                        try {
                            engine.eval(sb.toString());
                        }
                        catch (ScriptException ex) {
                            throw new IOException(sb.toString(), ex);
                        }
                        ((Writer)w).flush();
                        continue;
                    }
                    FileUtil.copy((InputStream)str, (OutputStream)out);
                }
                finally {
                    out.close();
                }
            }
        }
        finally {
            source.close();
        }
    }
}

