/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectRegistry;
import org.netbeans.modules.cnd.spi.project.NativeProjectLayerDescriptorProvider;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public final class MakeProjectLayerDescriptorProvider
implements NativeProjectLayerDescriptorProvider {
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.cnd.makeproject");
    private static final ConcurrentHashMap<NativeProject, List<URI>> cache = new ConcurrentHashMap();
    private static final PropertyChangeListener listener = new ProjectsListener();

    public List<URI> getLayerDescriptors(NativeProject nativeproject) {
        if (nativeproject != null) {
            FileObject projectDirectory;
            List<URI> prevResult;
            Project project;
            Lookup.Provider lookupProvider;
            List<URI> result = cache.get(nativeproject);
            if (result == null && (lookupProvider = nativeproject.getProject()) != null && (project = (Project)lookupProvider.getLookup().lookup(Project.class)) != null && (prevResult = cache.putIfAbsent(nativeproject, result = MakeProjectLayerDescriptorProvider.getCacheLocations(projectDirectory = project.getProjectDirectory()))) != null) {
                result = prevResult;
            }
            if (result != null && !result.isEmpty()) {
                return result;
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<URI> getCacheLocations(FileObject projectDirectory) {
        String[] propertyPaths = new String[]{"nbproject/project.properties", "nbproject/private/private.properties"};
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (int i = 0; i < propertyPaths.length; ++i) {
            FileObject propsFO = projectDirectory.getFileObject(propertyPaths[i]);
            if (propsFO == null || !propsFO.isValid()) continue;
            Properties props = new Properties();
            InputStream is = null;
            try {
                is = propsFO.getInputStream();
                props.load(is);
                for (String key : props.stringPropertyNames()) {
                    if (!MakeProjectLayerDescriptorProvider.isCacheLocationKey(key)) continue;
                    map.put(key, props.getProperty(key));
                }
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                continue;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.INFO, "Error closing " + propsFO.getPath(), ex);
                    }
                }
            }
        }
        if (!map.isEmpty()) {
            ArrayList<URI> res = new ArrayList<URI>();
            map.values().forEach(uriString -> {
                try {
                    String fragment;
                    String path;
                    URI uri = new URI((String)uriString);
                    String scheme = uri.getScheme();
                    boolean changed = false;
                    if (scheme == null) {
                        scheme = "file";
                        changed = true;
                    }
                    if (!CndPathUtilities.isPathAbsolute((CharSequence)(path = uri.getPath()))) {
                        FileObject fo = FileUtil.createFolder((FileObject)projectDirectory, (String)path);
                        path = fo.getPath();
                        changed = true;
                    }
                    if ((fragment = uri.getFragment()) == null && !res.isEmpty()) {
                        fragment = "r/o";
                        changed = true;
                    }
                    if (changed) {
                        uri = new URI(scheme, uri.getUserInfo(), uri.getHost(), uri.getPort(), path, uri.getQuery(), fragment);
                    }
                    res.add(uri);
                }
                catch (URISyntaxException ex) {
                    ex.printStackTrace(System.err);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            });
            return res;
        }
        return Collections.emptyList();
    }

    private static boolean isCacheLocationKey(String key) {
        String prefix = "cache.location";
        if (key.equals(prefix)) {
            return true;
        }
        if (key.startsWith(prefix) && key.length() > prefix.length() + 1 && key.charAt(prefix.length()) == '.') {
            for (int i = prefix.length() + 1; i < key.length(); ++i) {
                char c = key.charAt(i);
                if (Character.isDigit(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static {
        NativeProjectRegistry.getDefault().addPropertyChangeListener(listener);
    }

    private static final class ProjectsListener
    implements PropertyChangeListener {
        private ProjectsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("closeNativeProject".equals(evt.getPropertyName()) || "deleteNativeProject".equals(evt.getPropertyName())) {
                cache.remove((NativeProject)evt.getSource());
            }
        }
    }
}

