/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.AbstractElement;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.SchemaGenerator;
import org.netbeans.modules.xml.axi.SchemaGeneratorFactory;
import org.netbeans.modules.xml.axi.impl.DefaultSchemaGenerator;
import org.netbeans.modules.xml.axi.impl.GardenOfEden;
import org.netbeans.modules.xml.axi.impl.MixedPattern;
import org.netbeans.modules.xml.axi.impl.RussianDoll;
import org.netbeans.modules.xml.axi.impl.SalamiSlice;
import org.netbeans.modules.xml.axi.impl.SchemaGeneratorUtil;
import org.netbeans.modules.xml.axi.impl.VenetianBlind;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.xam.Model;

public class SchemaGeneratorFactoryImpl
extends SchemaGeneratorFactory {
    @Override
    public SchemaGenerator.Pattern inferDesignPattern(AXIModel am) {
        return SchemaGeneratorUtil.inferDesignPattern(am);
    }

    @Override
    public void updateSchema(SchemaModel sm, SchemaGenerator.Pattern pattern) throws BadLocationException, IOException {
        DefaultSchemaGenerator sg = null;
        if (pattern == SchemaGenerator.Pattern.GARDEN_OF_EDEN) {
            sg = new GardenOfEden(SchemaGenerator.Mode.UPDATE);
        } else if (pattern == SchemaGenerator.Pattern.VENITIAN_BLIND) {
            sg = new VenetianBlind(SchemaGenerator.Mode.UPDATE);
        } else if (pattern == SchemaGenerator.Pattern.SALAMI_SLICE) {
            sg = new SalamiSlice(SchemaGenerator.Mode.UPDATE);
        } else if (pattern == SchemaGenerator.Pattern.RUSSIAN_DOLL) {
            sg = new RussianDoll(SchemaGenerator.Mode.UPDATE);
        } else if (pattern == SchemaGenerator.Pattern.MIXED) {
            sg = new MixedPattern(SchemaGenerator.Mode.UPDATE);
        }
        if (sg != null) {
            ((SchemaGenerator)sg).updateSchema(sm);
        }
    }

    @Override
    public List<Element> findMasterGlobalElements(AXIModel am) {
        return SchemaGeneratorUtil.findMasterGlobalElements(am);
    }

    @Override
    public SchemaGeneratorFactory.TransformHint canTransformSchema(SchemaModel sm, SchemaGenerator.Pattern currentPattern, SchemaGenerator.Pattern targetPattern) {
        return this.canTransformSchema(sm, currentPattern, targetPattern, this.findMasterGlobalElements(AXIModelFactory.getDefault().getModel(sm)));
    }

    @Override
    public SchemaGeneratorFactory.TransformHint canTransformSchema(SchemaModel sm, SchemaGenerator.Pattern currentPattern, SchemaGenerator.Pattern targetPattern, List<Element> ges) {
        if (sm == null) {
            return SchemaGeneratorFactory.TransformHint.INVALID_SCHEMA;
        }
        AXIModel am = AXIModelFactory.getDefault().getModel(sm);
        if (am == null || am.getState() != Model.State.VALID || am.getState() == Model.State.NOT_WELL_FORMED) {
            return SchemaGeneratorFactory.TransformHint.INVALID_SCHEMA;
        }
        if (currentPattern == targetPattern) {
            return SchemaGeneratorFactory.TransformHint.SAME_DESIGN_PATTERN;
        }
        if (currentPattern != null && targetPattern != null) {
            boolean noChildAttributes;
            if (ges.size() == 0) {
                return SchemaGeneratorFactory.TransformHint.NO_GLOBAL_ELEMENTS;
            }
            if (ges.size() > 1 && (targetPattern == SchemaGenerator.Pattern.RUSSIAN_DOLL || targetPattern == SchemaGenerator.Pattern.VENITIAN_BLIND)) {
                return SchemaGeneratorFactory.TransformHint.CANNOT_REMOVE_GLOBAL_ELEMENTS;
            }
            int childElementEmptyCount = 0;
            int childAttributesEmptyCount = 0;
            boolean grandChildrenAvailable = false;
            int size = am.getRoot().getElements().size();
            block0: for (Element ge : am.getRoot().getElements()) {
                ArrayList<AbstractElement> les = new ArrayList<AbstractElement>(ge.getChildElements());
                this.filterOtherModelComponents(les, am);
                ArrayList<AbstractAttribute> attrs = new ArrayList<AbstractAttribute>(ge.getAttributes());
                this.filterOtherModelComponents(attrs, am);
                if (les.size() == 0) {
                    ++childElementEmptyCount;
                }
                if (attrs.size() == 0) {
                    ++childAttributesEmptyCount;
                }
                if (grandChildrenAvailable) continue;
                for (AbstractElement le : les) {
                    ArrayList<AbstractElement> gles = new ArrayList<AbstractElement>(le.getChildElements());
                    this.filterOtherModelComponents(gles, am);
                    ArrayList<AbstractAttribute> gattrs = new ArrayList<AbstractAttribute>(le.getAttributes());
                    this.filterOtherModelComponents(gattrs, am);
                    if (gles.size() <= 0 && gattrs.size() <= 0) continue;
                    grandChildrenAvailable = true;
                    continue block0;
                }
            }
            boolean noChildElements = childElementEmptyCount > 0 && childElementEmptyCount == size;
            boolean bl = noChildAttributes = childAttributesEmptyCount > 0 && childAttributesEmptyCount == size;
            if (noChildElements && targetPattern == SchemaGenerator.Pattern.SALAMI_SLICE) {
                return SchemaGeneratorFactory.TransformHint.GLOBAL_ELEMENTS_HAVE_NO_CHILD_ELEMENTS;
            }
            if (noChildAttributes && noChildElements && (targetPattern == SchemaGenerator.Pattern.GARDEN_OF_EDEN || targetPattern == SchemaGenerator.Pattern.RUSSIAN_DOLL)) {
                return SchemaGeneratorFactory.TransformHint.GLOBAL_ELEMENTS_HAVE_NO_CHILD_ELEMENTS_AND_ATTRIBUTES;
            }
            if (!grandChildrenAvailable && targetPattern == SchemaGenerator.Pattern.VENITIAN_BLIND) {
                return SchemaGeneratorFactory.TransformHint.GLOBAL_ELEMENTS_HAVE_NO_GRAND_CHILDREN;
            }
            if (currentPattern == SchemaGenerator.Pattern.SALAMI_SLICE || currentPattern == SchemaGenerator.Pattern.RUSSIAN_DOLL) {
                return SchemaGeneratorFactory.TransformHint.WILL_REMOVE_GLOBAL_ELEMENTS;
            }
            return SchemaGeneratorFactory.TransformHint.WILL_REMOVE_GLOBAL_ELEMENTS_AND_TYPES;
        }
        return SchemaGeneratorFactory.TransformHint.OK;
    }

    private void filterOtherModelComponents(List cs, AXIModel am) {
        int i;
        ArrayList<Integer> removeList = new ArrayList<Integer>();
        for (i = 0; i < cs.size(); ++i) {
            AXIComponent e = (AXIComponent)cs.get(i);
            if (SchemaGeneratorUtil.fromSameSchemaModel(e.getPeer(), am.getSchemaModel())) continue;
            removeList.add(new Integer(i));
        }
        for (i = removeList.size() - 1; i >= 0; --i) {
            cs.remove((Integer)removeList.get(i));
        }
    }

    @Override
    public void transformSchema(SchemaModel sm, SchemaGenerator.Pattern targetPattern) throws IOException {
        DefaultSchemaGenerator sg = null;
        if (targetPattern == SchemaGenerator.Pattern.GARDEN_OF_EDEN) {
            sg = new GardenOfEden(SchemaGenerator.Mode.TRANSFORM);
        } else if (targetPattern == SchemaGenerator.Pattern.VENITIAN_BLIND) {
            sg = new VenetianBlind(SchemaGenerator.Mode.TRANSFORM);
        } else if (targetPattern == SchemaGenerator.Pattern.SALAMI_SLICE) {
            sg = new SalamiSlice(SchemaGenerator.Mode.TRANSFORM);
        } else if (targetPattern == SchemaGenerator.Pattern.RUSSIAN_DOLL) {
            sg = new RussianDoll(SchemaGenerator.Mode.TRANSFORM);
        } else if (targetPattern == SchemaGenerator.Pattern.MIXED) {
            sg = new MixedPattern(SchemaGenerator.Mode.TRANSFORM);
        }
        if (sg != null) {
            ((SchemaGenerator)sg).transformSchema(sm);
        }
    }
}

