/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api.archetype;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.embedder.exec.ProgressTransferListener;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Archetype {
    private static final Logger LOG = Logger.getLogger(Archetype.class.getName());
    private String artifactId;
    private String groupId;
    private String version;
    private String name;
    private String description;
    private String repository;
    public final boolean deletable;
    private Artifact artifact;
    private Artifact pomArtifact;

    public Archetype(boolean deletable) {
        this.deletable = deletable;
        this.artifactId = "";
        this.groupId = "";
        this.version = "";
    }

    public Archetype() {
        this(true);
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @NonNull
    public String getName() {
        if ("${project.artifactId}".equals(this.name)) {
            return this.artifactId;
        }
        if (this.name == null || this.name.trim().length() == 0) {
            return this.artifactId;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setRepository(String repo) {
        this.repository = repo;
    }

    public String getRepository() {
        return this.repository;
    }

    public synchronized Artifact getArtifact() {
        if (this.artifact == null) {
            MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
            this.artifact = online.createArtifact(this.getGroupId(), this.getArtifactId(), this.getVersion(), "jar", "maven-archetype");
            this.artifact.setArtifactHandler(new ArtifactHandler(){

                public String getExtension() {
                    return "jar";
                }

                public String getDirectory() {
                    return null;
                }

                public String getClassifier() {
                    return null;
                }

                public String getPackaging() {
                    return "maven-archetype";
                }

                public boolean isIncludesDependencies() {
                    return false;
                }

                public String getLanguage() {
                    return "java";
                }

                public boolean isAddedToClasspath() {
                    return false;
                }
            });
        }
        return this.artifact;
    }

    public synchronized Artifact getPomArtifact() {
        if (this.pomArtifact == null) {
            MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
            this.pomArtifact = online.createArtifact(this.getGroupId(), this.getArtifactId(), this.getVersion(), "pom", "pom");
        }
        return this.pomArtifact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveArtifacts(AggregateProgressHandle hndl) throws ArtifactResolutionException, ArtifactNotFoundException {
        List<ArtifactRepository> repos;
        MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
        if (this.getRepository() == null) {
            repos = Collections.singletonList(online.createRemoteRepository("http://repo.maven.apache.org/maven2", "central"));
        } else {
            repos = Collections.singletonList(online.createRemoteRepository(this.getRepository(), "custom-repo"));
            for (RepositoryInfo info : RepositoryPreferences.getInstance().getRepositoryInfos()) {
                if (!this.getRepository().equals(info.getRepositoryUrl())) continue;
                repos = Collections.singletonList(online.createRemoteRepository(this.getRepository(), info.getId()));
                break;
            }
        }
        try {
            ProgressTransferListener.setAggregateHandle((AggregateProgressHandle)hndl);
            hndl.start();
            online.resolve(this.getPomArtifact(), repos, online.getLocalRepository());
            online.resolve(this.getArtifact(), repos, online.getLocalRepository());
        }
        catch (ThreadDeath threadDeath) {
        }
        catch (IllegalStateException ise) {
            if (!(ise.getCause() instanceof ThreadDeath)) {
                throw ise;
            }
        }
        finally {
            ProgressTransferListener.clearAggregateHandle();
            hndl.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> loadRequiredProperties() {
        HashMap<String, String> map;
        block22: {
            map = new HashMap<String, String>();
            File fil = this.getArtifact().getFile();
            assert (fil != null) : "requires a resolved artifact";
            JarFile jf = null;
            try {
                jf = new JarFile(fil);
                JarEntry entry = jf.getJarEntry("META-INF/maven/archetype-metadata.xml");
                if (entry == null) {
                    entry = jf.getJarEntry("META-INF/maven/archetype.xml");
                }
                if (entry == null) break block22;
                try (InputStream in = jf.getInputStream(entry);){
                    Document doc = XMLUtil.parse((InputSource)new InputSource(in), (boolean)false, (boolean)false, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
                    NodeList nl = doc.getElementsByTagName("requiredProperty");
                    for (int i = 0; i < nl.getLength(); ++i) {
                        Element rP = (Element)nl.item(i);
                        Element dV = XMLUtil.findElement((Element)rP, (String)"defaultValue", null);
                        map.put(rP.getAttribute("key"), dV != null ? XMLUtil.findText((Node)dV) : null);
                    }
                }
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, ex.getMessage(), ex);
            }
            catch (SAXException ex) {
                LOG.log(Level.INFO, ex.getMessage(), ex);
            }
            finally {
                if (jf != null) {
                    try {
                        jf.close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        return map;
    }

    public int hashCode() {
        return this.getGroupId().trim().hashCode() + 13 * this.getArtifactId().trim().hashCode() + 23 * this.getVersion().trim().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Archetype)) {
            return false;
        }
        Archetype ar1 = (Archetype)obj;
        boolean gr = ar1.getGroupId().trim().equals(this.getGroupId().trim());
        if (!gr) {
            return false;
        }
        boolean ar = ar1.getArtifactId().trim().equals(this.getArtifactId().trim());
        if (!ar) {
            return false;
        }
        boolean ver = ar1.getVersion().trim().equals(this.getVersion().trim());
        return ver;
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }
}

