/*
 * Ostatnia aktualizacja:
 *
 * - $Id: hashtable.h,v 1.3 2002/12/14 19:36:11 mati Exp $
 *
 */

#include <stddef.h>

#ifdef XML_UNICODE

#ifdef XML_UNICODE_WCHAR_T
typedef const wchar_t *KEY;
#else /* not XML_UNICODE_WCHAR_T */
typedef const unsigned short *KEY;
#endif /* not XML_UNICODE_WCHAR_T */

#else /* not XML_UNICODE */

typedef const char *KEY;

#endif /* not XML_UNICODE */

typedef struct {
  KEY name;
} NAMED;

typedef struct {
  NAMED **v;
  size_t size;
  size_t used;
  size_t usedLim;
} HASH_TABLE;

NAMED *lookup(HASH_TABLE *table, KEY name, size_t createSize);
void hashTableInit(HASH_TABLE *);
void hashTableDestroy(HASH_TABLE *);

typedef struct {
  NAMED **p;
  NAMED **end;
} HASH_TABLE_ITER;

void hashTableIterInit(HASH_TABLE_ITER *, const HASH_TABLE *);
NAMED *hashTableIterNext(HASH_TABLE_ITER *);
