/*
 * Decompiled with CFR 0.152.
 */
package free.util;

public class PlatformUtils {
    public static boolean isJavaBetterThan(String string) {
        return System.getProperty("java.version").compareTo(string) >= 0;
    }

    public static boolean isOldMicrosoftVM() {
        String string = System.getProperty("java.vendor");
        return string != null && string.toLowerCase().startsWith("microsoft") && !PlatformUtils.isJavaBetterThan("1.2");
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().startsWith("windows");
    }

    public static boolean isOldWindows() {
        String string = System.getProperty("os.name");
        return PlatformUtils.isWindows() && System.getProperty("os.version").compareTo("5.0") < 0 && !string.toLowerCase().startsWith("windows nt");
    }

    public static boolean isLinux() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().startsWith("linux");
    }

    public static boolean isMacOS() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().startsWith("mac");
    }

    public static boolean isMacOSX() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().startsWith("mac os x");
    }

    public static boolean isSolaris() {
        String string = System.getProperty("os.name");
        return string != null && (string.toLowerCase().startsWith("solaris") || string.toLowerCase().startsWith("sunos"));
    }

    public static String getOSName() {
        if (PlatformUtils.isWindows() || PlatformUtils.isOldWindows()) {
            return "windows";
        }
        if (PlatformUtils.isLinux()) {
            return "linux";
        }
        if (PlatformUtils.isMacOSX()) {
            return "macosx";
        }
        if (PlatformUtils.isSolaris()) {
            return "solaris";
        }
        return null;
    }
}

