/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-03-01 06:57:43 +0100 (Sat, 01 Mar 2014) $
//  number=$Revision: 9852 $
//  type=ks

/**
 * Localized names for the "ks" locale.
 */
public class LocalizedNamesImpl_ks extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "CP",
        "CW",
        "DG",
        "EA",
        "EU",
        "FM",
        "FO",
        "IC",
        "JO",
        "SS",
        "SX",
        "TA",
        "XK",
        "AZ",
        "AU",
        "AT",
        "QO",
        "IM",
        "AR",
        "AI",
        "AO",
        "OM",
        "AM",
        "AW",
        "AF",
        "AS",
        "CI",
        "IE",
        "IS",
        "UZ",
        "ET",
        "ER",
        "IL",
        "ID",
        "IT",
        "EC",
        "GQ",
        "AL",
        "DZ",
        "SV",
        "AG",
        "AD",
        "EE",
        "AX",
        "AQ",
        "IQ",
        "IR",
        "BB",
        "BH",
        "IO",
        "BQ",
        "BR",
        "BW",
        "BI",
        "BA",
        "BO",
        "BV",
        "BT",
        "VG",
        "BG",
        "BD",
        "BS",
        "BN",
        "BF",
        "BJ",
        "BM",
        "BY",
        "BZ",
        "BE",
        "TJ",
        "TW",
        "TV",
        "TK",
        "TZ",
        "TM",
        "TC",
        "TR",
        "TH",
        "GE",
        "ZM",
        "JP",
        "DE",
        "GS",
        "KR",
        "JM",
        "ZA",
        "GI",
        "DJ",
        "JE",
        "RO",
        "RU",
        "RW",
        "RE",
        "ZW",
        "ST",
        "CY",
        "SB",
        "SO",
        "SA",
        "SD",
        "RS",
        "SK",
        "SI",
        "SJ",
        "SR",
        "SZ",
        "CH",
        "SE",
        "LK",
        "ES",
        "SC",
        "WS",
        "SM",
        "BL",
        "LC",
        "MF",
        "VC",
        "PM",
        "KN",
        "SH",
        "SN",
        "SL",
        "SY",
        "MP",
        "KP",
        "FR",
        "TF",
        "GF",
        "PF",
        "PS",
        "FJ",
        "PH",
        "FI",
        "FK",
        "QA",
        "LA",
        "LR",
        "LU",
        "LY",
        "LT",
        "LI",
        "LB",
        "LS",
        "LV",
        "MH",
        "MR",
        "MQ",
        "MV",
        "MT",
        "ML",
        "MS",
        "CF",
        "EH",
        "MW",
        "MA",
        "MU",
        "MZ",
        "MD",
        "MC",
        "ME",
        "TL",
        "MY",
        "MN",
        "MO",
        "MM",
        "YT",
        "AE",
        "EG",
        "MK",
        "MX",
        "MG",
        "NF",
        "NR",
        "NO",
        "NA",
        "NI",
        "NE",
        "NG",
        "AN",
        "NC",
        "NU",
        "NZ",
        "NL",
        "NP",
        "WF",
        "VU",
        "VE",
        "VN",
        "VA",
        "SG",
        "TT",
        "TO",
        "TN",
        "TG",
        "PG",
        "PK",
        "PL",
        "PY",
        "PW",
        "PA",
        "PT",
        "PN",
        "PR",
        "PE",
        "TD",
        "CL",
        "CN",
        "CZ",
        "DM",
        "DO",
        "DK",
        "CX",
        "HR",
        "CR",
        "CO",
        "CG",
        "CD",
        "CC",
        "KZ",
        "KH",
        "KM",
        "KW",
        "CK",
        "KI",
        "KG",
        "KE",
        "KY",
        "CA",
        "CU",
        "CM",
        "CV",
        "GH",
        "GD",
        "GR",
        "GL",
        "GT",
        "GM",
        "GP",
        "GU",
        "GY",
        "GN",
        "GA",
        "GG",
        "GW",
        "HN",
        "HK",
        "HT",
        "HM",
        "HU",
        "IN",
        "VI",
        "UY",
        "UA",
        "US",
        "UM",
        "UG",
        "YE",
        "GB",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "دُنیا");
    namesMap.put("002", "اَفریٖکا");
    namesMap.put("003", "شُمٲلی اَمریٖکا");
    namesMap.put("005", "جَنوٗنی اَمرٖیٖکا");
    namesMap.put("009", "اوشَنیا");
    namesMap.put("011", "مَغریٖبی اَفریٖکا");
    namesMap.put("013", "مرکٔزی اَمریٖکا");
    namesMap.put("014", "مَشرِقی اَفریٖکا");
    namesMap.put("015", "شُمٲلی اَفریٖکا");
    namesMap.put("017", "وسطی اَفریٖکا");
    namesMap.put("018", "جنوٗبی اَفریٖکا");
    namesMap.put("019", "اَمریٖکَس");
    namesMap.put("021", "شُمٲلی اَمریٖکا خٕطہٕ");
    namesMap.put("029", "کَرِببیٖن");
    namesMap.put("030", "مَشرِقی ایشیا");
    namesMap.put("034", "جنوٗبی ایشیا");
    namesMap.put("035", "جنوٗبہِ مَشرِقی ایشیا");
    namesMap.put("039", "جنوٗبی یوٗرَپ");
    namesMap.put("053", "آسٹریلیا تہٕ نِوزِلینٛڑ");
    namesMap.put("054", "مٮ۪لَنیٖشِیا");
    namesMap.put("057", "مَیکرونَیشِیَن خٕطہٕ");
    namesMap.put("061", "پالنیشِیا");
    namesMap.put("142", "ایشیا");
    namesMap.put("143", "مرکٔزی ایشیا");
    namesMap.put("145", "مَغرِبی ایشیا");
    namesMap.put("150", "یوٗرَپ");
    namesMap.put("151", "مشرِقی یوٗرَپ");
    namesMap.put("154", "شُمٲلی یوٗرَپ");
    namesMap.put("155", "مغرِبی یوٗرَپ");
    namesMap.put("419", "لاطیٖنی اَمریٖکا تہٕ کیرَبیٖن");
    namesMap.put("AD", "اٮ۪نڑورا");
    namesMap.put("AE", "مُتحدہ عرَب امارات");
    namesMap.put("AF", "اَفغانَستان");
    namesMap.put("AG", "اٮ۪نٹِگُوا تہٕ باربوڑا");
    namesMap.put("AI", "انگوئیلا");
    namesMap.put("AL", "اٮ۪لبانِیا");
    namesMap.put("AM", "اَرمانِیا");
    namesMap.put("AN", "نَیدَرلینٛڑٕس اٮ۪نٹَیلٕس");
    namesMap.put("AO", "انگولا");
    namesMap.put("AQ", "اینٹارٹِکا");
    namesMap.put("AR", "أرجَنٹینا");
    namesMap.put("AS", "اَمریٖکَن سَموا");
    namesMap.put("AT", "آسٹِیا");
    namesMap.put("AU", "آسٹریلِیا");
    namesMap.put("AW", "اَروٗبا");
    namesMap.put("AX", "ایلینٛڑ جٔزیٖرٕ");
    namesMap.put("AZ", "آزَرباجان");
    namesMap.put("BA", "بوسنِیا تہٕ ہَرزِگووِنا");
    namesMap.put("BB", "باربیڈاس");
    namesMap.put("BD", "بَنٛگلادیش");
    namesMap.put("BE", "بیٛلجِیَم");
    namesMap.put("BF", "بُرکِنا فیسو");
    namesMap.put("BG", "بَلجیرِیا");
    namesMap.put("BH", "بحریٖن");
    namesMap.put("BI", "بورَنڈِ");
    namesMap.put("BJ", "بِنِن");
    namesMap.put("BL", "سینٛٹ بارتَھیلمی");
    namesMap.put("BM", "بٔرمیوڈا");
    namesMap.put("BN", "بُرنٔے");
    namesMap.put("BO", "بولِوِیا");
    namesMap.put("BQ", "برطانوی قُطبہِ جَنوٗبی علاقہٕ");
    namesMap.put("BR", "برٛازِل");
    namesMap.put("BS", "بَہامَس");
    namesMap.put("BT", "بوٗٹان");
    namesMap.put("BV", "بووَٹ جٔزیٖرٕ");
    namesMap.put("BW", "بوتَسوانا");
    namesMap.put("BY", "بیلاروٗس");
    namesMap.put("BZ", "بیلِج");
    namesMap.put("CA", "کینَڑا");
    namesMap.put("CC", "کوکَس کیٖلِنٛگ جٔزیٖرٕ");
    namesMap.put("CD", "کونٛگو کِنشاسا");
    namesMap.put("CF", "مرکٔزی اَفریٖکی جموٗریَت");
    namesMap.put("CG", "کونٛگو بٔرٛزاوِلی");
    namesMap.put("CH", "سُوِزَرلینٛڑ");
    namesMap.put("CI", "اَیوٕری کوسٹ");
    namesMap.put("CK", "کُک جٔزیٖرٕ");
    namesMap.put("CL", "چِلی");
    namesMap.put("CM", "کیٚمِروٗن");
    namesMap.put("CN", "چیٖن");
    namesMap.put("CO", "کولَمبِیا");
    namesMap.put("CR", "کوسٹا رِکا");
    namesMap.put("CU", "کیوٗبا");
    namesMap.put("CV", "کیپ ؤرڑی");
    namesMap.put("CX", "کرِسمَس جٔزیٖرٕ");
    namesMap.put("CY", "سایفرٛس");
    namesMap.put("CZ", "چیک جَموٗرِیَت");
    namesMap.put("DE", "جرمٔنی");
    namesMap.put("DJ", "جِبوٗتی");
    namesMap.put("DK", "ڈینٛمارٕک");
    namesMap.put("DM", "ڈومِنِکا");
    namesMap.put("DO", "ڈومِنِکَن جموٗرِیَت");
    namesMap.put("DZ", "اٮ۪لجیرِیا");
    namesMap.put("EC", "اِکواڑور");
    namesMap.put("EE", "ایسٹونِیا");
    namesMap.put("EG", "مِسٔر");
    namesMap.put("EH", "مشرِقی سَہارا");
    namesMap.put("ER", "اِرٕٹِیا");
    namesMap.put("ES", "سٕپین");
    namesMap.put("ET", "اِتھوپِیا");
    namesMap.put("FI", "فِنلینٛڑ");
    namesMap.put("FJ", "فِجی");
    namesMap.put("FK", "فٕلاکلینٛڑ جٔزیٖرٕ");
    namesMap.put("FR", "فرٛانس");
    namesMap.put("GA", "گیبان");
    namesMap.put("GB", "یُنایٹِڑ کِنٛگڈَم");
    namesMap.put("GD", "گرٛنیڑا");
    namesMap.put("GE", "جارجِیا");
    namesMap.put("GF", "فرٛانسِسی گِانا");
    namesMap.put("GG", "گیوَنَرسے");
    namesMap.put("GH", "گانا");
    namesMap.put("GI", "جِبرالٹَر");
    namesMap.put("GL", "گریٖنلینٛڑ");
    namesMap.put("GM", "گَمبِیا");
    namesMap.put("GN", "گِنی");
    namesMap.put("GP", "گَواڑیلوپ");
    namesMap.put("GQ", "اِکوِٹورِیَل گِنی");
    namesMap.put("GR", "گریٖس");
    namesMap.put("GS", "جنوٗبی جارجِیا تہٕ جنوٗبی سینٛڑوٕچ جٔزیٖرٕ");
    namesMap.put("GT", "گوتیدالا");
    namesMap.put("GU", "گُوام");
    namesMap.put("GW", "گیٖنی بِساو");
    namesMap.put("GY", "گُیانا");
    namesMap.put("HK", "ہانٛگ کانٛگ ایس اے آر چیٖن");
    namesMap.put("HM", "ہَرٕڑ جٔزیٖرٕ تہٕ مٮ۪کڈونالڑٕ جٔزیٖرٕ");
    namesMap.put("HN", "ہانٛڈوٗرِس");
    namesMap.put("HR", "کرٛوشِیا");
    namesMap.put("HT", "ہایتی");
    namesMap.put("HU", "ہَنٛگری");
    namesMap.put("ID", "اِنڑونیشِیا");
    namesMap.put("IE", "اَیَرلینٛڑ");
    namesMap.put("IL", "اِسرایٖل");
    namesMap.put("IM", "آیِل آف میٛن");
    namesMap.put("IN", "ہِنٛدوستان");
    namesMap.put("IO", "برطانوی بحرِ ہِنٛدۍ علاقہٕ");
    namesMap.put("IQ", "ایٖراق");
    namesMap.put("IR", "ایٖران");
    namesMap.put("IS", "اَیِسلینٛڑ");
    namesMap.put("IT", "اِٹلی");
    namesMap.put("JE", "جٔرسی");
    namesMap.put("JM", "جَمایکا");
    namesMap.put("JP", "جاپان");
    namesMap.put("KE", "کِنٛیا");
    namesMap.put("KG", "کِرگِستان");
    namesMap.put("KH", "کَمبوڑِیا");
    namesMap.put("KI", "کِرٕباتی");
    namesMap.put("KM", "کَمورَس");
    namesMap.put("KN", "سینٛٹ کِٹَس تہٕ نیوِس");
    namesMap.put("KP", "شُمٲلی کورِیا");
    namesMap.put("KR", "جنوٗبی کورِیا");
    namesMap.put("KW", "کُویت");
    namesMap.put("KY", "کیمَن جٔزیٖرٕ");
    namesMap.put("KZ", "کَزاکِستان");
    namesMap.put("LA", "لاس");
    namesMap.put("LB", "لٮ۪بنان");
    namesMap.put("LC", "سینٛٹ لوٗسِیا");
    namesMap.put("LI", "لِکٹیٛسٹیٖن");
    namesMap.put("LK", "سِریٖلَنٛکا");
    namesMap.put("LR", "لایبیرِیا");
    namesMap.put("LS", "لیسوتھو");
    namesMap.put("LT", "لِتھُوانِیا");
    namesMap.put("LU", "لَکسَمبٔرٕگ");
    namesMap.put("LV", "لیٛٹوِیا");
    namesMap.put("LY", "لِبیا");
    namesMap.put("MA", "موروکو");
    namesMap.put("MC", "مونیٚکو");
    namesMap.put("MD", "مولڑاوِیا");
    namesMap.put("ME", "موٹونیٛگِریو");
    namesMap.put("MF", "سینٛٹ مارٹِن");
    namesMap.put("MG", "میڑاگاسکار");
    namesMap.put("MH", "مارشَل جٔزیٖرٕ");
    namesMap.put("MK", "مٮ۪سوڑونِیا");
    namesMap.put("ML", "مالی");
    namesMap.put("MM", "مَیَنما بٔرما");
    namesMap.put("MN", "مَنٛگولِیا");
    namesMap.put("MO", "مَکاوو ایس اے آر چیٖن");
    namesMap.put("MP", "شُمٲلی مارِیانا جٔزیٖرٕ");
    namesMap.put("MQ", "مارٹِنِک");
    namesMap.put("MR", "مارٕٹانِیا");
    namesMap.put("MS", "مانٛٹسیراٹ");
    namesMap.put("MT", "مالٹا");
    namesMap.put("MU", "مورِشَس");
    namesMap.put("MV", "مالدیٖو");
    namesMap.put("MW", "ملاوی");
    namesMap.put("MX", "مٮ۪کسِکو");
    namesMap.put("MY", "مَلیشِیا");
    namesMap.put("MZ", "موزَمبِک");
    namesMap.put("NA", "نامِبِیا");
    namesMap.put("NC", "نِو کیلِڑونِیا");
    namesMap.put("NE", "نایجَر");
    namesMap.put("NF", "نارفاک جٔزیٖرٕ");
    namesMap.put("NG", "نایجیرِیا");
    namesMap.put("NI", "ناکاراگُوا");
    namesMap.put("NL", "نیٖدَرلینٛڑ");
    namesMap.put("NO", "ناروے");
    namesMap.put("NP", "نیپال");
    namesMap.put("NR", "نارووٗ");
    namesMap.put("NU", "نیوٗ");
    namesMap.put("NZ", "نیوٗزِلینٛڑ");
    namesMap.put("OM", "اومان");
    namesMap.put("PA", "پَناما");
    namesMap.put("PE", "پیٖروٗ");
    namesMap.put("PF", "فرٛانسی پولِنیشِیا");
    namesMap.put("PG", "پاپُوا نیوٗ گیٖنی");
    namesMap.put("PH", "فِلِپِینس");
    namesMap.put("PK", "پاکِستان");
    namesMap.put("PL", "پولینٛڑ");
    namesMap.put("PM", "سینٛٹ پیٖری تہٕ موکیلِیَن");
    namesMap.put("PN", "پِٹکیرٕنۍ جٔزیٖرٕ");
    namesMap.put("PR", "پٔرٹو رِکو");
    namesMap.put("PS", "فَلَستیٖن");
    namesMap.put("PT", "پُرتِگال");
    namesMap.put("PW", "پَلاو");
    namesMap.put("PY", "پَراگُے");
    namesMap.put("QA", "قَطِر");
    namesMap.put("QO", "آوُٹلاینِگ اوشینِیا");
    namesMap.put("RE", "رِیوٗنِیَن");
    namesMap.put("RO", "رومانِیا");
    namesMap.put("RS", "سَربِیا");
    namesMap.put("RU", "روٗس");
    namesMap.put("RW", "روٗوانٛڈا");
    namesMap.put("SA", "سوٗدی عربِیہ");
    namesMap.put("SB", "سولامان جٔزیٖرٕ");
    namesMap.put("SC", "سیشَلِس");
    namesMap.put("SD", "سوٗڈان");
    namesMap.put("SE", "سُوِڈَن");
    namesMap.put("SG", "ٛسِنٛگاپوٗر");
    namesMap.put("SH", "سینٛٹ ہٮ۪لِنا");
    namesMap.put("SI", "سَلووینِیا");
    namesMap.put("SJ", "سَوالبریڑ تہٕ جان ماییڑ");
    namesMap.put("SK", "سَلوواکِیا");
    namesMap.put("SL", "سیٖرالیوون");
    namesMap.put("SM", "سین میرِنو");
    namesMap.put("SN", "سینیگَل");
    namesMap.put("SO", "سومالِیا");
    namesMap.put("SR", "سُرِنام");
    namesMap.put("ST", "ساو توم تہٕ پرٛنسِپی");
    namesMap.put("SV", "اٮ۪ل سَلواڑور");
    namesMap.put("SY", "شام");
    namesMap.put("SZ", "سُوزِلینٛڑ");
    namesMap.put("TC", "تُرُک تہٕ کیکوس جٔزیٖرٕ");
    namesMap.put("TD", "چاڑ");
    namesMap.put("TF", "فرٛانسِسی جَنوٗبی عَلاقہٕ");
    namesMap.put("TG", "ٹوگو");
    namesMap.put("TH", "تھایلینٛڑ");
    namesMap.put("TJ", "تاجکِستان");
    namesMap.put("TK", "توکیلاو");
    namesMap.put("TL", "مَشرِقی تایمور");
    namesMap.put("TM", "تُرمِنِستان");
    namesMap.put("TN", "ٹونیشِیا");
    namesMap.put("TO", "ٹونٛگا");
    namesMap.put("TR", "تُرکی");
    namesMap.put("TT", "ٹرٛنِنداد تہٕ ٹوبیگو");
    namesMap.put("TV", "توٗوالوٗ");
    namesMap.put("TW", "تایوان");
    namesMap.put("TZ", "تَنجانِیا");
    namesMap.put("UA", "یوٗرِکین");
    namesMap.put("UG", "یوٗگانٛڑا");
    namesMap.put("UM", "یوٗنایٹِڑ سِٹیٹِس ماینَر آوُٹلییِنٛگ جٔزیٖرٕ");
    namesMap.put("US", "یوٗنایٹِڑ سِٹیٹِس");
    namesMap.put("UY", "یوٗروگے");
    namesMap.put("UZ", "اُزبِکِستان");
    namesMap.put("VA", "ویٹِکَن سِٹی");
    namesMap.put("VC", "سینٛٹ وینسٮ۪ٹ تہٕ گرٛیناڑاینٕز");
    namesMap.put("VE", "وینازوٗلا");
    namesMap.put("VG", "بَرطانوی ؤرجِن جٔزیٖرٕ");
    namesMap.put("VI", "یوٗ ایس ؤرجِن جٔزیٖرٕ");
    namesMap.put("VN", "ویٹِنام");
    namesMap.put("VU", "وانوٗتوٗ");
    namesMap.put("WF", "والِس تہٕ فیوٗچوٗنا");
    namesMap.put("WS", "سیمووا");
    namesMap.put("YE", "یَمَن");
    namesMap.put("YT", "مَییٹ");
    namesMap.put("ZA", "جَنوٗبی اَفریٖکا");
    namesMap.put("ZM", "جامبِیا");
    namesMap.put("ZW", "زِمبابے");
    namesMap.put("ZZ", "نامعلوٗم تہٕ نالَگہار عَلاقہٕ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "دُنیا",
        "002": "اَفریٖکا",
        "003": "شُمٲلی اَمریٖکا",
        "005": "جَنوٗنی اَمرٖیٖکا",
        "009": "اوشَنیا",
        "011": "مَغریٖبی اَفریٖکا",
        "013": "مرکٔزی اَمریٖکا",
        "014": "مَشرِقی اَفریٖکا",
        "015": "شُمٲلی اَفریٖکا",
        "017": "وسطی اَفریٖکا",
        "018": "جنوٗبی اَفریٖکا",
        "019": "اَمریٖکَس",
        "021": "شُمٲلی اَمریٖکا خٕطہٕ",
        "029": "کَرِببیٖن",
        "030": "مَشرِقی ایشیا",
        "034": "جنوٗبی ایشیا",
        "035": "جنوٗبہِ مَشرِقی ایشیا",
        "039": "جنوٗبی یوٗرَپ",
        "053": "آسٹریلیا تہٕ نِوزِلینٛڑ",
        "054": "مٮ۪لَنیٖشِیا",
        "057": "مَیکرونَیشِیَن خٕطہٕ",
        "061": "پالنیشِیا",
        "142": "ایشیا",
        "143": "مرکٔزی ایشیا",
        "145": "مَغرِبی ایشیا",
        "150": "یوٗرَپ",
        "151": "مشرِقی یوٗرَپ",
        "154": "شُمٲلی یوٗرَپ",
        "155": "مغرِبی یوٗرَپ",
        "419": "لاطیٖنی اَمریٖکا تہٕ کیرَبیٖن",
        "AD": "اٮ۪نڑورا",
        "AE": "مُتحدہ عرَب امارات",
        "AF": "اَفغانَستان",
        "AG": "اٮ۪نٹِگُوا تہٕ باربوڑا",
        "AI": "انگوئیلا",
        "AL": "اٮ۪لبانِیا",
        "AM": "اَرمانِیا",
        "AN": "نَیدَرلینٛڑٕس اٮ۪نٹَیلٕس",
        "AO": "انگولا",
        "AQ": "اینٹارٹِکا",
        "AR": "أرجَنٹینا",
        "AS": "اَمریٖکَن سَموا",
        "AT": "آسٹِیا",
        "AU": "آسٹریلِیا",
        "AW": "اَروٗبا",
        "AX": "ایلینٛڑ جٔزیٖرٕ",
        "AZ": "آزَرباجان",
        "BA": "بوسنِیا تہٕ ہَرزِگووِنا",
        "BB": "باربیڈاس",
        "BD": "بَنٛگلادیش",
        "BE": "بیٛلجِیَم",
        "BF": "بُرکِنا فیسو",
        "BG": "بَلجیرِیا",
        "BH": "بحریٖن",
        "BI": "بورَنڈِ",
        "BJ": "بِنِن",
        "BL": "سینٛٹ بارتَھیلمی",
        "BM": "بٔرمیوڈا",
        "BN": "بُرنٔے",
        "BO": "بولِوِیا",
        "BQ": "برطانوی قُطبہِ جَنوٗبی علاقہٕ",
        "BR": "برٛازِل",
        "BS": "بَہامَس",
        "BT": "بوٗٹان",
        "BV": "بووَٹ جٔزیٖرٕ",
        "BW": "بوتَسوانا",
        "BY": "بیلاروٗس",
        "BZ": "بیلِج",
        "CA": "کینَڑا",
        "CC": "کوکَس کیٖلِنٛگ جٔزیٖرٕ",
        "CD": "کونٛگو کِنشاسا",
        "CF": "مرکٔزی اَفریٖکی جموٗریَت",
        "CG": "کونٛگو بٔرٛزاوِلی",
        "CH": "سُوِزَرلینٛڑ",
        "CI": "اَیوٕری کوسٹ",
        "CK": "کُک جٔزیٖرٕ",
        "CL": "چِلی",
        "CM": "کیٚمِروٗن",
        "CN": "چیٖن",
        "CO": "کولَمبِیا",
        "CR": "کوسٹا رِکا",
        "CU": "کیوٗبا",
        "CV": "کیپ ؤرڑی",
        "CX": "کرِسمَس جٔزیٖرٕ",
        "CY": "سایفرٛس",
        "CZ": "چیک جَموٗرِیَت",
        "DE": "جرمٔنی",
        "DJ": "جِبوٗتی",
        "DK": "ڈینٛمارٕک",
        "DM": "ڈومِنِکا",
        "DO": "ڈومِنِکَن جموٗرِیَت",
        "DZ": "اٮ۪لجیرِیا",
        "EC": "اِکواڑور",
        "EE": "ایسٹونِیا",
        "EG": "مِسٔر",
        "EH": "مشرِقی سَہارا",
        "ER": "اِرٕٹِیا",
        "ES": "سٕپین",
        "ET": "اِتھوپِیا",
        "FI": "فِنلینٛڑ",
        "FJ": "فِجی",
        "FK": "فٕلاکلینٛڑ جٔزیٖرٕ",
        "FR": "فرٛانس",
        "GA": "گیبان",
        "GB": "یُنایٹِڑ کِنٛگڈَم",
        "GD": "گرٛنیڑا",
        "GE": "جارجِیا",
        "GF": "فرٛانسِسی گِانا",
        "GG": "گیوَنَرسے",
        "GH": "گانا",
        "GI": "جِبرالٹَر",
        "GL": "گریٖنلینٛڑ",
        "GM": "گَمبِیا",
        "GN": "گِنی",
        "GP": "گَواڑیلوپ",
        "GQ": "اِکوِٹورِیَل گِنی",
        "GR": "گریٖس",
        "GS": "جنوٗبی جارجِیا تہٕ جنوٗبی سینٛڑوٕچ جٔزیٖرٕ",
        "GT": "گوتیدالا",
        "GU": "گُوام",
        "GW": "گیٖنی بِساو",
        "GY": "گُیانا",
        "HK": "ہانٛگ کانٛگ ایس اے آر چیٖن",
        "HM": "ہَرٕڑ جٔزیٖرٕ تہٕ مٮ۪کڈونالڑٕ جٔزیٖرٕ",
        "HN": "ہانٛڈوٗرِس",
        "HR": "کرٛوشِیا",
        "HT": "ہایتی",
        "HU": "ہَنٛگری",
        "ID": "اِنڑونیشِیا",
        "IE": "اَیَرلینٛڑ",
        "IL": "اِسرایٖل",
        "IM": "آیِل آف میٛن",
        "IN": "ہِنٛدوستان",
        "IO": "برطانوی بحرِ ہِنٛدۍ علاقہٕ",
        "IQ": "ایٖراق",
        "IR": "ایٖران",
        "IS": "اَیِسلینٛڑ",
        "IT": "اِٹلی",
        "JE": "جٔرسی",
        "JM": "جَمایکا",
        "JP": "جاپان",
        "KE": "کِنٛیا",
        "KG": "کِرگِستان",
        "KH": "کَمبوڑِیا",
        "KI": "کِرٕباتی",
        "KM": "کَمورَس",
        "KN": "سینٛٹ کِٹَس تہٕ نیوِس",
        "KP": "شُمٲلی کورِیا",
        "KR": "جنوٗبی کورِیا",
        "KW": "کُویت",
        "KY": "کیمَن جٔزیٖرٕ",
        "KZ": "کَزاکِستان",
        "LA": "لاس",
        "LB": "لٮ۪بنان",
        "LC": "سینٛٹ لوٗسِیا",
        "LI": "لِکٹیٛسٹیٖن",
        "LK": "سِریٖلَنٛکا",
        "LR": "لایبیرِیا",
        "LS": "لیسوتھو",
        "LT": "لِتھُوانِیا",
        "LU": "لَکسَمبٔرٕگ",
        "LV": "لیٛٹوِیا",
        "LY": "لِبیا",
        "MA": "موروکو",
        "MC": "مونیٚکو",
        "MD": "مولڑاوِیا",
        "ME": "موٹونیٛگِریو",
        "MF": "سینٛٹ مارٹِن",
        "MG": "میڑاگاسکار",
        "MH": "مارشَل جٔزیٖرٕ",
        "MK": "مٮ۪سوڑونِیا",
        "ML": "مالی",
        "MM": "مَیَنما بٔرما",
        "MN": "مَنٛگولِیا",
        "MO": "مَکاوو ایس اے آر چیٖن",
        "MP": "شُمٲلی مارِیانا جٔزیٖرٕ",
        "MQ": "مارٹِنِک",
        "MR": "مارٕٹانِیا",
        "MS": "مانٛٹسیراٹ",
        "MT": "مالٹا",
        "MU": "مورِشَس",
        "MV": "مالدیٖو",
        "MW": "ملاوی",
        "MX": "مٮ۪کسِکو",
        "MY": "مَلیشِیا",
        "MZ": "موزَمبِک",
        "NA": "نامِبِیا",
        "NC": "نِو کیلِڑونِیا",
        "NE": "نایجَر",
        "NF": "نارفاک جٔزیٖرٕ",
        "NG": "نایجیرِیا",
        "NI": "ناکاراگُوا",
        "NL": "نیٖدَرلینٛڑ",
        "NO": "ناروے",
        "NP": "نیپال",
        "NR": "نارووٗ",
        "NU": "نیوٗ",
        "NZ": "نیوٗزِلینٛڑ",
        "OM": "اومان",
        "PA": "پَناما",
        "PE": "پیٖروٗ",
        "PF": "فرٛانسی پولِنیشِیا",
        "PG": "پاپُوا نیوٗ گیٖنی",
        "PH": "فِلِپِینس",
        "PK": "پاکِستان",
        "PL": "پولینٛڑ",
        "PM": "سینٛٹ پیٖری تہٕ موکیلِیَن",
        "PN": "پِٹکیرٕنۍ جٔزیٖرٕ",
        "PR": "پٔرٹو رِکو",
        "PS": "فَلَستیٖن",
        "PT": "پُرتِگال",
        "PW": "پَلاو",
        "PY": "پَراگُے",
        "QA": "قَطِر",
        "QO": "آوُٹلاینِگ اوشینِیا",
        "RE": "رِیوٗنِیَن",
        "RO": "رومانِیا",
        "RS": "سَربِیا",
        "RU": "روٗس",
        "RW": "روٗوانٛڈا",
        "SA": "سوٗدی عربِیہ",
        "SB": "سولامان جٔزیٖرٕ",
        "SC": "سیشَلِس",
        "SD": "سوٗڈان",
        "SE": "سُوِڈَن",
        "SG": "ٛسِنٛگاپوٗر",
        "SH": "سینٛٹ ہٮ۪لِنا",
        "SI": "سَلووینِیا",
        "SJ": "سَوالبریڑ تہٕ جان ماییڑ",
        "SK": "سَلوواکِیا",
        "SL": "سیٖرالیوون",
        "SM": "سین میرِنو",
        "SN": "سینیگَل",
        "SO": "سومالِیا",
        "SR": "سُرِنام",
        "ST": "ساو توم تہٕ پرٛنسِپی",
        "SV": "اٮ۪ل سَلواڑور",
        "SY": "شام",
        "SZ": "سُوزِلینٛڑ",
        "TC": "تُرُک تہٕ کیکوس جٔزیٖرٕ",
        "TD": "چاڑ",
        "TF": "فرٛانسِسی جَنوٗبی عَلاقہٕ",
        "TG": "ٹوگو",
        "TH": "تھایلینٛڑ",
        "TJ": "تاجکِستان",
        "TK": "توکیلاو",
        "TL": "مَشرِقی تایمور",
        "TM": "تُرمِنِستان",
        "TN": "ٹونیشِیا",
        "TO": "ٹونٛگا",
        "TR": "تُرکی",
        "TT": "ٹرٛنِنداد تہٕ ٹوبیگو",
        "TV": "توٗوالوٗ",
        "TW": "تایوان",
        "TZ": "تَنجانِیا",
        "UA": "یوٗرِکین",
        "UG": "یوٗگانٛڑا",
        "UM": "یوٗنایٹِڑ سِٹیٹِس ماینَر آوُٹلییِنٛگ جٔزیٖرٕ",
        "US": "یوٗنایٹِڑ سِٹیٹِس",
        "UY": "یوٗروگے",
        "UZ": "اُزبِکِستان",
        "VA": "ویٹِکَن سِٹی",
        "VC": "سینٛٹ وینسٮ۪ٹ تہٕ گرٛیناڑاینٕز",
        "VE": "وینازوٗلا",
        "VG": "بَرطانوی ؤرجِن جٔزیٖرٕ",
        "VI": "یوٗ ایس ؤرجِن جٔزیٖرٕ",
        "VN": "ویٹِنام",
        "VU": "وانوٗتوٗ",
        "WF": "والِس تہٕ فیوٗچوٗنا",
        "WS": "سیمووا",
        "YE": "یَمَن",
        "YT": "مَییٹ",
        "ZA": "جَنوٗبی اَفریٖکا",
        "ZM": "جامبِیا",
        "ZW": "زِمبابے",
        "ZZ": "نامعلوٗم تہٕ نالَگہار عَلاقہٕ"
    };
  }-*/;
}
