/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.IdTypeMap;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.xml.util.Name;
import com.thaiopensource.xml.util.StringSplitter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class IdSoundnessChecker
implements Validator,
ContentHandler {
    private final IdTypeMap idTypeMap;
    private final ErrorHandler eh;
    private Locator locator;
    private final Hashtable table = new Hashtable();

    public IdSoundnessChecker(IdTypeMap idTypeMap, ErrorHandler eh) {
        this.idTypeMap = idTypeMap;
        this.eh = eh;
    }

    public void reset() {
        this.table.clear();
        this.locator = null;
    }

    public ContentHandler getContentHandler() {
        return this;
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
    }

    void setComplete() {
    }

    public void endDocument() throws SAXException {
        Enumeration e = this.table.keys();
        while (e.hasMoreElements()) {
            String token = (String)e.nextElement();
            Entry entry = (Entry)this.table.get(token);
            if (entry.hadId) continue;
            Enumeration f = entry.idrefLocs.elements();
            while (f.hasMoreElements()) {
                this.error("missing_id", token, (Locator)f.nextElement());
            }
        }
        this.setComplete();
    }

    public void startPrefixMapping(String s, String s1) throws SAXException {
    }

    public void endPrefixMapping(String s) throws SAXException {
    }

    public void startElement(String namespaceUri, String localName, String qName, Attributes attributes) throws SAXException {
        Name elementName = new Name(namespaceUri, localName);
        int len = attributes.getLength();
        block5: for (int i = 0; i < len; ++i) {
            Name attributeName = new Name(attributes.getURI(i), attributes.getLocalName(i));
            int idType = this.idTypeMap.getIdType(elementName, attributeName);
            if (idType == 0) continue;
            String[] tokens = StringSplitter.split(attributes.getValue(i));
            switch (idType) {
                case 1: {
                    if (tokens.length == 1) {
                        this.id(tokens[0]);
                        continue block5;
                    }
                    if (tokens.length == 0) {
                        this.error("id_no_tokens");
                        continue block5;
                    }
                    this.error("id_multiple_tokens");
                    continue block5;
                }
                case 2: {
                    if (tokens.length == 1) {
                        this.idref(tokens[0]);
                        continue block5;
                    }
                    if (tokens.length == 0) {
                        this.error("idref_no_tokens");
                        continue block5;
                    }
                    this.error("idref_multiple_tokens");
                    continue block5;
                }
                case 3: {
                    if (tokens.length > 0) {
                        for (int j = 0; j < tokens.length; ++j) {
                            this.idref(tokens[j]);
                        }
                        continue block5;
                    }
                    this.error("idrefs_no_tokens");
                }
            }
        }
    }

    private void id(String token) throws SAXException {
        Entry entry = (Entry)this.table.get(token);
        if (entry == null) {
            entry = new Entry();
            this.table.put(token, entry);
        } else if (entry.hadId) {
            this.error("duplicate_id", token);
            this.error("first_id", token, entry.idLoc);
            return;
        }
        entry.idLoc = new LocatorImpl(this.locator);
        entry.hadId = true;
    }

    private void idref(String token) {
        Entry entry = (Entry)this.table.get(token);
        if (entry == null) {
            entry = new Entry();
            this.table.put(token, entry);
        }
        if (entry.hadId) {
            return;
        }
        if (entry.idrefLocs == null) {
            entry.idrefLocs = new Vector();
        }
        entry.idrefLocs.addElement(new LocatorImpl(this.locator));
    }

    public void endElement(String s, String s1, String s2) throws SAXException {
    }

    public void characters(char[] chars, int i, int i1) throws SAXException {
    }

    public void ignorableWhitespace(char[] chars, int i, int i1) throws SAXException {
    }

    public void processingInstruction(String s, String s1) throws SAXException {
    }

    public void skippedEntity(String s) throws SAXException {
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    private void error(String key) throws SAXException {
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(key), this.locator));
    }

    private void error(String key, String arg) throws SAXException {
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(key, arg), this.locator));
    }

    private void error(String key, String arg, Locator loc) throws SAXException {
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(key, arg), loc));
    }

    private static class Entry {
        Locator idLoc;
        Vector idrefLocs;
        boolean hadId;

        private Entry() {
        }
    }
}

