/*
 * Decompiled with CFR 0.152.
 */
package ssw;

import java.util.Arrays;
import ssw.Alignment;

public class Aligner {
    public static final int MAX_SCORE_LESS_THAN_255 = 0;
    public static final int MAX_SCORE_GREATER_THAN_255 = 1;
    public static final int MAX_SCORE_UNSURE = 2;
    public static final int FLAG_INCLUDE_BEST_ALIGNMENT_POSITION = 8;
    public static final int FLAG_INCLUDE_BEST_ALIGNMENT_POSITION_AND_CIGAR_IF_MORE_THAN_FILTER_DISTANCE_POSITIONS_ALIGNED = 4;
    public static final int FLAG_INCLUDE_BEST_ALIGNMENT_POSITION_AND_CIGAR_IF_SCORE_GREATER_THAN_FILTER_SORE = 2;
    public static final int FLAG_INCLUDE_BEST_ALIGNMENT_POSITION_AND_CIGAR = 1;

    public static native Alignment align(byte[] var0, byte[] var1, int var2, int var3, byte[] var4, int var5, int var6, int var7, short var8, int var9, int var10);

    public static Alignment align(byte[] byArray, byte[] byArray2, int[][] nArray, int n, int n2, boolean bl) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Gap open and extension penalties must be positive");
        }
        if (n >= 256 || n2 >= 256) {
            throw new IllegalArgumentException("Gap open and extension penalties must fit into unsigned 8-bit integer");
        }
        int[] nArray2 = new int[257];
        Arrays.fill(nArray2, -1);
        nArray2[256] = 0;
        byte[] byArray3 = Aligner.convertToNumeric(nArray2, byArray, bl);
        byte[] byArray4 = Aligner.convertToNumeric(nArray2, byArray2, bl);
        byte[] byArray5 = Aligner.flatten(nArray2, nArray);
        int n3 = nArray2[256];
        assert (byArray5.length == n3 * n3);
        assert (Aligner.maxValue(byArray3) < n3);
        assert (Aligner.maxValue(byArray4) < n3);
        Alignment alignment = Aligner.align(byArray3, byArray5, n3, 2, byArray4, n, n2, 1, (short)0, 0, Math.max(15, byArray3.length / 2));
        return alignment;
    }

    private static int maxValue(byte[] byArray) {
        byte by;
        int by2 = Integer.MIN_VALUE;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] <= by) continue;
            by = byArray[i];
        }
        return by;
    }

    private static byte[] convertToNumeric(int[] nArray, byte[] byArray, boolean bl) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i];
            if (bl) {
                n = Character.toUpperCase(n);
            }
            if (nArray[n] == -1) {
                nArray[256] = nArray[256] + 1;
            }
            byArray2[i] = (byte)nArray[n];
        }
        return byArray2;
    }

    private static byte[] flatten(int[] nArray, int[][] nArray2) {
        int n = nArray[256];
        byte[] byArray = new byte[n * n];
        for (int i = 0; i < nArray2.length; ++i) {
            int n2 = nArray[i];
            if (n2 == -1) continue;
            for (int j = 0; j < nArray2[i].length; ++j) {
                int n3 = nArray[j];
                if (n3 == -1) continue;
                int n4 = nArray2[i][j];
                if (n4 < -128 || n4 > 127) {
                    throw new IllegalArgumentException("Scoring matrix values must fit into signed 8-bit integer");
                }
                byArray[n2 * n + n3] = (byte)n4;
            }
        }
        return byArray;
    }
}

