/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.impl;

import edu.umd.marbl.mhap.impl.OverlapInfo;
import edu.umd.marbl.mhap.impl.SequenceId;

public final class MatchResult
implements Comparable<MatchResult> {
    private final SequenceId fromId;
    private final SequenceId toId;
    private final int a1;
    private final int a2;
    private final int b1;
    private final int b2;
    private final double score;
    private final double rawScore;
    private final int fromLength;
    private final int toLength;

    protected MatchResult(SequenceId fromId, SequenceId toId, OverlapInfo overlap, int fromLength, int toLength) {
        this.fromId = fromId;
        this.toId = toId;
        this.fromLength = fromLength;
        this.toLength = toLength;
        this.a1 = this.getFromId().isForward() ? overlap.a1 : fromLength - overlap.a2 - 1;
        this.a2 = this.getFromId().isForward() ? overlap.a2 : fromLength - overlap.a1 - 1;
        this.b1 = this.getToId().isForward() ? overlap.b1 : toLength - overlap.b2 - 1;
        this.b2 = this.getToId().isForward() ? overlap.b2 : toLength - overlap.b1 - 1;
        this.rawScore = overlap.rawScore;
        this.score = overlap.score > 1.0 ? 1.0 : overlap.score;
    }

    public SequenceId getFromId() {
        return this.fromId;
    }

    public SequenceId getToId() {
        return this.toId;
    }

    public double getScore() {
        return this.score;
    }

    @Override
    public int compareTo(MatchResult o) {
        return -Double.compare(this.score, o.score);
    }

    public String toString() {
        return String.format("%s %s %.6f %.6f %d %d %d %d %d %d %d %d", this.getFromId().getHeader(), this.getToId().getHeader(), 1.0 - this.getScore(), this.rawScore, this.getFromId().isForward() ? 0 : 1, this.a1, this.a2, this.fromLength, this.getToId().isForward() ? 0 : 1, this.b1, this.b2, this.toLength);
    }
}

