/*
 * Decompiled with CFR 0.152.
 */
package bref;

import beagleutil.ChromIds;
import blbutil.Const;
import blbutil.Filter;
import blbutil.Utilities;
import ints.CharArray;
import ints.IntArray;
import ints.UnsignedByteArray;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import vcf.BasicMarker;
import vcf.Marker;
import vcf.RefGTRec;
import vcf.Samples;
import vcf.SeqCodedRefGTRec;

public final class Bref3Reader {
    static final String READ_ERR = "Error reading file";
    private static final String[][] SNV_PERMS = Bref3Reader.snvPerms();
    private final Filter<Marker> markerFilter;
    private final String program;
    private final Samples samples;
    private final int nHaps;
    private final byte[] byteBuffer;

    public Bref3Reader(DataInput dataInput, Filter<Marker> filter) {
        if (filter == null) {
            filter = Filter.acceptAllFilter();
        }
        String[] stringArray = null;
        String string = null;
        try {
            Bref3Reader.readAndCheckMagicNumber(dataInput);
            string = Bref3Reader.readString(dataInput);
            stringArray = Bref3Reader.readStringArray(dataInput);
        }
        catch (IOException iOException) {
            Utilities.exit(READ_ERR, iOException);
        }
        boolean[] blArray = new boolean[stringArray.length];
        Arrays.fill(blArray, true);
        this.program = string;
        this.samples = Samples.fromIds(stringArray, blArray);
        this.markerFilter = filter;
        this.nHaps = 2 * this.samples.size();
        this.byteBuffer = new byte[2 * this.nHaps];
    }

    Samples samples() {
        return this.samples;
    }

    String program() {
        return this.program;
    }

    Filter<Marker> markerFilter() {
        return this.markerFilter;
    }

    void readBlock(DataInput dataInput, Collection<RefGTRec> collection) {
        try {
            int n = Integer.MAX_VALUE;
            while (collection.isEmpty() && n != 0) {
                n = dataInput.readInt();
                if (n == 0) continue;
                this.readBlock(dataInput, collection, n);
            }
        }
        catch (IOException iOException) {
            Utilities.exit(READ_ERR, iOException);
        }
    }

    private void readBlock(DataInput dataInput, Collection<RefGTRec> collection, int n) throws IOException {
        assert (n != 0);
        String string = Bref3Reader.readString(dataInput);
        int n2 = ChromIds.instance().getIndex(string);
        int n3 = dataInput.readUnsignedShort();
        dataInput.readFully(this.byteBuffer);
        CharArray charArray = new CharArray(this.byteBuffer);
        for (int i = 0; i < n; ++i) {
            RefGTRec refGTRec;
            Marker marker = Bref3Reader.readMarker(dataInput, n2);
            byte by = dataInput.readByte();
            if (by == 0) {
                refGTRec = this.readSeqCodedRecord(dataInput, marker, this.samples, charArray, n3);
                if (!this.markerFilter.accept(marker)) continue;
                collection.add(refGTRec);
                continue;
            }
            if (by == 1) {
                refGTRec = Bref3Reader.readHapCodedRec(dataInput, marker, this.samples);
                if (!this.markerFilter.accept(marker)) continue;
                collection.add(refGTRec);
                continue;
            }
            Utilities.exit(READ_ERR);
        }
    }

    private RefGTRec readSeqCodedRecord(DataInput dataInput, Marker marker, Samples samples, IntArray intArray, int n) throws IOException {
        dataInput.readFully(this.byteBuffer, 0, n);
        UnsignedByteArray unsignedByteArray = new UnsignedByteArray(this.byteBuffer, 0, n);
        return new SeqCodedRefGTRec(marker, samples, intArray, unsignedByteArray);
    }

    private static void readAndCheckMagicNumber(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n != 2055763188) {
            String string = "ERROR: Unrecognized input file.  Was input file created " + Const.nl + "with a different version of the bref program?";
            Utilities.exit(string);
        }
    }

    private static Marker readMarker(DataInput dataInput, int n) throws IOException {
        int n2 = dataInput.readInt();
        String[] stringArray = Bref3Reader.readByteLengthStringArray(dataInput);
        byte by = dataInput.readByte();
        if (by == -1) {
            String[] stringArray2 = Bref3Reader.readStringArray(dataInput);
            int n3 = dataInput.readInt();
            return new BasicMarker(n, n2, stringArray, stringArray2, n3);
        }
        int n4 = 1 + (by & 3);
        int n5 = by >> 2;
        String[] stringArray3 = Bref3Reader.alleleString(n5, n4);
        int n6 = -1;
        return new BasicMarker(n, n2, stringArray, stringArray3, n6);
    }

    private static RefGTRec readHapCodedRec(DataInput dataInput, Marker marker, Samples samples) throws IOException {
        int n = marker.nAlleles();
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            nArrayArray[i] = Bref3Reader.readIntArray(dataInput);
        }
        return RefGTRec.hapCodedInstance(marker, samples, nArrayArray);
    }

    private static int[] readIntArray(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n == -1) {
            return null;
        }
        int[] nArray = new int[n];
        byte[] byArray = new byte[4 * n];
        dataInput.readFully(byArray);
        for (int i = 0; i < byArray.length; i += 4) {
            nArray[i / 4] = (byArray[i] & 0xFF) << 24 | (byArray[i + 1] & 0xFF) << 16 | (byArray[i + 2] & 0xFF) << 8 | byArray[i + 3] & 0xFF;
        }
        return nArray;
    }

    private static String readString(DataInput dataInput) throws IOException {
        return dataInput.readUTF();
    }

    private static String[] readByteLengthStringArray(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedByte();
        return Bref3Reader.readStringArray(dataInput, n);
    }

    static String[] readStringArray(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        return Bref3Reader.readStringArray(dataInput, n);
    }

    private static String[] readStringArray(DataInput dataInput, int n) throws IOException {
        if (n < 0) {
            return null;
        }
        if (n == 0) {
            return new String[0];
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = Bref3Reader.readString(dataInput);
        }
        return stringArray;
    }

    static String[][] snvPerms() {
        String[] stringArray = new String[]{"A", "C", "G", "T"};
        ArrayList<String[]> arrayList = new ArrayList<String[]>(24);
        Bref3Reader.permute(new String[0], stringArray, arrayList);
        return (String[][])arrayList.toArray((T[])new String[0][]);
    }

    private static void permute(String[] stringArray, String[] stringArray2, List<String[]> list) {
        if (stringArray2.length == 0) {
            list.add(stringArray);
        } else {
            for (int i = 0; i < stringArray2.length; ++i) {
                String[] stringArray3 = Arrays.copyOf(stringArray, stringArray.length + 1);
                stringArray3[stringArray.length] = stringArray2[i];
                String[] stringArray4 = new String[stringArray2.length - 1];
                if (i > 0) {
                    System.arraycopy(stringArray2, 0, stringArray4, 0, i);
                }
                if (i < stringArray4.length) {
                    System.arraycopy(stringArray2, i + 1, stringArray4, i, stringArray4.length - i);
                }
                Bref3Reader.permute(stringArray3, stringArray4, list);
            }
        }
    }

    private static String[] alleleString(int n, int n2) {
        return Arrays.copyOf(SNV_PERMS[n], n2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append(this.getClass().toString());
        return stringBuilder.toString();
    }
}

