/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.util;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.activemq.apollo.util.list.LinkedNode;
import org.apache.activemq.apollo.util.list.LinkedNodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashList<E> {
    private HashMap<E, HashListNode> m_index = new HashMap();
    private LinkedNodeList<HashListNode> m_list = new LinkedNodeList();

    public final boolean add(E o) {
        HashListNode n = this.m_index.get(o);
        if (n == null) {
            n = new HashListNode(o);
            this.m_index.put(o, n);
            return true;
        }
        return false;
    }

    public final boolean remove(E o) {
        HashListNode n = this.m_index.remove(o);
        if (n != null) {
            n.unlink();
            return true;
        }
        return false;
    }

    public final Object get(E o) {
        HashListNode n = this.m_index.get(o);
        if (n == null) {
            return null;
        }
        return n.elem;
    }

    public final int size() {
        return this.m_index.size();
    }

    public final boolean contains(Object o) {
        return this.m_index.containsKey(o);
    }

    public final Iterator<E> iterator() {
        return new Iterator<E>(){
            HashListNode next;
            {
                this.next = (HashListNode)HashList.this.m_list.getHead();
            }

            @Override
            public void remove() {
                HashListNode newNext = (HashListNode)this.next.getNext();
                HashList.this.m_index.remove(this.next.elem);
                this.next.unlink();
                this.next = newNext;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public E next() {
                try {
                    Object object = this.next.elem;
                    return object;
                }
                finally {
                    this.next = (HashListNode)this.next.getNext();
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HashListNode
    extends LinkedNode<HashListNode> {
        private final E elem;

        HashListNode(E elem) {
            this.elem = elem;
        }

        public int hashCode() {
            return this.elem.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.hashCode() != this.hashCode()) {
                return false;
            }
            HashListNode node = null;
            if (this.getClass().isInstance(o)) {
                node = (HashListNode)this.getClass().cast(o);
            }
            if (node == null) {
                return false;
            }
            return this.equals(node);
        }

        public boolean equals(HashListNode node) {
            return node.elem.equals(this.elem);
        }
    }
}

