/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.SortedSetFieldSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ByteArrayUtf8CharSequence;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TextField;
import org.apache.solr.search.QParser;
import org.apache.solr.uninverting.UninvertingReader;

public class SortableTextField
extends TextField {
    public static final int DEFAULT_MAX_CHARS_FOR_DOC_VALUES = 1024;
    private int maxCharsForDocValues = 1024;

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        String maxS = args.remove("maxCharsForDocValues");
        if (maxS != null) {
            this.maxCharsForDocValues = Integer.parseInt(maxS);
            if (this.maxCharsForDocValues <= 0) {
                this.maxCharsForDocValues = Integer.MAX_VALUE;
            }
        }
        if (!SortableTextField.on(this.falseProperties, 32768)) {
            this.properties |= 0x8000;
        }
        if (!SortableTextField.on(this.trueProperties, 131072)) {
            this.properties &= 0xFFFDFFFF;
        }
        super.init(schema, args);
    }

    @Override
    public List<IndexableField> createFields(SchemaField field, Object value) {
        boolean truncate;
        ByteArrayUtf8CharSequence utf8;
        IndexableField f = this.createField(field, value);
        if (!field.hasDocValues()) {
            return Collections.singletonList(f);
        }
        if (value instanceof ByteArrayUtf8CharSequence && (utf8 = (ByteArrayUtf8CharSequence)value).size() < this.maxCharsForDocValues) {
            BytesRef bytes = new BytesRef(utf8.getBuf(), utf8.offset(), utf8.size());
            return SortableTextField.getIndexableFields(field, f, bytes);
        }
        String origString = value.toString();
        int origLegth = origString.length();
        boolean bl = truncate = this.maxCharsForDocValues < origLegth;
        if (field.useDocValuesAsStored() && truncate) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not use field " + field.getName() + " with values longer then maxCharsForDocValues=" + this.maxCharsForDocValues + " when useDocValuesAsStored=true (length=" + origLegth + ")");
        }
        BytesRef bytes = new BytesRef(truncate ? origString.subSequence(0, this.maxCharsForDocValues) : origString);
        return SortableTextField.getIndexableFields(field, f, bytes);
    }

    private static List<IndexableField> getIndexableFields(SchemaField field, IndexableField f, BytesRef bytes) {
        SortedSetDocValuesField docval;
        Object object = docval = field.multiValued() ? new SortedSetDocValuesField(field.getName(), bytes) : new SortedDocValuesField(field.getName(), bytes);
        if (null == f) {
            return Collections.singletonList(docval);
        }
        return Arrays.asList(f, docval);
    }

    @Override
    protected void checkSupportsDocValues() {
    }

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        if (!field.hasDocValues()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not sort on this type of field when docValues=\"false\", field: " + field.getName());
        }
        return this.getStringSort(field, reverse);
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        if (!field.hasDocValues()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not use ValueSource on this type of field when docValues=\"false\", field: " + field.getName());
        }
        return super.getValueSource(field, parser);
    }

    @Override
    public FieldType.MultiValueSelector getDefaultMultiValueSelectorForSort(SchemaField field, boolean reverse) {
        return reverse ? FieldType.MultiValueSelector.MAX : FieldType.MultiValueSelector.MIN;
    }

    @Override
    public ValueSource getSingleValueSource(FieldType.MultiValueSelector choice, SchemaField field, QParser parser) {
        if (!field.multiValued()) {
            return this.getValueSource(field, parser);
        }
        if (!field.hasDocValues()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not select  '" + choice.toString() + "' value from multivalued field (" + field.getName() + ") when docValues=\"false\", field: " + field.getName());
        }
        SortedSetSelector.Type selectorType = choice.getSortedSetSelectorType();
        if (null == selectorType) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, choice.toString() + " is not a supported option for picking a single value from the multivalued field: " + field.getName() + " (type: " + this.getTypeName() + ")");
        }
        return new SortedSetFieldSource(field.getName(), selectorType);
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        return null;
    }

    @Override
    public boolean multiValuedFieldCache() {
        return false;
    }
}

