/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.thrift.ITransportFactory;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;

public class SSLTransportFactory
implements ITransportFactory {
    public static final int DEFAULT_MAX_FRAME_SIZE = 0xF00000;
    public static final String TRUSTSTORE = "enc.truststore";
    public static final String TRUSTSTORE_PASSWORD = "enc.truststore.password";
    public static final String KEYSTORE = "enc.keystore";
    public static final String KEYSTORE_PASSWORD = "enc.keystore.password";
    public static final String PROTOCOL = "enc.protocol";
    public static final String CIPHER_SUITES = "enc.cipher.suites";
    public static final int SOCKET_TIMEOUT = 0;
    private static final Set<String> SUPPORTED_OPTIONS = Sets.newHashSet((Object[])new String[]{"enc.truststore", "enc.truststore.password", "enc.keystore", "enc.keystore.password", "enc.protocol", "enc.cipher.suites"});
    private String truststore;
    private String truststorePassword;
    private String keystore;
    private String keystorePassword;
    private String protocol;
    private String[] cipherSuites;

    @Override
    public TTransport openTransport(String host, int port) throws Exception {
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters(this.protocol, this.cipherSuites);
        params.setTrustStore(this.truststore, this.truststorePassword);
        if (null != this.keystore) {
            params.setKeyStore(this.keystore, this.keystorePassword);
        }
        TSocket trans = TSSLTransportFactory.getClientSocket((String)host, (int)port, (int)0, (TSSLTransportFactory.TSSLTransportParameters)params);
        return new TFramedTransport((TTransport)trans, 0xF00000);
    }

    @Override
    public void setOptions(Map<String, String> options) {
        if (options.containsKey(TRUSTSTORE)) {
            this.truststore = options.get(TRUSTSTORE);
        }
        if (options.containsKey(TRUSTSTORE_PASSWORD)) {
            this.truststorePassword = options.get(TRUSTSTORE_PASSWORD);
        }
        if (options.containsKey(KEYSTORE)) {
            this.keystore = options.get(KEYSTORE);
        }
        if (options.containsKey(KEYSTORE_PASSWORD)) {
            this.keystorePassword = options.get(KEYSTORE_PASSWORD);
        }
        if (options.containsKey(PROTOCOL)) {
            this.protocol = options.get(PROTOCOL);
        }
        if (options.containsKey(CIPHER_SUITES)) {
            this.cipherSuites = options.get(CIPHER_SUITES).split(",");
        }
    }

    @Override
    public Set<String> supportedOptions() {
        return SUPPORTED_OPTIONS;
    }
}

