/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.util;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.cassandra.stress.util.SampleOfLongs;
import org.apache.cassandra.stress.util.TimingInterval;

public final class Timer {
    private ThreadLocalRandom rnd;
    private long sampleStartNanos;
    private final long[] sample;
    private int opCount;
    private long errorCount;
    private long partitionCount;
    private long rowCount;
    private long total;
    private long max;
    private long maxStart;
    private long upToDateAsOf;
    private long lastSnap = System.nanoTime();
    private volatile CountDownLatch reportRequest;
    volatile TimingInterval report;
    private volatile TimingInterval finalReport;

    public Timer(int sampleCount) {
        int powerOf2 = 32 - Integer.numberOfLeadingZeros(sampleCount - 1);
        this.sample = new long[1 << powerOf2];
    }

    public void init() {
        this.rnd = ThreadLocalRandom.current();
    }

    public void start() {
        this.sampleStartNanos = System.nanoTime();
    }

    private int p(int index) {
        return 1 + index / this.sample.length;
    }

    public boolean running() {
        return this.finalReport == null;
    }

    public void stop(long partitionCount, long rowCount, boolean error) {
        this.maybeReport();
        long now = System.nanoTime();
        long time = now - this.sampleStartNanos;
        if (this.rnd.nextInt(this.p(this.opCount)) == 0) {
            this.sample[this.index((int)this.opCount)] = time;
        }
        if (time > this.max) {
            this.maxStart = this.sampleStartNanos;
            this.max = time;
        }
        this.total += time;
        ++this.opCount;
        this.partitionCount += partitionCount;
        this.rowCount += rowCount;
        if (error) {
            ++this.errorCount;
        }
        this.upToDateAsOf = now;
    }

    private int index(int count) {
        return count & this.sample.length - 1;
    }

    private TimingInterval buildReport() {
        List<SampleOfLongs> sampleLatencies = Arrays.asList(new SampleOfLongs(Arrays.copyOf(this.sample, this.index(this.opCount)), this.p(this.opCount)), new SampleOfLongs(Arrays.copyOfRange(this.sample, this.index(this.opCount), Math.min(this.opCount, this.sample.length)), this.p(this.opCount) - 1));
        TimingInterval report = new TimingInterval(this.lastSnap, this.upToDateAsOf, this.max, this.maxStart, this.max, this.partitionCount, this.rowCount, this.total, this.opCount, this.errorCount, SampleOfLongs.merge(this.rnd, sampleLatencies, Integer.MAX_VALUE));
        this.opCount = 0;
        this.partitionCount = 0L;
        this.rowCount = 0L;
        this.total = 0L;
        this.max = 0L;
        this.errorCount = 0L;
        this.lastSnap = this.upToDateAsOf;
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeReport() {
        if (this.reportRequest != null) {
            Timer timer = this;
            synchronized (timer) {
                this.report = this.buildReport();
                this.reportRequest.countDown();
                this.reportRequest = null;
            }
        }
    }

    synchronized void requestReport(CountDownLatch signal) {
        if (this.finalReport != null) {
            this.report = this.finalReport;
            this.finalReport = new TimingInterval(0L);
            signal.countDown();
        } else {
            this.reportRequest = signal;
        }
    }

    public synchronized void close() {
        if (this.reportRequest == null) {
            this.finalReport = this.buildReport();
        } else {
            this.finalReport = new TimingInterval(0L);
            this.report = this.buildReport();
            this.reportRequest.countDown();
            this.reportRequest = null;
        }
    }
}

