/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations.predefined;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.cassandra.stress.Operation;
import org.apache.cassandra.stress.generate.Distribution;
import org.apache.cassandra.stress.generate.DistributionFactory;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.operations.predefined.PredefinedOperation;
import org.apache.cassandra.stress.settings.Command;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.ThriftClient;
import org.apache.cassandra.stress.util.Timer;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.Mutation;

public class ThriftCounterAdder
extends PredefinedOperation {
    final Distribution counteradd;

    public ThriftCounterAdder(DistributionFactory counteradd, Timer timer, PartitionGenerator generator, SeedManager seedManager, StressSettings settings) {
        super(Command.COUNTER_WRITE, timer, generator, seedManager, settings);
        this.counteradd = counteradd.get();
    }

    @Override
    public boolean isWrite() {
        return true;
    }

    @Override
    public void run(final ThriftClient client) throws IOException {
        ArrayList<CounterColumn> columns = new ArrayList<CounterColumn>();
        for (ByteBuffer byteBuffer : this.select().select(this.settings.columns.names)) {
            columns.add(new CounterColumn(byteBuffer, this.counteradd.next()));
        }
        ArrayList<Mutation> mutations = new ArrayList<Mutation>(columns.size());
        for (CounterColumn c : columns) {
            ColumnOrSuperColumn cosc = new ColumnOrSuperColumn().setCounter_column(c);
            mutations.add(new Mutation().setColumn_or_supercolumn(cosc));
        }
        Map map = Collections.singletonMap(this.type.table, mutations);
        ByteBuffer key = this.getKey();
        final Map record = Collections.singletonMap(key, map);
        this.timeWithRetry(new Operation.RunOp(){

            @Override
            public boolean run() throws Exception {
                client.batch_mutate(record, ThriftCounterAdder.this.settings.command.consistencyLevel);
                return true;
            }

            @Override
            public int partitionCount() {
                return 1;
            }

            @Override
            public int rowCount() {
                return 1;
            }
        });
    }
}

