/*
 * Decompiled with CFR 0.152.
 */
package io.github.eb4j.dsl;

import io.github.eb4j.dsl.DslDictionaryLoader;
import io.github.eb4j.dsl.DslResult;
import io.github.eb4j.dsl.data.DictionaryData;
import io.github.eb4j.dsl.data.DslDictionaryProperty;
import io.github.eb4j.dsl.data.DslEntry;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public abstract class DslDictionary {
    protected final DictionaryData<DslEntry> dictionaryData;
    protected final DslDictionaryProperty prop;
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static final Pattern DELIMITER_PATTERN = Pattern.compile("(\\r\\n|[\\n\\r\\u2028\\u2029\\u0085])+(\\s+)?");

    protected DslDictionary(DictionaryData<DslEntry> dictionaryData, DslDictionaryProperty prop) {
        this.dictionaryData = dictionaryData;
        this.prop = prop;
    }

    public DslResult lookup(String word) throws IOException {
        ArrayList<Map.Entry<String, String>> result = new ArrayList<Map.Entry<String, String>>();
        for (Map.Entry<String, DslEntry> en : this.dictionaryData.lookUp(word)) {
            result.add(new AbstractMap.SimpleImmutableEntry<String, String>(this.getHeadWord(en.getValue()), this.getArticle(en.getValue())));
        }
        return new DslResult(result);
    }

    public DslResult lookupPredictive(String word) throws IOException {
        ArrayList<Map.Entry<String, String>> result = new ArrayList<Map.Entry<String, String>>();
        for (Map.Entry<String, DslEntry> en : this.dictionaryData.lookUpPredictive(word)) {
            result.add(new AbstractMap.SimpleImmutableEntry<String, String>(this.getHeadWord(en.getValue()), this.getArticle(en.getValue())));
        }
        return new DslResult(result);
    }

    protected String getArticle(DslEntry entry) throws IOException {
        return this.trimArticle(this.getRecord(entry.getOffset(), entry.getSize()));
    }

    String getHeadWord(DslEntry entry) throws IOException {
        return this.trimArticle(this.getRecord(entry.getHeaderOffset(), entry.getHeaderSize()));
    }

    abstract String getRecord(long var1, int var3) throws IOException;

    protected String trimArticle(String article) {
        Matcher matcher = DELIMITER_PATTERN.matcher(article);
        return matcher.replaceAll(LINE_SEPARATOR).trim();
    }

    public String getDictionaryName() {
        return this.prop.getDictionaryName();
    }

    public String getIndexLanguage() {
        return this.prop.getIndexLanguage();
    }

    public String getContentLanguage() {
        return this.prop.getContentLanguage();
    }

    public static DslDictionary loadDictionary(@NotNull File file) throws IOException {
        return DslDictionary.loadDictionary(file.toPath());
    }

    public static DslDictionary loadDictionary(@NotNull Path path) throws IOException {
        return DslDictionaryLoader.load(path, null, true);
    }

    public static DslDictionary loadDictionary(@NotNull Path path, Path index) throws IOException {
        return DslDictionaryLoader.load(path, index, false);
    }

    public static DslDictionary loadDictionary(@NotNull Path path, Path index, boolean validateIndexAbspath) throws IOException {
        return DslDictionaryLoader.load(path, index, validateIndexAbspath);
    }
}

