/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.text.CharacterIterator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.stream.Stream;

public final class FontFallbackManager {
    private static final Set<String> FONT_BLACKLIST = new HashSet<String>(Arrays.asList("Apple Color Emoji", "Noto Color Emoji"));
    private static final Font FONT_UNAVAILABLE = new Font("", 0, 0);
    private static final Logger LOGGER = Logger.getLogger(FontFallbackManager.class.getName());
    private static final Font[] RECENT_FONTS = new Font[8];
    private static int lastFontIndex = 0;
    private static final Map<Integer, Font> CACHE = new ConcurrentHashMap<Integer, Font>();
    private static final FontRenderContext DEFAULT_CONTEXT = new FontRenderContext(null, false, false);
    private static final boolean CAN_DISPLAY_IS_BROKEN;

    private FontFallbackManager() {
    }

    public static int canDisplayUpTo(Font font, String str) {
        if (!CAN_DISPLAY_IS_BROKEN) {
            return font.canDisplayUpTo(str);
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (FontFallbackManager.canDisplay(font, c)) continue;
            if (!Character.isHighSurrogate(c)) {
                return i;
            }
            if (!FontFallbackManager.canDisplay(font, str.codePointAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int canDisplayUpTo(Font font, char[] text, int start, int limit) {
        if (!CAN_DISPLAY_IS_BROKEN) {
            return font.canDisplayUpTo(text, start, limit);
        }
        for (int i = start; i < limit; ++i) {
            char c = text[i];
            if (FontFallbackManager.canDisplay(font, c)) continue;
            if (!Character.isHighSurrogate(c)) {
                return i;
            }
            if (!FontFallbackManager.canDisplay(font, Character.codePointAt(text, i, limit))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int canDisplayUpTo(Font font, CharacterIterator iter, int start, int limit) {
        if (!CAN_DISPLAY_IS_BROKEN) {
            return font.canDisplayUpTo(iter, start, limit);
        }
        char c = iter.setIndex(start);
        for (int i = start; i < limit; ++i) {
            if (!FontFallbackManager.canDisplay(font, c)) {
                if (!Character.isHighSurrogate(c)) {
                    return i;
                }
                char c2 = iter.next();
                if (!Character.isLowSurrogate(c2)) {
                    return i;
                }
                if (!FontFallbackManager.canDisplay(font, Character.toCodePoint(c, c2))) {
                    return i;
                }
                ++i;
            }
            c = iter.next();
        }
        return -1;
    }

    public static boolean canDisplay(Font font, int codePoint) {
        if (!CAN_DISPLAY_IS_BROKEN) {
            return font.canDisplay(codePoint);
        }
        if (!Character.isValidCodePoint(codePoint)) {
            return false;
        }
        int glyphCode = font.createGlyphVector(DEFAULT_CONTEXT, Character.toChars(codePoint)).getGlyphCode(0);
        return 0 < glyphCode && glyphCode <= 0xFFFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font getCapableFont(int cp) {
        if (cp >= 65024 && cp <= 65039) {
            return null;
        }
        if (CACHE.isEmpty()) {
            Map<Integer, Font> map = CACHE;
            synchronized (map) {
                return FontFallbackManager.getCapableFontInternal(cp);
            }
        }
        return FontFallbackManager.getCapableFontInternal(cp);
    }

    private static Font getCapableFontInternal(int cp) {
        for (int i = 0; i < RECENT_FONTS.length; ++i) {
            int testIndex = (lastFontIndex - i + RECENT_FONTS.length) % RECENT_FONTS.length;
            Font font = RECENT_FONTS[testIndex];
            if (font == null || !FontFallbackManager.canDisplay(font, cp)) continue;
            lastFontIndex = testIndex;
            CACHE.put(cp, font);
            return font;
        }
        Font cachedFont = CACHE.get(cp);
        if (cachedFont == FONT_UNAVAILABLE) {
            return null;
        }
        if (cachedFont != null) {
            FontFallbackManager.addRecentFont(cachedFont);
            return cachedFont;
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] allFonts = ge.getAllFonts();
        LOGGER.fine(() -> String.format("Searching %d fonts for one supporting U+%h %s", allFonts.length, cp, String.valueOf(Character.toChars(cp))));
        long start = System.currentTimeMillis();
        Optional<Font> font = ((Stream)Stream.of(allFonts).parallel()).filter(f -> FontFallbackManager.canDisplay(f, cp) && !FONT_BLACKLIST.contains(f.getFamily())).findFirst();
        CACHE.put(cp, font.orElse(FONT_UNAVAILABLE));
        font.ifPresent(FontFallbackManager::addRecentFont);
        LOGGER.fine(() -> font.isPresent() ? String.format("Search found %s in %d ms", ((Font)font.get()).getFamily(), System.currentTimeMillis() - start) : String.format("Search failed to find a font; time: %d ms", System.currentTimeMillis() - start));
        return font.orElse(null);
    }

    private static void addRecentFont(Font font) {
        lastFontIndex = (lastFontIndex + 1) % RECENT_FONTS.length;
        FontFallbackManager.RECENT_FONTS[FontFallbackManager.lastFontIndex] = font;
    }

    static {
        Font dialog = new Font("Dialog", 0, 0);
        CAN_DISPLAY_IS_BROKEN = dialog.canDisplay(65536) && dialog.canDisplay(69246);
    }
}

