/*
* MyGoGrinder - a program to practice Go problems
* Copyright (c) 2004-2006 Tim Kington
*   timkington@users.sourceforge.net
* Portions Copyright (C) Ruediger Klehn (2015)
*   RuediRf@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

package GoGrinder;

import java.io.*;
import java.sql.Timestamp; // since Java 1.5
import java.util.Date;
import javax.swing.JOptionPane;
import GoGrinder.sgf.SGFLog;
import GoGrinder.Main;
import GoGrinder.GS;

/**
 *
 * @author  tkington
 * @author  Ruediger Klehn
 */
 // in the beginning of Main.Main: System.setProperty("sun.awt.exception.handler", "GoGrinder.ExceptionHandler");
public class ExceptionHandler {
    public ExceptionHandler(){/*NOTHING*/}
  
    static final String NL = Main.NEW_LINE;
    
    public void handle(Throwable t) {
        JOptionPane.showMessageDialog(null, Messages.getString("ex_occurred_see_grind_log") + "\n"
                                           + "\"" + Main.commonLogFilePath + "\"\n" 
                                           + t.getMessage()); //$NON-NLS-1$
        logSilent(t);
    }

            // We could check for length of log file:
            // if < 500 bytes: write the sys info into the log file 
            // if > 1 mby: shorten the too big file (with text in file "File shortened, DATE"; Message to user?)
            // + write the sysInfo to the top
    
    private static StringBuffer traceToStrBuff(StackTraceElement[] ste){
      StringBuffer returnStrBuff = new StringBuffer("");
      if (ste.length == 0) return new StringBuffer("Oh! - No stack trace" + NL); // can this happen?
      for (int i=0;i<ste.length;i++){
        returnStrBuff.append("" + ste[i] + NL);
      }
      return returnStrBuff;
    }
    
    public static void debug(Throwable t, String msg) { 
        logCommonProblem(t, msg);
    }

    public static void log(String msg){ // just logging something
      FileWReadWrite.writeFileAddStringUTF8(Main.commonLogFilePath, msg);
    }
    
    public static void logCommonProblem(Throwable t, String msg){
        StringBuffer logStrBuff = new StringBuffer("");
        logStrBuff.append(NL + dateTimeVers() + NL + "Common problem: " + NL + msg);
        logStrBuff.append(traceToStrBuff(t.getStackTrace()) + NL); // this could get the trace until "grinder" in the stackElement
        FileWReadWrite.writeFileAddStringBufferUTF8(Main.commonLogFilePath, logStrBuff);
        SGFLog.checkLogSize(Main.commonLogFilePath, GS.getCommonLogWarnFileSize());
    }
    
    public void logEditorProblem(Throwable t, String msg) { 
        if(msg != null) msg = "Problem with the Editor: " + NL + msg; //$NON-NLS-1$ //$NON-NLS-2$
        logCommonProblem(t, msg);
    }

    public static void logFileWriteProblem(Throwable t, String msg) { 
        if(msg != null) msg = "Problem while writing file: " + NL + msg; //$NON-NLS-1$ //$NON-NLS-2$
        logCommonProblem(t, msg);
    }

    public void logSilent(Throwable t) {
        logSilent(t, null);
    }
    
    public static void logSilent(String s){
        String logString = NL + dateTimeVers() + NL + "Common problem: " + NL + s;
        FileWReadWrite.writeFileAddStringUTF8(Main.commonLogFilePath, logString);
        SGFLog.checkLogSize(Main.commonLogFilePath, GS.getCommonLogWarnFileSize());
    }
    
    public void logSilent(Throwable t, String filename) { // this needs work: used for more than parsing
        StringBuffer logStrBuff = new StringBuffer("");
        logStrBuff.append(NL + dateTimeVers() + NL);
        if(filename != null)
          logStrBuff.append(Messages.getString("err_while_parsing_file") + ":" + NL + " " + filename);
        logStrBuff.append(traceToStrBuff(t.getStackTrace()) + NL); // this could get the trace until "grinder" in the stackElement
        FileWReadWrite.writeFileAddStringBufferUTF8(Main.commonLogFilePath, logStrBuff);
        SGFLog.checkLogSize(Main.commonLogFilePath, GS.getCommonLogWarnFileSize());
    }

  private static String dateTimeVers(){ // by import java.sql.Timestamp; // since Java 1.5
    return new Timestamp(new Date().getTime()).toString() + " (" + Main.NUM_VER_STRING + " build " + Params.getBuildCount() + "):" ; 
    // 2014-11-16 14:39:11.906 (2.1.0 build 274)
  }
}
