/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.suspendable;

import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.DefaultProtocolChain;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.suspendable.Suspendable;
import com.sun.grizzly.suspendable.SuspendableContextTask;
import com.sun.grizzly.suspendable.SuspendableHandler;
import com.sun.grizzly.suspendable.SuspendableMonitor;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.Utils;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuspendableFilter<T>
implements ProtocolFilter {
    private ConcurrentHashMap<byte[], SuspendableHandlerWrapper<? extends T>> suspendCandidates = new ConcurrentHashMap();
    protected ConcurrentHashMap<SelectionKey, KeyHandler> suspendedKeys = new ConcurrentHashMap();
    private static SuspendableMonitor suspendableMonitor = new SuspendableMonitor();
    private static Logger logger = Controller.logger();
    private Controller controller;
    private DefaultProtocolChain protocolChain;
    private int nextFilterPosition = 2;

    public SuspendableFilter() {
    }

    public SuspendableFilter(int nextFilterPosition) {
        this.nextFilterPosition = nextFilterPosition;
    }

    public Suspendable suspend(String match) {
        return this.suspend(match, 60000L, null, null);
    }

    public Suspendable suspend(String match, long expireTime, T attachement, SuspendableHandler<? extends T> sh) {
        return this.suspend(match, expireTime, attachement, sh, Suspend.AFTER);
    }

    public Suspendable suspend(String match, long expireTime, T attachement, SuspendableHandler<? extends T> sh, Suspend suspendWhen) {
        Suspendable s = new Suspendable(this);
        this.suspendCandidates.put(match.getBytes(), new SuspendableHandlerWrapper<T>(sh, attachement, expireTime, s, suspendWhen));
        return s;
    }

    @Override
    public boolean execute(Context ctx) throws IOException {
        WorkerThread wt = (WorkerThread)Thread.currentThread();
        ByteBuffer bb = wt.getByteBuffer();
        this.controller = ctx.getController();
        if (ctx.getProtocol() == Controller.Protocol.TCP) {
            ctx.getSelectionKey().attach(null);
        } else {
            wt.getAttachment().setTimeout(Long.MIN_VALUE);
        }
        if (this.protocolChain == null) {
            if (ctx.getProtocolChain() instanceof DefaultProtocolChain) {
                this.protocolChain = (DefaultProtocolChain)ctx.getProtocolChain();
            } else {
                throw new IllegalStateException("SuspendableFilter cannot be used without the DefaultProtocolChain");
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Trying to match " + ctx.getSelectionKey());
        }
        SuspendableHandlerWrapper<T> sh = null;
        Iterator iterator = this.suspendCandidates.keySet().iterator();
        byte[] matchBytes = null;
        while (iterator.hasNext()) {
            matchBytes = (byte[])iterator.next();
            if (Utils.findBytes((ByteBuffer)bb, (byte[])matchBytes) <= -1) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Find match: " + new String(matchBytes) + " Suspending: " + ctx.getSelectionKey());
            }
            sh = this.suspendCandidates.get(matchBytes);
            break;
        }
        if (sh != null) {
            KeyHandler kh = new KeyHandler();
            kh.setSuspendableHandler(sh);
            this.suspendedKeys.put(ctx.getSelectionKey(), kh);
            if (sh.getSuspendWhen() == Suspend.BEFORE) {
                this.suspend(ctx, true);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("-----> " + (Object)((Object)ctx.getKeyRegistrationState()));
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean postExecute(Context ctx) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("<----- " + (Object)((Object)ctx.getKeyRegistrationState()));
        }
        if (!this.suspendedKeys.isEmpty() && ctx.getKeyRegistrationState() == Context.KeyRegistrationState.REGISTER) {
            this.suspend(ctx, false);
            return false;
        }
        return true;
    }

    private void suspend(Context ctx, boolean incomingRequest) {
        block6: {
            try {
                SelectionKey key = ctx.getSelectionKey();
                KeyHandler kh = this.suspendedKeys.get(key);
                SuspendableHandlerWrapper<Object> sh = null;
                if (kh != null) {
                    sh = kh.getSuspendableHandler();
                } else {
                    kh = new KeyHandler();
                }
                if (kh != null && !incomingRequest && sh.getSuspendWhen() == Suspend.BEFORE) {
                    return;
                }
                if (sh == null) {
                    sh = new SuspendableHandlerWrapper<Object>(new SuspendableHandler(){

                        public void interupted(Object attachment) {
                        }

                        public void expired(Object attachment) {
                        }

                        public void resumed(Object attachment) {
                        }
                    }, null, 30000L, new Suspendable(this), Suspend.AFTER);
                }
                sh.setSuspendableFilter(this);
                ((SuspendableHandlerWrapper)sh).suspendable.setKey(key);
                sh.setSelectorHandler(ctx.getSelectorHandler());
                kh.setSuspendableHandler(sh);
                kh.setKey(key);
                WorkerThread workerThread = (WorkerThread)Thread.currentThread();
                ThreadAttachment attachment = workerThread.getAttachment();
                attachment.setMode(ThreadAttachment.Mode.STORE_ALL);
                kh.setThreadAttachment(workerThread.detach());
                ctx.setKeyRegistrationState(Context.KeyRegistrationState.NONE);
                suspendableMonitor.suspend(kh);
            }
            catch (Throwable ex) {
                if (!logger.isLoggable(Level.FINE)) break block6;
                logger.log(Level.FINE, "suspend", ex);
            }
        }
    }

    protected boolean resume(SelectionKey key) {
        KeyHandler kh = this.suspendedKeys.remove(key);
        if (kh.getSuspendableHandler() == null) {
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Resuming: " + kh.getSuspendableHandler());
        }
        kh.getSuspendableHandler().getSuspendableHandler().resumed(kh.getSuspendableHandler().getAttachment());
        if (kh.getSuspendableHandler().getSuspendWhen() == Suspend.AFTER) {
            kh.getSuspendableHandler().getSelectorHandler().register(key.channel(), 1);
        } else {
            Context ctx = this.controller.pollContext(key);
            this.controller.configureContext(ctx, kh.getSuspendableHandler().getSelectorHandler());
            ctx.execute(SuspendableContextTask.poll(this.protocolChain, kh.getThreadAttachment(), this.nextFilterPosition));
        }
        return true;
    }

    protected void cancel(SelectionKey key) {
        KeyHandler kh;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Cancelling: " + key);
        }
        if ((kh = this.suspendedKeys.remove(key)) == null) {
            return;
        }
        if (kh.getSuspendableHandler() == null) {
            return;
        }
        kh.getSuspendableHandler().getSuspendableHandler().interupted(kh.getSuspendableHandler().getAttachment());
        kh.getSuspendableHandler().getSelectorHandler().getSelectionKeyHandler().cancel(key);
        kh.setThreadAttachment(null);
    }

    protected class KeyHandler {
        private SelectionKey key;
        private SelectionKey foreignKey;
        private SuspendableHandlerWrapper handler;
        private ThreadAttachment threadAttachment;
        private long registrationTime = 0L;

        protected KeyHandler() {
        }

        protected SelectionKey getKey() {
            return this.key;
        }

        protected void setKey(SelectionKey key) {
            this.key = key;
        }

        protected SelectionKey getForeignKey() {
            return this.foreignKey;
        }

        protected void setForeignKey(SelectionKey foreignKey) {
            this.foreignKey = foreignKey;
        }

        protected SuspendableHandlerWrapper getSuspendableHandler() {
            return this.handler;
        }

        protected void setSuspendableHandler(SuspendableHandlerWrapper sh) {
            this.handler = sh;
        }

        protected ThreadAttachment getThreadAttachment() {
            return this.threadAttachment;
        }

        protected void setThreadAttachment(ThreadAttachment threadAttachment) {
            this.threadAttachment = threadAttachment;
        }

        protected long getRegistrationTime() {
            return this.registrationTime;
        }

        protected void setRegistrationTime(long registrationTime) {
            this.registrationTime = registrationTime;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SuspendableHandlerWrapper<A> {
        private SuspendableHandler<A> suspendableHandler;
        private A attachment;
        private long expireTime = 0L;
        private SuspendableFilter suspendableFilter;
        private Suspendable suspendable;
        private SelectorHandler selectorHandler;
        private Suspend suspendWhen;

        public SuspendableHandlerWrapper(SuspendableHandler<A> sh, A attachment, long expireTime, Suspendable suspendable, Suspend suspendWhen) {
            this.suspendableHandler = sh;
            this.attachment = attachment;
            this.expireTime = expireTime;
            this.suspendable = suspendable;
            this.suspendWhen = suspendWhen;
        }

        protected SuspendableHandler<A> getSuspendableHandler() {
            return this.suspendableHandler;
        }

        protected void setSuspendableHandler(SuspendableHandler<A> suspendableHandler) {
            this.suspendableHandler = suspendableHandler;
        }

        protected A getAttachment() {
            return this.attachment;
        }

        protected void setAttachment(A attachment) {
            this.attachment = attachment;
        }

        protected long getExpireTime() {
            return this.expireTime;
        }

        protected void setExpireTime(long expireTime) {
            this.expireTime = expireTime;
        }

        protected SuspendableFilter getSuspendableFilter() {
            return this.suspendableFilter;
        }

        protected void setSuspendableFilter(SuspendableFilter suspendableFilter) {
            this.suspendableFilter = suspendableFilter;
        }

        protected Suspendable getSuspendable() {
            return this.suspendable;
        }

        protected void setSuspendable(Suspendable suspendable) {
            this.suspendable = suspendable;
        }

        protected SelectorHandler getSelectorHandler() {
            return this.selectorHandler;
        }

        protected void setSelectorHandler(SelectorHandler selectorHandler) {
            this.selectorHandler = selectorHandler;
        }

        protected Suspend getSuspendWhen() {
            return this.suspendWhen;
        }

        protected void setSuspendWhen(Suspend suspendWhen) {
            this.suspendWhen = suspendWhen;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Suspend {
        BEFORE,
        AFTER;

    }
}

