/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.AbstractRefactoringTabbedDialog;

public class AddViewDialog
extends AbstractRefactoringTabbedDialog {
    private static final long serialVersionUID = -4707883598801686297L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AddViewDialog.class);
    private static final ILogger log = LoggerController.createLogger(AddViewDialog.class);
    private DefinitionTab _definitionTab;
    private PropertiesTab _propertiesTab;
    private boolean _defintionComplete = false;

    public AddViewDialog() {
        super(new Dimension(400, 250));
        this.init();
    }

    private void init() {
        this._propertiesTab = new PropertiesTab();
        this._definitionTab = new DefinitionTab();
        this.pane.addTab(i18n.TABBEDPANE_PROPERTIES_LABEL, this._propertiesTab);
        this.pane.addTab(i18n.TABBEDPANE_DEFINITION_LABEL, this._definitionTab);
        this.setAllButtonEnabled(false);
        this.setTitle(i18n.DIALOG_TITLE);
    }

    private void checkInputCompletion() {
        if (this._propertiesTab._viewNameField.getText().equals("") || !this._defintionComplete) {
            this.setAllButtonEnabled(false);
        } else {
            this.setAllButtonEnabled(true);
        }
    }

    public void enableCheckOptions(boolean enable) {
        this._propertiesTab.enableCheckOptions(enable);
    }

    public String getViewName() {
        return this._propertiesTab.getViewName();
    }

    public String getViewDefinition() {
        return this._definitionTab.getViewDefinition();
    }

    public String getCheckOption() {
        return this._propertiesTab.getCheckOption();
    }

    public static void main(String[] args) {
        AddViewDialog dialog = new AddViewDialog();
        dialog.enableCheckOptions(true);
        dialog.setVisible(true);
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    class DefinitionTab
    extends JPanel {
        private static final long serialVersionUID = 6541977721917288953L;
        JTextArea _definitionArea;

        public DefinitionTab() {
            this.init();
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            this._definitionArea = new JTextArea();
            this._definitionArea.setBorder(BorderFactory.createLineBorder(Color.black));
            this._definitionArea.setPreferredSize(AddViewDialog.this.mediumField);
            this._definitionArea.setLineWrap(true);
            this._definitionArea.setWrapStyleWord(true);
            this._definitionArea.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    DefinitionTab.this.checkQuery();
                }
            });
            JScrollPane scrollTablePane = new JScrollPane(this._definitionArea);
            this.add((Component)scrollTablePane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        }

        private void checkQuery() {
            String lowQuery = this._definitionArea.getText().toLowerCase();
            AddViewDialog.this._defintionComplete = lowQuery.contains("select") && lowQuery.contains("from");
            AddViewDialog.this.checkInputCompletion();
        }

        public String getViewDefinition() {
            return this._definitionArea.getText();
        }
    }

    private class PropertiesTab
    extends JPanel {
        private static final long serialVersionUID = 6552656160947599842L;
        private JTextField _viewNameField;
        private JCheckBox _checkOptionBox;
        private JRadioButton _localRadio;
        private JRadioButton _cascadeRadio;
        private ButtonGroup _radioGroup;

        public PropertiesTab() {
            this.init();
            this.enableCheckOptions(false);
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            JLabel nameLabel = AddViewDialog.this.getBorderedLabel(i18n.PROPERTIES_NAME_LABEL, AddViewDialog.this.emptyBorder);
            this._viewNameField = new JTextField();
            this._viewNameField.setPreferredSize(AddViewDialog.this.mediumField);
            this._viewNameField.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    AddViewDialog.this.checkInputCompletion();
                }
            });
            JLabel checkOptionLabel = AddViewDialog.this.getBorderedLabel(i18n.PROPERTIES_CHECK_OPTION_LABEL, AddViewDialog.this.emptyBorder);
            this._checkOptionBox = new JCheckBox();
            this._checkOptionBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    PropertiesTab.this.enableCheckOptionRadios(PropertiesTab.this._checkOptionBox.isSelected());
                }
            });
            this._localRadio = new JRadioButton(i18n.PROPERTIES_LOCAL);
            this._localRadio.setActionCommand(i18n.PROPERTIES_LOCAL);
            this._cascadeRadio = new JRadioButton(i18n.PROPERTIES_CASCADED);
            this._cascadeRadio.setActionCommand(i18n.PROPERTIES_CASCADED);
            this._cascadeRadio.setSelected(true);
            this._radioGroup = new ButtonGroup();
            this._radioGroup.add(this._localRadio);
            this._radioGroup.add(this._cascadeRadio);
            Insets boxesInsets = new Insets(5, 5, 0, 5);
            this.add((Component)nameLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 12, 2, boxesInsets, 0, 0));
            this.add((Component)this._viewNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, boxesInsets, 0, 0));
            this.add((Component)checkOptionLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 12, 2, boxesInsets, 0, 0));
            this.add((Component)this._checkOptionBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, boxesInsets, 0, 0));
            this.add((Component)this._localRadio, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, boxesInsets, 0, 0));
            boxesInsets.bottom = 5;
            this.add((Component)this._cascadeRadio, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, boxesInsets, 0, 0));
        }

        private void enableCheckOptionRadios(boolean enable) {
            this._localRadio.setEnabled(enable);
            this._cascadeRadio.setEnabled(enable);
        }

        public void enableCheckOptions(boolean enable) {
            this._checkOptionBox.setSelected(enable);
            this._checkOptionBox.setEnabled(enable);
            this.enableCheckOptionRadios(enable);
        }

        public String getViewName() {
            return this._viewNameField.getText();
        }

        public String getCheckOption() {
            if (!this._checkOptionBox.isSelected()) {
                return null;
            }
            return this._radioGroup.getSelection().getActionCommand();
        }
    }

    protected static interface i18n {
        public static final String DIALOG_TITLE = AddViewDialog.access$000().getString("AddViewDialog.title");
        public static final String TABBEDPANE_PROPERTIES_LABEL = AddViewDialog.access$000().getString("AddViewDialog.propertiesTabname");
        public static final String TABBEDPANE_DEFINITION_LABEL = AddViewDialog.access$000().getString("AddViewDialog.definitionTabName");
        public static final String PROPERTIES_NAME_LABEL = AddViewDialog.access$000().getString("AddViewDialog.propertiesNameLabel");
        public static final String PROPERTIES_CHECK_OPTION_LABEL = AddViewDialog.access$000().getString("AddViewDialog.checkOptionLabel");
        public static final String PROPERTIES_LOCAL = AddViewDialog.access$000().getString("AddViewDialog.checkOptionLocal");
        public static final String PROPERTIES_CASCADED = AddViewDialog.access$000().getString("AddViewDialog.checkOptionCascaded");
    }
}

