/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.MappingException;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.SecondPass;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Value;

public abstract class CollectionSecondPass
implements SecondPass {
    private static Log log = LogFactory.getLog((Class)CollectionSecondPass.class);
    Mappings mappings;
    Collection collection;
    private Map localInheritedMetas;

    public CollectionSecondPass(Mappings mappings, Collection collection, Map inheritedMetas) {
        this.collection = collection;
        this.mappings = mappings;
        this.localInheritedMetas = inheritedMetas;
    }

    public CollectionSecondPass(Mappings mappings, Collection collection) {
        this(mappings, collection, Collections.EMPTY_MAP);
    }

    public void doSecondPass(Map persistentClasses) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Second pass for collection: " + this.collection.getRole()));
        }
        this.secondPass(persistentClasses, this.localInheritedMetas);
        this.collection.createAllKeys();
        if (log.isDebugEnabled()) {
            String msg = "Mapped collection key: " + CollectionSecondPass.columns(this.collection.getKey());
            if (this.collection.isIndexed()) {
                msg = msg + ", index: " + CollectionSecondPass.columns(((IndexedCollection)this.collection).getIndex());
            }
            msg = this.collection.isOneToMany() ? msg + ", one-to-many: " + ((OneToMany)this.collection.getElement()).getReferencedEntityName() : msg + ", element: " + CollectionSecondPass.columns(this.collection.getElement());
            log.debug((Object)msg);
        }
    }

    public abstract void secondPass(Map var1, Map var2) throws MappingException;

    private static String columns(Value val) {
        StringBuffer columns = new StringBuffer();
        Iterator iter = val.getColumnIterator();
        while (iter.hasNext()) {
            columns.append(((Selectable)iter.next()).getText());
            if (!iter.hasNext()) continue;
            columns.append(", ");
        }
        return columns.toString();
    }
}

