/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.UseWhenStaticContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class SystemProperty
extends SystemFunctionCall
implements Callable {
    private NamespaceResolver nsContext;
    private StructuredQName propertyName;
    private transient boolean checked = false;
    private boolean isSchemaAware = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.checked) {
            return;
        }
        this.checked = true;
        super.checkArguments(visitor);
        if (this.argument[0] instanceof StringLiteral) {
            try {
                boolean is30 = visitor.getExecutable().isAllowXPath30();
                this.propertyName = StructuredQName.fromLexicalQName(((StringLiteral)this.argument[0]).getStringValue(), false, is30, visitor.getConfiguration().getNameChecker(), visitor.getStaticContext().getNamespaceResolver());
                return;
            }
            catch (XPathException e) {
                String code = e.getErrorCodeLocalPart();
                if (code != null && !code.equals("FOCA0002") && !code.equals("FONS0004")) return;
                e.setErrorCode("XTDE1390");
                throw e;
            }
        } else {
            this.nsContext = visitor.getStaticContext().getNamespaceResolver();
            this.isSchemaAware = visitor.getStaticContext().isSchemaAware();
        }
    }

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        if (this.propertyName != null && "http://www.w3.org/1999/XSL/Transform".equals(this.propertyName.getURI())) {
            if (this.propertyName.getLocalPart().equals("is-schema-aware")) {
                Configuration config;
                StaticContext env = visitor.getStaticContext();
                boolean aware = env instanceof UseWhenStaticContext ? "EE".equals((config = env.getConfiguration()).getEditionCode()) && config.isLicensedFeature(2) : env.isSchemaAware();
                return new StringLiteral(aware ? "yes" : "no");
            }
            return new StringLiteral(SystemProperty.getProperty("http://www.w3.org/1999/XSL/Transform", this.propertyName.getLocalPart(), visitor.getConfiguration()));
        }
        return this;
    }

    public StringValue evaluateItem(XPathContext context) throws XPathException {
        StructuredQName qName = this.propertyName;
        if (qName == null) {
            CharSequence name = this.argument[0].evaluateItem(context).getStringValueCS();
            try {
                boolean is30 = context.getController().getExecutable().isAllowXPath30();
                qName = StructuredQName.fromLexicalQName(name, false, is30, context.getConfiguration().getNameChecker(), this.nsContext);
                if ("http://www.w3.org/1999/XSL/Transform".equals(qName.getURI()) && "is-schema-aware".equals(qName.getLocalPart())) {
                    return new StringValue(this.isSchemaAware ? "yes" : "no");
                }
            }
            catch (XPathException err) {
                this.dynamicError("Invalid system property name. " + err.getMessage(), "XTDE1390", context);
                return null;
            }
        }
        return new StringValue(SystemProperty.getProperty(qName.getURI(), qName.getLocalPart(), context.getConfiguration()));
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        if (this.propertyName != null) {
            return this.evaluateItem(context);
        }
        StringValue name = (StringValue)arguments[0].head();
        try {
            boolean is30 = context.getController().getExecutable().isAllowXPath30();
            StructuredQName qName = StructuredQName.fromLexicalQName(name.getStringValue(), false, is30, context.getConfiguration().getNameChecker(), this.nsContext);
            if ("http://www.w3.org/1999/XSL/Transform".equals(qName.getURI()) && "is-schema-aware".equals(qName.getLocalPart())) {
                return new StringValue(this.isSchemaAware ? "yes" : "no");
            }
            return new StringValue(SystemProperty.getProperty(qName.getURI(), qName.getLocalPart(), context.getConfiguration()));
        }
        catch (XPathException err) {
            this.dynamicError("Invalid system property name. " + err.getMessage(), "XTDE1390", context);
            return null;
        }
    }

    public static String getProperty(String uri, String local, Configuration config) {
        if (uri.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (local.equals("version")) {
                return Version.getXSLVersionString();
            }
            if (local.equals("vendor")) {
                return Version.getProductVendor();
            }
            if (local.equals("vendor-url")) {
                return Version.getWebSiteAddress();
            }
            if (local.equals("product-name")) {
                return Version.getProductName();
            }
            if (local.equals("product-version")) {
                return Version.getProductVariantAndVersion(config);
            }
            if (local.equals("supports-serialization")) {
                return "yes";
            }
            if (local.equals("supports-backwards-compatibility")) {
                return "yes";
            }
            if (local.equals("supports-namespace-axis")) {
                return "yes";
            }
            return "";
        }
        if (uri.length() == 0 && config.getBooleanProperty("http://saxon.sf.net/feature/allow-external-functions")) {
            String val = System.getProperty(local);
            return val == null ? "" : val;
        }
        return "";
    }
}

