/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.config;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.IconTableCellRenderer;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTabProvider;
import com.jetbrains.plugins.webDeployment.ui.config.ExcludedPathsConfigurableTabProvider;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsDeployable;
import com.jetbrains.plugins.webDeployment.ui.config.mappings.MappingsConfigurableForm;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableSet;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExcludedPathsConfigurableForm {
    private static final LayeredIcon WARNING_FOLDER_ICON = new LayeredIcon(new Icon[]{AllIcons.Nodes.Folder, AllIcons.General.WarningDecorator});
    private static final Comparator<ExcludedPath> EXCLUDED_PATH_COMPARATOR = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.isLocal() != o2.isLocal()) {
            return o1.isLocal() ? 1 : -1;
        }
        return StringUtil.compare((String)o1.getPath(), (String)o2.getPath(), (boolean)false);
    };
    private JLabel myExcludedPathsLegendLabel;
    private JPanel myContentPane;
    private TableView<ExcludedPath> myExcludedPathsTable;
    private JLabel myMessageLabel;
    private JPanel myTablePanel;
    private final Project myProject;
    private final DeploymentConfigurableTabProvider.ServerStateProvider myServerStateProvider;
    private final UserDataHolder mySharedData;
    private final ProjectFileIndex myFileIndex;

    private void createUIComponents() {
        this.myExcludedPathsLegendLabel = ComponentPanelBuilder.createCommentComponent((String)"", (boolean)true);
        this.myExcludedPathsLegendLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.myExcludedPathsTable = new TableView();
        this.myExcludedPathsTable.getEmptyText().setText("No excluded paths added.").appendSecondaryText("Add excluded path", SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionPopupMenu popup = ExcludedPathsConfigurableForm.this.createAddingPopup("DeploymentExcludedPathsConfigurableForm.EmptyTableText");
                Dimension size = ExcludedPathsConfigurableForm.this.myExcludedPathsTable.getEmptyText().getPreferredSize();
                popup.getComponent().show((Component)ExcludedPathsConfigurableForm.this.myExcludedPathsTable, (ExcludedPathsConfigurableForm.this.myExcludedPathsTable.getWidth() - size.width) / 2, ExcludedPathsConfigurableForm.this.myExcludedPathsTable.getHeight() / 2 - size.height);
            }
        });
        this.myExcludedPathsTable.setModelAndUpdateColumns(new ListTableModel(new ColumnInfo[]{new PathIconColumnInfo(), new ExcludedPathColumnInfo()}));
        this.myExcludedPathsTable.setRowHeight(Math.max(PlatformIcons.FOLDER_ICON.getIconHeight() + 2, new JTextField().getPreferredSize().height));
        this.myExcludedPathsTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ExcludedPathsConfigurableForm.this.updateMessage();
            }
        });
        this.myTablePanel = ToolbarDecorator.createDecorator(this.myExcludedPathsTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ActionPopupMenu popupMenu = ExcludedPathsConfigurableForm.this.createAddingPopup("DeploymentExcludedPathsConfigurableForm.TableToolbarActions");
                RelativePoint relativePoint = (RelativePoint)ObjectUtils.notNull((Object)button.getPreferredPopupPoint());
                Point point = relativePoint.getPoint();
                popupMenu.getComponent().show(relativePoint.getComponent(), (int)point.getX(), (int)point.getY());
            }
        }).setRemoveAction(button -> {
            this.myExcludedPathsTable.stopEditing();
            int minSelectedIndex = this.myExcludedPathsTable.getSelectionModel().getMinSelectionIndex();
            if (minSelectedIndex == -1) {
                return;
            }
            int[] selectedIndices = this.myExcludedPathsTable.getSelectedRows();
            NavigableSet<Integer> modelIndices = new TreeSet();
            for (int selectedIndex : selectedIndices) {
                int modelIndex = this.myExcludedPathsTable.convertRowIndexToModel(selectedIndex);
                modelIndices.add(modelIndex);
            }
            modelIndices = modelIndices.descendingSet();
            ListTableModel model = this.myExcludedPathsTable.getListTableModel();
            for (Integer entry : modelIndices) {
                model.removeRow(entry.intValue());
            }
            int index = Math.min(minSelectedIndex, this.myExcludedPathsTable.getRowCount() - 1);
            if (index != -1) {
                this.myExcludedPathsTable.setRowSelectionInterval(index, index);
            }
        }).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                return ExcludedPathsConfigurableForm.this.myExcludedPathsTable.getSelectedRow() != -1;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/ui/config/ExcludedPathsConfigurableForm$3", "isEnabled"));
            }
        }).disableUpDownActions().createPanel();
    }

    public ExcludedPathsConfigurableForm(Project project, DeploymentConfigurableTabProvider.ServerStateProvider serverStateProvider, UserDataHolder sharedData) {
        this.myProject = project;
        this.myServerStateProvider = serverStateProvider;
        this.mySharedData = sharedData;
        this.$$$setupUI$$$();
        this.myFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myMessageLabel.setVisible(false);
    }

    @NotNull
    private ActionPopupMenu createAddingPopup(String actionPlace) {
        DefaultActionGroup actionGroup = new DefaultActionGroup(new AnAction[]{new AddPathAction(false), new AddPathAction(true)});
        ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu(actionPlace, (ActionGroup)actionGroup);
        if (actionPopupMenu == null) {
            ExcludedPathsConfigurableForm.$$$reportNull$$$0(0);
        }
        return actionPopupMenu;
    }

    private void updateMessage() {
        for (ExcludedPath path : this.myExcludedPathsTable.getItems()) {
            if (!path.isLocal()) continue;
            String pathName = path.getPath().replace(File.separatorChar, '/');
            if (!FileUtil.isAbsolute((String)pathName)) {
                this.myMessageLabel.setText(WDBundle.message("path.is.not.absolute", path.getPath()));
                this.myMessageLabel.setVisible(true);
                return;
            }
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(pathName);
            if (file == null) {
                this.myMessageLabel.setText(WDBundle.message("local.item.not.found", path.getPath()));
                this.myMessageLabel.setVisible(true);
                return;
            }
            if (this.myFileIndex.getContentRootForFile(file) != null) continue;
            this.myMessageLabel.setText(WDBundle.message("item.is.out.of.project", path.getPath()));
            this.myMessageLabel.setVisible(true);
            return;
        }
        this.myMessageLabel.setVisible(false);
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    public boolean isModified() {
        List<ExcludedPath> oldExcludedPaths;
        List currentExcludedPaths = this.myExcludedPathsTable.getItems();
        if (this.myExcludedPathsTable.getCellEditor() != null) {
            ExcludedPath original = (ExcludedPath)currentExcludedPaths.get(this.myExcludedPathsTable.getEditingRow());
            ExcludedPath override = original.clone();
            ((ExcludedPath)ObjectUtils.notNull((Object)override)).setPath((String)this.myExcludedPathsTable.getCellEditor().getCellEditorValue());
            if (!original.equals(override)) {
                return true;
            }
        }
        if ((oldExcludedPaths = this.getExcludedPaths()).size() != currentExcludedPaths.size()) {
            return true;
        }
        for (int i = 0; i < currentExcludedPaths.size(); ++i) {
            if (((ExcludedPath)currentExcludedPaths.get(i)).equals(oldExcludedPaths.get(i))) continue;
            return true;
        }
        return false;
    }

    public void apply() {
        this.applyTo(this.myServerStateProvider.getServerId());
    }

    public void applyTo(SettingsDeployable server) {
        this.applyTo(server.getId());
    }

    public void applyTo(String serverId) {
        this.myExcludedPathsTable.stopEditing();
        ExcludedPathsConfigurableTabProvider.putExcludedPaths(serverId, PublishConfig.cloneExcludedPaths(this.myExcludedPathsTable.getItems()), this.mySharedData);
    }

    public void reset() {
        this.myExcludedPathsTable.stopEditing();
        List<ExcludedPath> excludedPaths = this.getExcludedPaths();
        this.myExcludedPathsTable.getListTableModel().setItems(PublishConfig.cloneExcludedPaths(excludedPaths));
    }

    @NotNull
    private List<ExcludedPath> getExcludedPaths() {
        ArrayList<ExcludedPath> excludedPaths = ExcludedPathsConfigurableTabProvider.getExcludedPaths(this.mySharedData, this.myServerStateProvider.getServerId());
        ArrayList<ExcludedPath> arrayList = excludedPaths == null ? new ArrayList<ExcludedPath>() : excludedPaths;
        if (arrayList == null) {
            ExcludedPathsConfigurableForm.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        if (this.myExcludedPathsTable.getRowCount() > 1) {
            TableView<ExcludedPath> tableView = this.myExcludedPathsTable;
            if (tableView == null) {
                ExcludedPathsConfigurableForm.$$$reportNull$$$0(2);
            }
            return tableView;
        }
        SimpleColoredComponent simpleColoredComponent = this.myExcludedPathsTable.getEmptyText().getSecondaryComponent();
        if (simpleColoredComponent == null) {
            ExcludedPathsConfigurableForm.$$$reportNull$$$0(3);
        }
        return simpleColoredComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/plugins/webDeployment/ui/config/ExcludedPathsConfigurableForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddingPopup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedPaths";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMessageLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = this.myTablePanel;
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, new Dimension(-1, 100), null));
        JLabel jLabel2 = this.myExcludedPathsLegendLabel;
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/WDBundle").getString("excluded.settings.legend"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    class AddPathAction
    extends AnAction
    implements DumbAware {
        private final boolean isLocal;

        AddPathAction(boolean local) {
            this.isLocal = local;
            Presentation presentation = this.getTemplatePresentation();
            if (this.isLocal) {
                presentation.setText("Local path");
                presentation.setIcon(AllIcons.Nodes.Folder);
            } else {
                presentation.setText("Deployment path");
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddPathAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            if (!this.isLocal) {
                e.getPresentation().setIcon(((SettingsDeployable)ExcludedPathsConfigurableForm.this.myServerStateProvider.compute()).getIcon());
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddPathAction.$$$reportNull$$$0(1);
            }
            ExcludedPathsConfigurableForm.this.myExcludedPathsTable.stopEditing();
            ExcludedPath item = new ExcludedPath("", this.isLocal);
            int modelIndex = ExcludedPathsConfigurableForm.this.myExcludedPathsTable.getListTableModel().getRowCount();
            ExcludedPathsConfigurableForm.this.myExcludedPathsTable.getListTableModel().insertRow(modelIndex, (Object)item);
            int row = ExcludedPathsConfigurableForm.this.myExcludedPathsTable.convertRowIndexToView(modelIndex);
            ExcludedPathsConfigurableForm.this.myExcludedPathsTable.getSelectionModel().setSelectionInterval(row, row);
            ExcludedPathsConfigurableForm.this.myExcludedPathsTable.scrollRectToVisible(ExcludedPathsConfigurableForm.this.myExcludedPathsTable.getCellRect(row, 0, true));
            ExcludedPathsConfigurableForm.this.myExcludedPathsTable.editCellAt(row, 1);
            IdeFocusManager.getInstance((Project)ExcludedPathsConfigurableForm.this.myProject).requestFocus(ExcludedPathsConfigurableForm.this.myExcludedPathsTable.getEditorComponent(), true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/config/ExcludedPathsConfigurableForm$AddPathAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class PathIconColumnInfo
    extends ColumnInfo<ExcludedPath, ExcludedPath> {
        private PathIconColumnInfo() {
            super("");
        }

        public ExcludedPath valueOf(ExcludedPath item) {
            return item;
        }

        public int getWidth(JTable table) {
            return PlatformIcons.FOLDER_ICON.getIconWidth() + 2;
        }

        public TableCellRenderer getRenderer(ExcludedPath excludedPath) {
            return new IconTableCellRenderer<ExcludedPath>(){

                protected boolean isCenterAlignment() {
                    return true;
                }

                public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, selected, focus, row, column);
                    this.setText("");
                    return this;
                }

                @Nullable
                protected Icon getIcon(@NotNull ExcludedPath value, JTable table, int row) {
                    if (value == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!value.isLocal()) {
                        return ((SettingsDeployable)ExcludedPathsConfigurableForm.this.myServerStateProvider.compute()).getIcon();
                    }
                    String pathName = value.getPath().replace(File.separatorChar, '/');
                    boolean warn = false;
                    if (!FileUtil.isAbsolute((String)pathName)) {
                        warn = true;
                    } else {
                        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(pathName);
                        if (file == null || ExcludedPathsConfigurableForm.this.myFileIndex.getContentRootForFile(file) == null) {
                            warn = true;
                        }
                    }
                    return warn ? WARNING_FOLDER_ICON : PlatformIcons.FOLDER_ICON;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/plugins/webDeployment/ui/config/ExcludedPathsConfigurableForm$PathIconColumnInfo$1", "getIcon"));
                }
            };
        }
    }

    private class ExcludedPathColumnInfo
    extends ColumnInfo<ExcludedPath, String> {
        private ExcludedPathColumnInfo() {
            super("   ");
        }

        public String valueOf(ExcludedPath item) {
            return item.getPath();
        }

        public boolean isCellEditable(ExcludedPath item) {
            return true;
        }

        public void setValue(ExcludedPath item, String value) {
            item.setPath(value);
            ExcludedPathsConfigurableForm.this.updateMessage();
        }

        @Nullable
        public Comparator<ExcludedPath> getComparator() {
            return EXCLUDED_PATH_COMPARATOR;
        }

        public TableCellEditor getEditor(final ExcludedPath path) {
            return new AbstractTableCellEditor(){
                CellEditorComponentWithBrowseButton<JTextField> myComponent;

                public Object getCellEditorValue() {
                    return ((JTextField)this.myComponent.getChildComponent()).getText();
                }

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    if (path.isLocal()) {
                        TextFieldWithBrowseButton field = new TextFieldWithBrowseButton();
                        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor();
                        field.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(null, "", (ComponentWithBrowseButton)field, ExcludedPathsConfigurableForm.this.myProject, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

                            @Nullable
                            protected VirtualFile getInitialFile() {
                                int pos;
                                String directoryName = this.getComponentText();
                                if (directoryName.length() == 0) {
                                    return null;
                                }
                                if (!FileUtil.isAbsolute((String)(directoryName = directoryName.replace(File.separatorChar, '/')))) {
                                    return null;
                                }
                                VirtualFile path = LocalFileSystem.getInstance().findFileByPath(directoryName);
                                while (path == null && directoryName.length() > 0 && (pos = directoryName.lastIndexOf(47)) > 0) {
                                    directoryName = directoryName.substring(0, pos);
                                    path = LocalFileSystem.getInstance().findFileByPath(directoryName);
                                }
                                return path;
                            }
                        });
                        this.myComponent = new CellEditorComponentWithBrowseButton((ComponentWithBrowseButton)field, (TableCellEditor)((Object)this));
                    } else {
                        ActionListener listener = new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                MappingsConfigurableForm.chooseRemotePath((JTextField)myComponent.getChildComponent(), false, WDBundle.message("choose.remote.excluded.path.title", new Object[0]), ExcludedPathsConfigurableForm.this.myServerStateProvider, ExcludedPathsConfigurableForm.this.myProject, ExcludedPathsConfigurableForm.this.myContentPane);
                            }
                        };
                        this.myComponent = new CellEditorComponentWithBrowseButton((ComponentWithBrowseButton)new TextFieldWithBrowseButton.NoPathCompletion(listener), (TableCellEditor)((Object)this));
                    }
                    ((JTextField)this.myComponent.getChildComponent()).setText((String)value);
                    return this.myComponent;
                }
            };
        }
    }
}

