/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.DuplicatesForm;
import com.intellij.dupLocator.resultUI.DuplicatesView;
import com.intellij.dupLocator.resultUI.InvalidatedException;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.util.LabeledEditor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssFileType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CssDuplicatesView
extends DuplicatesView {
    private static final Logger LOGGER = Logger.getInstance(CssDuplicatesView.class);
    private final Project myProject;
    private final JPanel myPanel;
    private final MySide myLeft;
    private final MySide myRight;

    public CssDuplicatesView(@NotNull Project project) {
        if (project == null) {
            CssDuplicatesView.$$$reportNull$$$0(0);
        }
        this.myPanel = new JPanel(new BorderLayout());
        this.myLeft = new MySide();
        this.myRight = new MySide();
        this.myProject = project;
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        ActionManager manager = ActionManager.getInstance();
        actionGroup.add(manager.getAction("Find"));
        actionGroup.add(manager.getAction("$Copy"));
        ActionToolbar toolBar = manager.createActionToolbar("CssDuplicatesView", (ActionGroup)actionGroup, true);
        this.myPanel.add((Component)toolBar.getComponent(), "North");
        Splitter splitter = new Splitter(false);
        splitter.setFirstComponent(this.myLeft.getComponent());
        splitter.setSecondComponent(this.myRight.getComponent());
        this.myPanel.add((Component)splitter, "Center");
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            CssDuplicatesView.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    public void setContent(@NotNull CodeNode left, @NotNull CodeNode right) {
        if (left == null) {
            CssDuplicatesView.$$$reportNull$$$0(2);
        }
        if (right == null) {
            CssDuplicatesView.$$$reportNull$$$0(3);
        }
        this.myLeft.setCodeNode(left);
        this.myRight.setCodeNode(right);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/CssDuplicatesView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/CssDuplicatesView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MySide {
        private final LabeledEditor myEditorPanel = new LabeledEditor();

        private MySide() {
        }

        public void setCodeNode(@NotNull CodeNode node) {
            if (node == null) {
                MySide.$$$reportNull$$$0(0);
            }
            final EditorFactory factory = EditorFactory.getInstance();
            PsiElement firstElement = (PsiElement)ArrayUtil.getFirstElement((Object[])node.getFragment().getElements());
            if (firstElement != null) {
                Language language = (Language)ObjectUtils.notNull((Object)CssPsiUtil.getStylesheetLanguage((PsiElement)firstElement), (Object)CSSLanguage.INSTANCE);
                FileType fileType = this.getFileTypeByLanguage(language);
                DocumentContent content = node.getDiffContentIfValid();
                if (content != null) {
                    Document document = content.getDocument();
                    final EditorEx editor = (EditorEx)factory.createEditor(document, CssDuplicatesView.this.myProject, fileType, true);
                    Disposer.register((Disposable)CssDuplicatesView.this, (Disposable)new Disposable(){

                        public void dispose() {
                            factory.releaseEditor((Editor)editor);
                        }
                    });
                    this.myEditorPanel.setComponent(editor.getComponent(), (JComponent)new JLabel(node.getTitle(false).getText()));
                    this.highlightDuplicate(editor, node);
                }
            }
        }

        private FileType getFileTypeByLanguage(@NotNull Language language) {
            if (language == null) {
                MySide.$$$reportNull$$$0(1);
            }
            for (FileType fileType : FileTypeManager.getInstance().getRegisteredFileTypes()) {
                if (!(fileType instanceof LanguageFileType) || !language.is(((LanguageFileType)fileType).getLanguage())) continue;
                return fileType;
            }
            return CssFileType.INSTANCE;
        }

        private void highlightDuplicate(EditorEx editor, CodeNode node) {
            HighlightManager highlightManager = HighlightManager.getInstance((Project)CssDuplicatesView.this.myProject);
            try {
                RangeMarker marker = node.getRangeMarker();
                DuplicatesForm.highlightPsiFragment((Editor)editor, (PsiFragment)node.getFragment(), (HighlightManager)highlightManager, (int)marker.getStartOffset());
            }
            catch (InvalidatedException e) {
                LOGGER.debug("Invalid range marker", (Throwable)e);
            }
        }

        public JComponent getComponent() {
            return this.myEditorPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/dupLocator/CssDuplicatesView$MySide";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setCodeNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFileTypeByLanguage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

