/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.scope.NonProjectFilesScope;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.TextTransferable;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.DebuggerFramesList;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.datatransfer.Transferable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.FontUIResource;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerFramesList
extends DebuggerFramesList {
    private final Project myProject;
    private final Map<VirtualFile, Color> myFileColors;
    private static final DataKey<XDebuggerFramesList> FRAMES_LIST = DataKey.create((String)"FRAMES_LIST");
    private XStackFrame mySelectedFrame;

    private void copyStack() {
        List items = this.getModel().getItems();
        if (!items.isEmpty()) {
            StringBuilder plainBuf = new StringBuilder();
            TextTransferable.ColoredStringBuilder coloredTextContainer = new TextTransferable.ColoredStringBuilder();
            for (Object value : items) {
                ItemWithSeparatorAbove item;
                if (value instanceof ItemWithSeparatorAbove && (item = (ItemWithSeparatorAbove)value).hasSeparatorAbove()) {
                    String caption = " - " + StringUtil.notNullize((String)item.getCaptionAboveOf());
                    plainBuf.append(caption).append('\n');
                }
                if (value != null) {
                    if (value instanceof XStackFrame) {
                        ((XStackFrame)value).customizePresentation((ColoredTextContainer)coloredTextContainer);
                        coloredTextContainer.appendTo(plainBuf);
                    } else {
                        String text = value.toString();
                        plainBuf.append(text);
                    }
                }
                plainBuf.append('\n');
            }
            plainBuf.setLength(plainBuf.length() - 1);
            String plainText = plainBuf.toString();
            CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable("<html><body><pre>\n" + XmlStringUtil.escapeString((String)plainText) + "\n</pre></body></html>", plainText));
        }
    }

    public XDebuggerFramesList(@NotNull Project project) {
        if (project == null) {
            XDebuggerFramesList.$$$reportNull$$$0(0);
        }
        this.myFileColors = new HashMap<VirtualFile, Color>();
        this.myProject = project;
        this.doInit();
        this.setDataProvider(new DataProvider(){

            @Nullable
            public Object getData(@NotNull @NonNls String dataId) {
                if (dataId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (XDebuggerFramesList.this.mySelectedFrame != null) {
                    VirtualFile file2;
                    if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                        return XDebuggerFramesList.getFile(XDebuggerFramesList.this.mySelectedFrame);
                    }
                    if (CommonDataKeys.PSI_FILE.is(dataId) && (file2 = XDebuggerFramesList.getFile(XDebuggerFramesList.this.mySelectedFrame)) != null && file2.isValid()) {
                        return PsiManager.getInstance((Project)XDebuggerFramesList.this.myProject).findFile(file2);
                    }
                }
                if (FRAMES_LIST.is(dataId)) {
                    return XDebuggerFramesList.this;
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/xdebugger/impl/frame/XDebuggerFramesList$1", "getData"));
            }
        });
        Font font = this.getFont();
        if (font != null) {
            this.setFont(new FontUIResource(font.getName(), font.getStyle(), font.getSize()));
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.myFileColors.clear();
    }

    @Nullable
    private static VirtualFile getFile(XStackFrame frame) {
        XSourcePosition position = frame.getSourcePosition();
        return position != null ? position.getFile() : null;
    }

    @Override
    protected ListCellRenderer createListRenderer() {
        return new XDebuggerGroupedFrameListRenderer();
    }

    @Override
    protected void onFrameChanged(Object selectedValue) {
        if (this.mySelectedFrame != selectedValue) {
            SwingUtilities.invokeLater(() -> this.repaint());
            this.mySelectedFrame = selectedValue instanceof XStackFrame ? (XStackFrame)selectedValue : null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/frame/XDebuggerFramesList", "<init>"));
    }

    public static class CopyStackAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyStackAction.$$$reportNull$$$0(0);
            }
            XDebuggerFramesList framesList = (XDebuggerFramesList)((Object)e.getData(FRAMES_LIST));
            e.getPresentation().setEnabledAndVisible(framesList != null && ContainerUtil.getLastItem((List)framesList.getModel().getItems()) != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            XDebuggerFramesList framesList;
            if (e == null) {
                CopyStackAction.$$$reportNull$$$0(1);
            }
            if ((framesList = (XDebuggerFramesList)((Object)e.getData(FRAMES_LIST))) != null) {
                framesList.copyStack();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/xdebugger/impl/frame/XDebuggerFramesList$CopyStackAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ItemWithCustomBackgroundColor {
        @Nullable
        public Color getBackgroundColor();
    }

    public static interface ItemWithSeparatorAbove {
        public boolean hasSeparatorAbove();

        public String getCaptionAboveOf();
    }

    private class XDebuggerFrameListRenderer
    extends ColoredListCellRenderer {
        private final FileColorManager myColorsManager;

        XDebuggerFrameListRenderer(Project project) {
            if (project == null) {
                XDebuggerFrameListRenderer.$$$reportNull$$$0(0);
            }
            this.myColorsManager = FileColorManager.getInstance((Project)project);
        }

        protected void customizeCellRenderer(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
            Color c;
            if (list2 == null) {
                XDebuggerFrameListRenderer.$$$reportNull$$$0(1);
            }
            if (value == null) {
                this.append(XDebuggerBundle.message((String)"stack.frame.loading.text", (Object[])new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
                return;
            }
            if (value instanceof String) {
                this.append((String)value, SimpleTextAttributes.ERROR_ATTRIBUTES);
                return;
            }
            XStackFrame stackFrame = (XStackFrame)value;
            if (!selected && (c = this.getFrameBgColor(stackFrame)) != null) {
                this.setBackground(c);
            }
            stackFrame.customizePresentation((ColoredTextContainer)this);
        }

        Color getFrameBgColor(XStackFrame stackFrame) {
            if (stackFrame instanceof ItemWithCustomBackgroundColor) {
                return ((ItemWithCustomBackgroundColor)stackFrame).getBackgroundColor();
            }
            VirtualFile virtualFile = XDebuggerFramesList.getFile(stackFrame);
            if (virtualFile != null) {
                if (XDebuggerFramesList.this.myFileColors.containsKey(virtualFile)) {
                    return (Color)XDebuggerFramesList.this.myFileColors.get(virtualFile);
                }
                if (virtualFile.isValid()) {
                    Color color = this.myColorsManager.getFileColor(virtualFile);
                    XDebuggerFramesList.this.myFileColors.put(virtualFile, color);
                    return color;
                }
            } else {
                return this.myColorsManager.getScopeColor(NonProjectFilesScope.NAME);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/frame/XDebuggerFramesList$XDebuggerFrameListRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class XDebuggerGroupedFrameListRenderer
    extends GroupedItemsListRenderer {
        private final XDebuggerFrameListRenderer myOriginalRenderer;

        XDebuggerGroupedFrameListRenderer() {
            super(new ListItemDescriptorAdapter(){

                @Nullable
                public String getTextFor(Object value) {
                    return null;
                }

                @Nullable
                public String getCaptionAboveOf(Object value) {
                    return value instanceof ItemWithSeparatorAbove ? ((ItemWithSeparatorAbove)value).getCaptionAboveOf() : null;
                }

                public boolean hasSeparatorAboveOf(Object value) {
                    return value instanceof ItemWithSeparatorAbove && ((ItemWithSeparatorAbove)value).hasSeparatorAbove();
                }
            });
            this.myOriginalRenderer = new XDebuggerFrameListRenderer(XDebuggerFramesList.this.myProject);
            this.mySeparatorComponent.setCaptionCentered(false);
        }

        @Override
        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (this.myDescriptor.hasSeparatorAboveOf(value)) {
                Component component = super.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
                ((XDebuggerFrameListRenderer)((Object)this.myComponent)).getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
                return component;
            }
            return this.myOriginalRenderer.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
        }

        @Override
        protected JComponent createItemComponent() {
            this.createLabel();
            return new XDebuggerFrameListRenderer(XDebuggerFramesList.this.myProject);
        }
    }
}

