/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.surroundWith.inHtml;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.jetbrains.php.surroundWith.inHtml.PhpInHtmlSurrounderBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInHtmlSurroundDescriptor
implements SurroundDescriptor {
    public static final Surrounder IF_SURROUNDER = PhpInHtmlSurrounderBase.createSurrounder("<? if(): >...<? endif ?>", "<?php if($caret):?>\n#BODY#\n<?php endif ?>");
    public static final Surrounder WHILE_SURROUNDER = PhpInHtmlSurrounderBase.createSurrounder("<? while(): >...<? endwhile ?>", "<?php while($caret): ?>\n#BODY#\n<?php endwhile ?>");
    public static final Surrounder FOR_SURROUNDER = PhpInHtmlSurrounderBase.createSurrounder("<? for(): >...<? endfor ?>", "<?php for($caret;;): ?>\n#BODY#\n<?php endfor ?>");
    private static final Surrounder[] CONTROL_STATEMENT_SURROUNDERS = new Surrounder[]{IF_SURROUNDER, WHILE_SURROUNDER, FOR_SURROUNDER};

    @NotNull
    public PsiElement[] getElementsToSurround(PsiFile file, int startOffset, int endOffset) {
        FileViewProvider viewProvider = file.getViewProvider();
        TextRange adjustedRange = PhpInHtmlSurroundDescriptor.narrowDown(viewProvider, startOffset, endOffset);
        if (adjustedRange != null) {
            PsiElement startElement = viewProvider.findElementAt(adjustedRange.getStartOffset(), (Language)HTMLLanguage.INSTANCE);
            PsiElement endElement = viewProvider.findElementAt(adjustedRange.getEndOffset() - 1, (Language)HTMLLanguage.INSTANCE);
            if (startElement != null && endElement != null) {
                startElement = PhpInHtmlSurroundDescriptor.findSuitableParent(startElement);
                endElement = PhpInHtmlSurroundDescriptor.findSuitableParent(endElement);
                if (startElement.getParent() == endElement.getParent()) {
                    PsiElement[] psiElementArray = new PsiElement[]{startElement, endElement};
                    if (psiElementArray == null) {
                        PhpInHtmlSurroundDescriptor.$$$reportNull$$$0(0);
                    }
                    return psiElementArray;
                }
                PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement);
                PsiElement[] psiElementArray = new PsiElement[]{commonParent};
                if (psiElementArray == null) {
                    PhpInHtmlSurroundDescriptor.$$$reportNull$$$0(1);
                }
                return psiElementArray;
            }
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            PhpInHtmlSurroundDescriptor.$$$reportNull$$$0(2);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Nullable
    private static TextRange narrowDown(@NotNull FileViewProvider viewProvider, int startOffset, int endOffset) {
        PsiElement endElement;
        if (viewProvider == null) {
            PhpInHtmlSurroundDescriptor.$$$reportNull$$$0(3);
        }
        int newStartOffset = startOffset;
        int newEndOffset = endOffset;
        PsiElement startElement = viewProvider.findElementAt(startOffset, (Language)HTMLLanguage.INSTANCE);
        if (startElement instanceof PsiWhiteSpace) {
            newStartOffset = startElement.getTextRange().getEndOffset();
        }
        if ((endElement = viewProvider.findElementAt(endOffset - 1, (Language)HTMLLanguage.INSTANCE)) instanceof PsiWhiteSpace) {
            newEndOffset = endElement.getTextRange().getStartOffset();
        }
        if (newStartOffset < newEndOffset) {
            return new TextRange(newStartOffset, newEndOffset);
        }
        return null;
    }

    @NotNull
    private static PsiElement findSuitableParent(@NotNull PsiElement element) {
        if (element == null) {
            PhpInHtmlSurroundDescriptor.$$$reportNull$$$0(4);
        }
        for (PsiElement curr = element; curr != null && !(curr instanceof PsiFile); curr = curr.getParent()) {
            IElementType currType = curr.getNode().getElementType();
            if (currType != XmlElementType.HTML_TAG && currType != XmlElementType.XML_TEXT && currType != XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && curr.getLanguage().isKindOf((Language)XMLLanguage.INSTANCE)) continue;
            PsiElement psiElement = curr;
            if (psiElement == null) {
                PhpInHtmlSurroundDescriptor.$$$reportNull$$$0(5);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            PhpInHtmlSurroundDescriptor.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    @NotNull
    public Surrounder[] getSurrounders() {
        if (CONTROL_STATEMENT_SURROUNDERS == null) {
            PhpInHtmlSurroundDescriptor.$$$reportNull$$$0(7);
        }
        return CONTROL_STATEMENT_SURROUNDERS;
    }

    public boolean isExclusive() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/surroundWith/inHtml/PhpInHtmlSurroundDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToSurround";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/surroundWith/inHtml/PhpInHtmlSurroundDescriptor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuitableParent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurrounders";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "narrowDown";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

