/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.statistics;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInterpreterVersionUsagesCollector
extends ProjectUsagesCollector {
    private static final String GROUP_ID = "statistics.php.interpreter.version";
    private static final String NOT_VALID = "not-valid";
    private static final String NOT_INSTALLED = "not-installed";

    @NotNull
    public String getGroupId() {
        if (GROUP_ID == null) {
            PhpInterpreterVersionUsagesCollector.$$$reportNull$$$0(0);
        }
        return GROUP_ID;
    }

    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        String version;
        if (project == null) {
            PhpInterpreterVersionUsagesCollector.$$$reportNull$$$0(1);
        }
        if (!project.isDefault() && StringUtil.isNotEmpty((String)(version = this.getInterpreterVersion(project)))) {
            Set set = ContainerUtil.set((Object[])new UsageDescriptor[]{new UsageDescriptor(version, 1)});
            if (set == null) {
                PhpInterpreterVersionUsagesCollector.$$$reportNull$$$0(2);
            }
            return set;
        }
        Set<UsageDescriptor> set = Collections.emptySet();
        if (set == null) {
            PhpInterpreterVersionUsagesCollector.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Nullable
    public String getInterpreterVersion(@NotNull Project project) {
        PhpProjectConfigurationFacade facade;
        if (project == null) {
            PhpInterpreterVersionUsagesCollector.$$$reportNull$$$0(4);
        }
        if ((facade = PhpProjectConfigurationFacade.getInstance(project)) != null) {
            PhpInterpreter interpreter = facade.getInterpreter();
            if (interpreter == null) {
                return NOT_INSTALLED;
            }
            PhpInterpretersPhpInfoCacheImpl phpInfoCache = PhpInterpretersPhpInfoCacheImpl.getInstance(project);
            if (phpInfoCache != null) {
                PhpInfo phpInfo = phpInfoCache.getPhpInfo(interpreter.getName());
                PhpLanguageLevel version = phpInfo != null ? PhpLanguageLevel.parse(phpInfo.getShortVersion()) : null;
                return version != null ? version.getPresentableName() : NOT_VALID;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/statistics/PhpInterpreterVersionUsagesCollector";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/statistics/PhpInterpreterVersionUsagesCollector";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreterVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

