/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.httpRequest;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.run.PhpRunConfiguration;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.run.httpRequest.PhpHttpRequestRunConfigurationEditor;
import com.jetbrains.php.run.httpRequest.PhpHttpRequestSettings;
import com.jetbrains.php.util.PhpUrlUtil;
import com.jetbrains.php.util.QueryString;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpHttpRequestRunConfiguration
extends PhpRunConfiguration<Settings> {
    public PhpHttpRequestRunConfiguration(@NotNull Project project, ConfigurationFactory factory, String name) {
        if (project == null) {
            PhpHttpRequestRunConfiguration.$$$reportNull$$$0(0);
        }
        super(project, factory, name);
    }

    @Override
    @NotNull
    protected Settings createSettings() {
        Settings settings = new Settings();
        if (settings == null) {
            PhpHttpRequestRunConfiguration.$$$reportNull$$$0(1);
        }
        return settings;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        PhpHttpRequestRunConfigurationEditor phpHttpRequestRunConfigurationEditor = new PhpHttpRequestRunConfigurationEditor(this.getProject());
        if (phpHttpRequestRunConfigurationEditor == null) {
            PhpHttpRequestRunConfiguration.$$$reportNull$$$0(2);
        }
        return phpHttpRequestRunConfigurationEditor;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            PhpHttpRequestRunConfiguration.$$$reportNull$$$0(3);
        }
        if (env == null) {
            PhpHttpRequestRunConfiguration.$$$reportNull$$$0(4);
        }
        try {
            this.checkConfiguration();
        }
        catch (RuntimeConfigurationWarning runtimeConfigurationWarning) {
        }
        catch (RuntimeConfigurationException e) {
            throw new ExecutionException(e.getMessage());
        }
        return new RunProfileState(){

            public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
                if (runner == null) {
                    1.$$$reportNull$$$0(0);
                }
                DefaultDebugProcessHandler processHandler = new DefaultDebugProcessHandler();
                ConsoleViewImpl console = new ConsoleViewImpl(PhpHttpRequestRunConfiguration.this.getProject(), true);
                return PhpHttpRequestRunConfiguration.this.doExecute((ProcessHandler)processHandler, console, QueryString.empty());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/jetbrains/php/run/httpRequest/PhpHttpRequestRunConfiguration$1", "execute"));
            }
        };
    }

    @NotNull
    public ExecutionResult doExecute(@NotNull ProcessHandler processHandler, @NotNull ConsoleViewImpl console, @NotNull QueryString queryString) {
        if (processHandler == null) {
            PhpHttpRequestRunConfiguration.$$$reportNull$$$0(5);
        }
        if (console == null) {
            PhpHttpRequestRunConfiguration.$$$reportNull$$$0(6);
        }
        if (queryString == null) {
            PhpHttpRequestRunConfiguration.$$$reportNull$$$0(7);
        }
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            HttpRequestBase httpMethod = this.createHttpMethod(queryString);
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.lambda$doExecute$0((HttpClient)httpClient, httpMethod, processHandler, console));
        }
        catch (ConfigurationException e) {
            PhpHttpRequestRunConfiguration.showError(processHandler, PhpBundle.message("PhpHttpRequestRunConfiguration.error.server.configuration", e.getMessage()));
        }
        DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult((ExecutionConsole)console, processHandler);
        if (defaultExecutionResult == null) {
            PhpHttpRequestRunConfiguration.$$$reportNull$$$0(8);
        }
        return defaultExecutionResult;
    }

    @NotNull
    private static FileType getOutputFileType(@NotNull HttpResponse response) {
        String value;
        if (response == null) {
            PhpHttpRequestRunConfiguration.$$$reportNull$$$0(9);
        }
        ContentType contentType = ContentType.getOrDefault((HttpEntity)response.getEntity());
        LanguageFileType fileType = FileTypes.PLAIN_TEXT;
        if (contentType != null && StringUtil.isNotEmpty((String)(value = contentType.getMimeType())) && value.startsWith("text/")) {
            String type = value.substring(5);
            if (type.startsWith("html")) {
                fileType = HtmlFileType.INSTANCE;
            } else if (type.startsWith("xml")) {
                fileType = XmlFileType.INSTANCE;
            }
        }
        LanguageFileType languageFileType = fileType;
        if (languageFileType == null) {
            PhpHttpRequestRunConfiguration.$$$reportNull$$$0(10);
        }
        return languageFileType;
    }

    private static void showError(@NotNull ProcessHandler processHandler, @NotNull HttpRequestBase httpMethod, @Nullable String message) {
        if (processHandler == null) {
            PhpHttpRequestRunConfiguration.$$$reportNull$$$0(11);
        }
        if (httpMethod == null) {
            PhpHttpRequestRunConfiguration.$$$reportNull$$$0(12);
        }
        String uri = httpMethod.getURI().toString();
        PhpHttpRequestRunConfiguration.showError(processHandler, StringUtil.isEmpty((String)message) ? PhpBundle.message("error.cannot.connect.to.0", uri) : PhpBundle.message("error.cannot.connect.to.0.1", uri, message));
    }

    private static void showError(@NotNull ProcessHandler processHandler, @NotNull String message) {
        if (processHandler == null) {
            PhpHttpRequestRunConfiguration.$$$reportNull$$$0(13);
        }
        if (message == null) {
            PhpHttpRequestRunConfiguration.$$$reportNull$$$0(14);
        }
        processHandler.notifyTextAvailable(message, ProcessOutputTypes.STDERR);
    }

    @NotNull
    private HttpRequestBase createHttpMethod(@NotNull QueryString queryString) throws ConfigurationException {
        HttpGet httpGet;
        if (queryString == null) {
            PhpHttpRequestRunConfiguration.$$$reportNull$$$0(15);
        }
        Settings settings = (Settings)this.getSettings();
        PhpServer server = PhpProjectConfigurationFacade.getInstance(this.getProject()).findServer(settings.getServerName());
        if (server == null) {
            throw new ConfigurationException(PhpBundle.message("PhpHttpRequestRunConfiguration.error.server.is.not.specified", settings.getServerName()));
        }
        String host = server.getHost();
        if (StringUtil.isEmpty((String)host)) {
            throw new ConfigurationException(PhpBundle.message("PhpHttpRequestRunConfiguration.error.host.is.not.specified", settings.getServerName()));
        }
        String url = PhpDebugUtil.createUrl(host, server.getPort(), "http", settings.getUrl());
        QueryString customQueryString = QueryString.parse(settings.getHttpRequestSettings().getQueryString());
        String query = PhpUrlUtil.joinQueryString(customQueryString.toString(), queryString);
        if (StringUtil.isNotEmpty((String)query)) {
            url = url + (url.contains("?") ? "&" : "?") + query;
        }
        try {
            HttpGet httpMethod;
            PhpHttpRequestSettings.RequestMethod requestMethod = settings.getHttpRequestSettings().getRequestMethod();
            if (requestMethod == PhpHttpRequestSettings.RequestMethod.POST) {
                HttpPost postMethod = new HttpPost(url);
                String body = settings.getHttpRequestSettings().getRequestBody();
                if (settings.getHttpRequestSettings().getRequestBodyFormat() == PhpHttpRequestSettings.RequestBodyFormat.TEXT) {
                    postMethod.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
                } else {
                    ArrayList<BasicNameValuePair> entities = new ArrayList<BasicNameValuePair>();
                    Map<String, String> parameters = PhpUrlUtil.parseParameters(body);
                    for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                        entities.add(new BasicNameValuePair(parameter.getKey(), parameter.getValue()));
                    }
                    postMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(entities, Charset.defaultCharset()));
                }
                httpMethod = postMethod;
            } else {
                httpMethod = new HttpGet(url);
            }
            httpGet = httpMethod;
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(PhpBundle.message("PhpHttpRequestRunConfiguration.error.url.is.not.specified", settings.getServerName()));
        }
        if (httpGet == null) {
            PhpHttpRequestRunConfiguration.$$$reportNull$$$0(16);
        }
        return httpGet;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        Settings settings = (Settings)this.getSettings();
        String serverName = settings.getServerName();
        PhpServer server = PhpRunUtil.checkServerConfigurationByServerName(this.getProject(), serverName);
        String startUrl = settings.getUrl();
        String host = server.getHost();
        if (StringUtil.isEmpty((String)host)) {
            throw new RuntimeConfigurationWarning(PhpBundle.message("PhpHttpRequestRunConfiguration.error.host.is.not.specified", settings.getServerName()));
        }
        String fullStartUrl = PhpDebugUtil.createUrl(host, server.getPort(), "http", startUrl);
        try {
            new HttpGet(fullStartUrl);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeConfigurationWarning(PhpBundle.message("PhpWebAppRunConfigurationEditor.malformed.start.url", fullStartUrl));
        }
        catch (IllegalStateException e) {
            throw new RuntimeConfigurationWarning(e.getMessage());
        }
        String queryString = settings.getHttpRequestSettings().getQueryString();
        if (queryString.startsWith("?")) {
            throw new RuntimeConfigurationError("Query string cannot start with ?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$doExecute$0(HttpClient httpClient, HttpRequestBase httpMethod, @NotNull ProcessHandler processHandler, @NotNull ConsoleViewImpl console) {
        if (processHandler == null) {
            PhpHttpRequestRunConfiguration.$$$reportNull$$$0(17);
        }
        if (console == null) {
            PhpHttpRequestRunConfiguration.$$$reportNull$$$0(18);
        }
        try {
            StatusLine statusLine;
            InputStream body;
            HttpEntity entity;
            HttpResponse response;
            block14: {
                response = httpClient.execute((HttpUriRequest)httpMethod);
                entity = response.getEntity();
                InputStream inputStream = body = entity == null ? null : entity.getContent();
                if (body != null) break block14;
                PhpHttpRequestRunConfiguration.showError(processHandler, httpMethod, PhpBundle.message("PhpHttpRequestRunConfiguration.error.fetch.result", new Object[0]));
                return;
            }
            long contentLength = entity.getContentLength();
            if (contentLength == 0L && (statusLine = response.getStatusLine()).getStatusCode() != 200) {
                PhpHttpRequestRunConfiguration.showError(processHandler, httpMethod, statusLine.getReasonPhrase());
                return;
            }
            try {
                int len;
                String defaultEncoding = EncodingProjectManager.getInstance((Project)this.getProject()).getDefaultCharsetName();
                InputStreamReader reader = new InputStreamReader(body, defaultEncoding);
                char[] b = new char[4096];
                StringBuilder output = new StringBuilder();
                while ((len = reader.read(b)) != -1) {
                    output.append(new String(b, 0, len));
                }
                FileType fileType = PhpHttpRequestRunConfiguration.getOutputFileType(response);
                ConsoleViewUtil.printAsFileType((ConsoleView)console, (String)output.toString(), (FileType)fileType);
            }
            catch (IOException e) {
                PhpHttpRequestRunConfiguration.showError(processHandler, httpMethod, e.getMessage());
            }
        }
        catch (Exception e) {
            PhpHttpRequestRunConfiguration.showError(processHandler, httpMethod, e.getMessage());
        }
        finally {
            httpMethod.releaseConnection();
            processHandler.detachProcess();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/run/httpRequest/PhpHttpRequestRunConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 5: 
            case 11: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryString";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "httpMethod";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/run/httpRequest/PhpHttpRequestRunConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doExecute";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputFileType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createHttpMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: 
            case 16: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOutputFileType";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createHttpMethod";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doExecute$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Settings {
        private String myUrl = "/";
        private String myServerName = null;
        private PhpHttpRequestSettings myHttpRequestSettings = new PhpHttpRequestSettings();

        @Attribute(value="server_name")
        public String getServerName() {
            return this.myServerName;
        }

        public void setServerName(String serverName) {
            this.myServerName = serverName;
        }

        @Attribute(value="url")
        public String getUrl() {
            return this.myUrl;
        }

        public void setUrl(String startUrl) {
            this.myUrl = startUrl;
        }

        @Property(surroundWithTag=false)
        @NotNull
        public PhpHttpRequestSettings getHttpRequestSettings() {
            PhpHttpRequestSettings phpHttpRequestSettings = this.myHttpRequestSettings;
            if (phpHttpRequestSettings == null) {
                Settings.$$$reportNull$$$0(0);
            }
            return phpHttpRequestSettings;
        }

        public void setHttpRequestSettings(@NotNull PhpHttpRequestSettings httpRequestSettings) {
            if (httpRequestSettings == null) {
                Settings.$$$reportNull$$$0(1);
            }
            this.myHttpRequestSettings = httpRequestSettings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/run/httpRequest/PhpHttpRequestRunConfiguration$Settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "httpRequestSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHttpRequestSettings";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/run/httpRequest/PhpHttpRequestRunConfiguration$Settings";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setHttpRequestSettings";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

