/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phar;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.jetbrains.php.phar.PharHandlers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PharFileSystem
extends ArchiveFileSystem
implements LocalFileProvider {
    public static final String PHAR_PREFIX = "phar://";
    public static final String PHAR_PROTOCOL = "phar";
    public static final String PHAR_EXTENSION = ".phar";

    public static PharFileSystem getInstance() {
        return (PharFileSystem)VirtualFileManager.getInstance().getFileSystem(PHAR_PROTOCOL);
    }

    @NotNull
    public String getProtocol() {
        if (PHAR_PROTOCOL == null) {
            PharFileSystem.$$$reportNull$$$0(0);
        }
        return PHAR_PROTOCOL;
    }

    @Nullable
    protected String normalize(@NotNull String path) {
        int endIndex;
        if (path == null) {
            PharFileSystem.$$$reportNull$$$0(1);
        }
        if ((endIndex = PharHandlers.fileNameEndIndex(path)) == -1) {
            return null;
        }
        String root = path.substring(0, endIndex);
        return FileUtil.normalize((String)root) + path.substring(endIndex);
    }

    @NotNull
    protected String extractRootPath(@NotNull String path) {
        if (path == null) {
            PharFileSystem.$$$reportNull$$$0(2);
        }
        int endIndex = PharHandlers.fileNameEndIndex(path);
        assert (endIndex > 0) : "Path passed to PharFileSystem must have phar extension '.phar': " + path;
        String string = path.substring(0, endIndex);
        if (string == null) {
            PharFileSystem.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    protected String extractLocalPath(@NotNull String rootPath) {
        if (rootPath == null) {
            PharFileSystem.$$$reportNull$$$0(4);
        }
        String string = rootPath;
        if (string == null) {
            PharFileSystem.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    protected String composeRootPath(@NotNull String localPath) {
        if (localPath == null) {
            PharFileSystem.$$$reportNull$$$0(6);
        }
        String string = localPath;
        if (string == null) {
            PharFileSystem.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    protected ArchiveHandler getHandler(@NotNull VirtualFile entryFile) {
        if (entryFile == null) {
            PharFileSystem.$$$reportNull$$$0(8);
        }
        ArchiveHandler archiveHandler = VfsImplUtil.getHandler((ArchiveFileSystem)this, (VirtualFile)entryFile, localPath -> PharHandlers.create(localPath));
        if (archiveHandler == null) {
            PharFileSystem.$$$reportNull$$$0(9);
        }
        return archiveHandler;
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            PharFileSystem.$$$reportNull$$$0(10);
        }
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        if (path == null) {
            PharFileSystem.$$$reportNull$$$0(11);
        }
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, (String)path);
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            PharFileSystem.$$$reportNull$$$0(12);
        }
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh((NewVirtualFileSystem)this, (boolean)asynchronous);
    }

    protected boolean isCorrectFileType(@NotNull VirtualFile local) {
        if (local == null) {
            PharFileSystem.$$$reportNull$$$0(13);
        }
        return local.getName().contains(PHAR_EXTENSION);
    }

    @Nullable
    public VirtualFile getLocalVirtualFileFor(@Nullable VirtualFile entryVFile) {
        if (entryVFile == null) {
            return null;
        }
        if (!entryVFile.getFileSystem().equals((Object)this)) {
            return null;
        }
        String rootPath = this.extractRootPath(entryVFile.getPath());
        return StandardFileSystems.local().findFileByPath(rootPath);
    }

    @Nullable
    public VirtualFile findLocalVirtualFileByPath(@NotNull String path) {
        if (path == null) {
            PharFileSystem.$$$reportNull$$$0(14);
        }
        return path.contains(PHAR_EXTENSION) ? this.findFileByPath(path) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phar/PharFileSystem";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocol";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phar/PharFileSystem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "extractRootPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "extractLocalPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "composeRootPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractLocalPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "composeRootPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathIfCached";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isCorrectFileType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findLocalVirtualFileByPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

