/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.groupUse;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.intentions.groupUse.PhpConvertUseIntentionBase;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpGroupUseStatementsIntention
extends PhpConvertUseIntentionBase {
    public static final String TEXT = "Group use statements by selected prefix";

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpGroupUseStatementsIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpGroupUseStatementsIntention.$$$reportNull$$$0(1);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        if (!PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel().hasFeature(PhpLanguageFeature.GROUPED_USE)) {
            return false;
        }
        PhpUseList useList = PhpUseImpl.getUseList(element);
        if (useList == null || useList.isTraitImport() || PhpPsiUtil.getChildOfType((PsiElement)useList, PhpElementTypes.USE_BRACES) != null) {
            return false;
        }
        PhpUse useToConvert = this.findNearestUse(element);
        if (useToConvert == null || this.getElementToConvert(element, useToConvert) == null) {
            return false;
        }
        return PhpCodeInsightUtil.findScopeForUseOperator(element) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            PhpGroupUseStatementsIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpGroupUseStatementsIntention.$$$reportNull$$$0(3);
        }
        PhpUseList useList = PhpUseImpl.getUseList(element);
        assert (useList != null);
        PsiElement dummy = PhpGroupUseStatementsIntention.addDummyBefore(project, useList);
        PhpUse useToConvert = this.findNearestUse(element);
        assert (useToConvert != null);
        PsiElement elementToConvert = this.getElementToConvert(element, useToConvert);
        assert (elementToConvert != null);
        PhpReference targetReference = useToConvert.getTargetReference();
        assert (targetReference != null);
        String fqn = targetReference.getFQN();
        assert (fqn != null);
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator(element);
        assert (scope != null);
        String keyword = PhpGroupUseElement.getKeyword(useToConvert, useList);
        String name = this.getName(editor, elementToConvert, targetReference);
        String newFqn = PhpLangUtil.equalsNamespaceNames(fqn, PhpLangUtil.toFQN(name)) ? PhpLangUtil.concat(fqn, "\\") : fqn.substring(0, fqn.length() - name.length());
        ArrayList uses = ContainerUtil.newArrayList();
        for (PhpUseList currentUseList : PhpCodeInsightUtil.collectImports(scope)) {
            for (PhpUse currentUse : currentUseList.getDeclarations()) {
                String currentFqn;
                if (!keyword.equals(PhpGroupUseElement.getKeyword(currentUse, currentUseList)) || !(currentFqn = currentUse.getFQN()).startsWith(newFqn)) continue;
                uses.add(new PhpGroupUseElement(null, currentFqn.substring(newFqn.length()), currentUse.getAliasName()));
                PhpCodeEditUtil.deleteUseOrUseList(currentUse, currentUseList);
            }
        }
        if (!uses.isEmpty()) {
            PhpUseList newUseList = PhpPsiElementFactory.createGroupUseStatementWithKeyword(project, keyword, newFqn, uses);
            dummy.replace((PsiElement)newUseList);
        } else {
            dummy.delete();
        }
    }

    @NotNull
    private static PsiElement addDummyBefore(@NotNull Project project, @NotNull PhpUseList useList) {
        if (project == null) {
            PhpGroupUseStatementsIntention.$$$reportNull$$$0(4);
        }
        if (useList == null) {
            PhpGroupUseStatementsIntention.$$$reportNull$$$0(5);
        }
        PhpUseList dummy = PhpPsiElementFactory.createUseStatement(project, "\\", null);
        PsiElement psiElement = useList.getParent().addBefore((PsiElement)dummy, (PsiElement)useList);
        if (psiElement == null) {
            PhpGroupUseStatementsIntention.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    @NotNull
    public String getText() {
        if (TEXT == null) {
            PhpGroupUseStatementsIntention.$$$reportNull$$$0(7);
        }
        return TEXT;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if (TEXT == null) {
            PhpGroupUseStatementsIntention.$$$reportNull$$$0(8);
        }
        return TEXT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useList";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/groupUse/PhpGroupUseStatementsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/groupUse/PhpGroupUseStatementsIntention";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addDummyBefore";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addDummyBefore";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

